/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver.apps;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xmlresolver.Catalog;
import org.xmlresolver.Resolver;
import org.xmlresolver.helpers.FileURI;
import org.xmlresolver.tools.ResolvingXMLReader;

public class Parse {
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String EXTERNAL_SCHEMA_LOCATION_PROPERTY_ID = "http://apache.org/xml/properties/schema/external-schemaLocation";
    protected static final String EXTERNAL_NONS_SCHEMA_LOCATION_PROPERTY_ID = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";

    public static void main(String[] args) throws FileNotFoundException, IOException {
        Parse parse = new Parse();
        parse.run(args);
    }

    public void run(String[] args) {
        String xmlfile = null;
        String debugLevel = "info";
        int maxErrs = 10;
        boolean nsAware = true;
        boolean validating = true;
        boolean useSchema = false;
        boolean showWarnings = true;
        boolean showErrors = true;
        boolean fullChecking = false;
        Vector<String> xsdFiles = new Vector<String>();
        Vector<String> catalogFiles = new Vector<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-c")) {
                catalogFiles.add(args[++i]);
                continue;
            }
            if (args[i].equals("-w")) {
                validating = false;
                continue;
            }
            if (args[i].equals("-v")) {
                validating = true;
                continue;
            }
            if (args[i].equals("-s")) {
                useSchema = true;
                continue;
            }
            if (args[i].equals("-S")) {
                xsdFiles.add(args[++i]);
                useSchema = true;
                continue;
            }
            if (args[i].equals("-f")) {
                fullChecking = true;
                useSchema = true;
                continue;
            }
            if (args[i].equals("-n")) {
                nsAware = false;
                continue;
            }
            if (args[i].equals("-N")) {
                nsAware = true;
                continue;
            }
            if (args[i].equals("-d")) {
                debugLevel = args[++i];
                continue;
            }
            if (args[i].equals("-E")) {
                String errstr = args[++i];
                try {
                    int errs = Integer.parseInt(errstr);
                    if (errs < 0) continue;
                    maxErrs = errs;
                }
                catch (Exception e) {}
                continue;
            }
            xmlfile = args[i];
        }
        if (xmlfile == null && !fullChecking) {
            System.out.println("Usage: com.nwalsh.parsers.xjparse [opts] xmlfile");
            System.out.println("");
            System.out.println("Where:");
            System.out.println("");
            System.out.println("-c catalogfile   Load a particular catalog file");
            System.out.println("-w               Perform a well-formed parse, not a validating parse");
            System.out.println("-v               Perform a validating parse (the default)");
            System.out.println("-s               Enable W3C XML Schema validation");
            System.out.println("-S schema.xsd    Use schema.xsd for validation (implies -s)");
            System.out.println("-f               Enable full schema checking (implies -s)");
            System.out.println("-n               Perform a namespace-ignorant parse");
            System.out.println("-N               Perform a namespace-aware parse (the default)");
            System.out.println("-d integer       Set the debug level (warnings are level 2)");
            System.out.println("-E integer       Set the maximum number of errors to display");
            System.out.println("");
            System.out.println("The process ends with error-level 1, if there are errors.");
            System.exit(1);
        }
        Hashtable schemaList = Parse.lookupSchemas(xsdFiles);
        String catalogList = "";
        for (int count = 0; count < catalogFiles.size(); ++count) {
            String file = (String)catalogFiles.elementAt(count);
            if (count > 0) {
                catalogList = catalogList + ";";
            }
            catalogList = catalogList + file;
        }
        Catalog catalog = null;
        catalog = "".equals(catalogList) ? new Catalog() : new Catalog(catalogList);
        catalog.setVerbosity(debugLevel);
        showWarnings = catalog.getVerbosity() >= 2;
        Resolver resolver = new Resolver(catalog);
        ResolvingXMLReader reader = new ResolvingXMLReader(resolver);
        try {
            nsAware = true;
            reader.setFeature("http://xml.org/sax/features/namespaces", nsAware);
            reader.setFeature("http://xml.org/sax/features/validation", validating);
            if (useSchema) {
                reader.setFeature(SCHEMA_VALIDATION_FEATURE_ID, useSchema);
                reader.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, fullChecking);
                if (schemaList != null) {
                    String slh = "";
                    String nons_slh = "";
                    Enumeration nskey = schemaList.keys();
                    while (nskey.hasMoreElements()) {
                        String ns = (String)nskey.nextElement();
                        String xsd = (String)schemaList.get(ns);
                        if ("".equals(ns)) {
                            nons_slh = xsd;
                            if (catalog.getVerbosity() < 3) continue;
                            System.err.println("Hint: ''=" + xsd);
                            continue;
                        }
                        if (!"".equals(slh)) {
                            slh = slh + " ";
                        }
                        slh = slh + ns + " " + xsd;
                        if (catalog.getVerbosity() < 3) continue;
                        System.err.println("Hint: " + ns + "=" + xsd);
                    }
                    if (!"".equals(slh)) {
                        reader.setProperty(EXTERNAL_SCHEMA_LOCATION_PROPERTY_ID, slh);
                    }
                    if (!"".equals(nons_slh)) {
                        reader.setProperty(EXTERNAL_NONS_SCHEMA_LOCATION_PROPERTY_ID, nons_slh);
                    }
                }
            }
        }
        catch (SAXException e) {
            // empty catch block
        }
        XParseError xpe = new XParseError(showErrors, showWarnings);
        xpe.setMaxMessages(maxErrs);
        reader.setErrorHandler(xpe);
        Date startTime = null;
        try {
            if (xmlfile != null) {
                String nsType;
                String parseType = validating ? "validating" : "well-formed";
                String string = nsType = nsAware ? "namespace-aware" : "namespace-ignorant";
                if (maxErrs > 0) {
                    System.out.println("Attempting " + parseType + ", " + nsType + " parse");
                }
                startTime = new Date();
                reader.parse(xmlfile);
            } else {
                System.exit(0);
            }
        }
        catch (SAXException sx) {
            System.out.println("SAX Exception: " + sx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Date endTime = new Date();
        long millisec = endTime.getTime() - startTime.getTime();
        long secs = 0L;
        long mins = 0L;
        long hours = 0L;
        if (millisec > 1000L) {
            secs = millisec / 1000L;
            millisec %= 1000L;
        }
        if (secs > 60L) {
            mins = secs / 60L;
            secs %= 60L;
        }
        if (mins > 60L) {
            hours = mins / 60L;
            mins %= 60L;
        }
        if (maxErrs > 0) {
            System.out.print("Parse ");
            if (xpe.getFatalCount() > 0) {
                System.out.print("failed ");
            } else {
                System.out.print("succeeded ");
                System.out.print("(");
                if (hours > 0L) {
                    System.out.print(hours + ":");
                }
                if (hours > 0L || mins > 0L) {
                    System.out.print(mins + ":");
                }
                System.out.print(secs + "." + millisec);
                System.out.print(") ");
            }
            System.out.print("with ");
            int errCount = xpe.getErrorCount();
            int warnCount = xpe.getWarningCount();
            if (errCount > 0) {
                System.out.print(errCount + " error");
                System.out.print(errCount > 1 ? "s" : "");
                System.out.print(" and ");
            } else {
                System.out.print("no errors and ");
            }
            if (warnCount > 0) {
                System.out.print(warnCount + " warning");
                System.out.print(warnCount > 1 ? "s" : "");
                System.out.print(".");
            } else {
                System.out.print("no warnings.");
            }
            System.out.println("");
        }
        if (xpe.getErrorCount() > 0) {
            System.exit(1);
        }
    }

    private static Hashtable lookupSchemas(Vector xsdFiles) {
        Hashtable<String, String> mapping = new Hashtable<String, String>();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringComments(true);
            dbf.setNamespaceAware(true);
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Enumeration xsdenum = xsdFiles.elements();
            while (xsdenum.hasMoreElements()) {
                String xsd = (String)xsdenum.nextElement();
                Document doc = db.parse(xsd = xsd.replaceAll(" ", "%20"));
                Element s = doc.getDocumentElement();
                String targetNS = s.getAttribute("targetNamespace");
                if (targetNS == null || "".equals(targetNS)) {
                    mapping.put("", xsd);
                    continue;
                }
                mapping.put(targetNS, xsd);
            }
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return mapping;
    }

    class XParseError
    implements ErrorHandler {
        private boolean showErrors = true;
        private boolean showWarnings = false;
        private int maxMessages = 10;
        private int fatalCount = 0;
        private int errorCount = 0;
        private int warningCount = 0;
        private String baseURI = "";

        public XParseError(boolean errors, boolean warnings) {
            this.showErrors = errors;
            this.showWarnings = warnings;
            try {
                URI uri = FileURI.makeURI("basename");
                this.baseURI = uri.toURL().toString();
            }
            catch (MalformedURLException mue) {
                // empty catch block
            }
        }

        public int getErrorCount() {
            return this.errorCount;
        }

        public int getFatalCount() {
            return this.fatalCount;
        }

        public int getWarningCount() {
            return this.warningCount;
        }

        public int getMaxMessages() {
            return this.maxMessages;
        }

        public void setMaxMessages(int max) {
            this.maxMessages = max;
        }

        public void error(SAXParseException exception) {
            ++this.errorCount;
            if (this.showErrors && this.errorCount + this.warningCount < this.maxMessages) {
                this.message("Error", exception);
            }
        }

        public void fatalError(SAXParseException exception) {
            ++this.errorCount;
            ++this.fatalCount;
            if (this.showErrors && this.errorCount + this.warningCount < this.maxMessages) {
                this.message("Fatal error", exception);
            }
        }

        public void warning(SAXParseException exception) {
            ++this.warningCount;
            if (this.showWarnings && this.errorCount + this.warningCount < this.maxMessages) {
                this.message("Warning", exception);
            }
        }

        private void message(String type, SAXParseException exception) {
            String filename = exception.getSystemId();
            if (filename.startsWith(this.baseURI)) {
                filename = filename.substring(this.baseURI.length());
            }
            System.out.print(type + ":" + filename + ":" + exception.getLineNumber());
            if (exception.getColumnNumber() > 0) {
                System.out.print(":" + exception.getColumnNumber());
            }
            System.out.println(":" + exception.getMessage());
        }
    }
}

