# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

# ebuild generated by hackport 0.8.2.0.9999
#hackport: flags: -devel,-doc,-h2spec

CABAL_FEATURES="lib profile haddock hoogle hscolour test-suite"
inherit haskell-cabal

DESCRIPTION="HTTP/2 library"
HOMEPAGE="https://github.com/kazu-yamamoto/http2"

LICENSE="BSD"
SLOT="0/${PV}"
KEYWORDS="~amd64 ~arm64 ~ppc64 ~riscv ~x86"

RESTRICT=test # requires network to run one of the test suites

RDEPEND="dev-haskell/async:=[profile?]
	dev-haskell/case-insensitive:=[profile?]
	dev-haskell/http-types:=[profile?]
	dev-haskell/network:=[profile?]
	>=dev-haskell/network-byte-order-0.1.5:=[profile?]
	dev-haskell/psqueues:=[profile?]
	dev-haskell/time-manager:=[profile?]
	dev-haskell/unix-time:=[profile?]
	dev-haskell/unliftio:=[profile?]
	>=dev-lang/ghc-8.8.1:=
"
DEPEND="${RDEPEND}
	>=dev-haskell/cabal-3.0.0.0
	test? ( >=dev-haskell/aeson-2
		dev-haskell/aeson-pretty
		>=dev-haskell/base16-bytestring-1.0
		dev-haskell/cryptonite
		>=dev-haskell/glob-0.9
		>=dev-haskell/hspec-1.3
		>=dev-haskell/network-run-0.1.0
		dev-haskell/text
		dev-haskell/typed-process
		dev-haskell/unordered-containers
		dev-haskell/vector )
"

src_configure() {
	haskell-cabal_src_configure \
		--flag=-devel \
		--flag=-doc \
		--flag=-h2spec
}
