/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_delete_product_group.h
 * @brief implementation of the delete_product_group function for Postgres
 * @author Christian Grothoff
 */
#ifndef PG_DELETE_PRODUCT_GROUP_H
#define PG_DELETE_PRODUCT_GROUP_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"


/**
 * Delete information about a product group.
 *
 * @param cls closure
 * @param instance_id instance to delete product group of
 * @param product_group_id serial number of the group to delete
 * @return database result code
 */
enum GNUNET_DB_QueryStatus
TMH_PG_delete_product_group (void *cls,
                             const char *instance_id,
                             uint64_t product_group_id);

#endif
