/*
   This file is part of TALER
 Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_delete_unit.c
 * @brief Implementation of the delete_unit function for Postgres
 * @author Bohdan Potuzhnyi
 */
#include "platform.h"
#include <taler/taler_error_codes.h>
#include <taler/taler_dbevents.h>
#include <taler/taler_pq_lib.h>
#include "pg_delete_unit.h"
#include "pg_helper.h"


enum GNUNET_DB_QueryStatus
TMH_PG_delete_unit (void *cls,
                    const char *instance_id,
                    const char *unit_id,
                    bool *no_instance,
                    bool *no_unit,
                    bool *builtin_conflict)
{
  struct PostgresClosure *pg = cls;
  struct GNUNET_PQ_QueryParam params[] = {
    GNUNET_PQ_query_param_string (instance_id),
    GNUNET_PQ_query_param_string (unit_id),
    GNUNET_PQ_query_param_end
  };
  struct GNUNET_PQ_ResultSpec rs[] = {
    GNUNET_PQ_result_spec_bool ("out_no_instance",
                                no_instance),
    GNUNET_PQ_result_spec_bool ("out_no_unit",
                                no_unit),
    GNUNET_PQ_result_spec_bool ("out_builtin_conflict",
                                builtin_conflict),
    GNUNET_PQ_result_spec_end
  };
  enum GNUNET_DB_QueryStatus qs;

  check_connection (pg);
  PREPARE (pg,
           "delete_unit",
           "SELECT"
           " out_no_instance"
           " ,out_no_unit"
           " ,out_builtin_conflict"
           " FROM merchant_do_delete_unit($1,$2);");
  qs = GNUNET_PQ_eval_prepared_singleton_select (pg->conn,
                                                 "delete_unit",
                                                 params,
                                                 rs);
  GNUNET_PQ_cleanup_query_params_closures (params);
  return qs;
}
