<p align="center">
  <img alt="Linaria" src="https://raw.githubusercontent.com/callstack/linaria/HEAD/website/assets/linaria-logo@2x.png" width="496">
</p>

<p align="center">
Zero-runtime CSS in JS library.
</p>

---

### 📖 Please refer to the [GitHub](https://github.com/callstack/linaria#readme) for full documentation.

## Features

- Write CSS in JS, but with **zero runtime**, CSS is extracted to CSS files during build
- Familiar **CSS syntax** with Sass like nesting
- Use **dynamic prop based styles** with the React bindings, uses CSS variables behind the scenes
- Easily find where the style was defined with **CSS sourcemaps**
- **Lint your CSS** in JS with [stylelint](https://github.com/stylelint/stylelint)
- Use **JavaScript for logic**, no CSS preprocessor needed
- Optionally use any **CSS preprocessor** such as Sass or PostCSS

**[Why use Linaria](../../docs/BENEFITS.md)**

## Installation

```sh
npm install @linaria/core @linaria/react @linaria/babel-preset @linaria/shaker
```

or

```sh
yarn add @linaria/core @linaria/react @linaria/babel-preset @linaria/shaker
```
