"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const node_path_1 = __importDefault(require("node:path"));
const node_fs_1 = require("node:fs");
const electron_1 = require("electron");
const electron_better_ipc_1 = require("electron-better-ipc");
const electron_updater_1 = require("electron-updater");
const electron_dl_1 = __importDefault(require("electron-dl"));
const electron_context_menu_1 = __importDefault(require("electron-context-menu"));
const electron_localshortcut_1 = __importDefault(require("electron-localshortcut"));
const electron_debug_1 = __importDefault(require("electron-debug"));
const electron_util_1 = require("electron-util");
const facebook_locales_1 = require("facebook-locales");
const do_not_disturb_1 = __importDefault(require("@sindresorhus/do-not-disturb"));
const menu_1 = __importDefault(require("./menu"));
const config_1 = __importDefault(require("./config"));
const tray_1 = __importDefault(require("./tray"));
const util_1 = require("./util");
const emoji_1 = require("./emoji");
const ensure_online_1 = __importDefault(require("./ensure-online"));
const menu_bar_mode_1 = require("./menu-bar-mode");
const constants_1 = require("./constants");
electron_better_ipc_1.ipcMain.setMaxListeners(100);
(0, electron_debug_1.default)({
    isEnabled: true,
    showDevTools: false,
});
(0, electron_dl_1.default)();
(0, electron_context_menu_1.default)({
    showCopyImageAddress: true,
    prepend(defaultActions) {
        /*
        TODO: Use menu option or use replacement of options (https://github.com/sindresorhus/electron-context-menu/issues/70)
        See explanation for this hacky solution here: https://github.com/sindresorhus/caprine/pull/1169
        */
        defaultActions.copyLink({
            transform: util_1.stripTrackingFromUrl,
        });
        return [];
    },
});
electron_1.app.setAppUserModelId('com.sindresorhus.caprine');
if (!config_1.default.get('hardwareAcceleration')) {
    electron_1.app.disableHardwareAcceleration();
}
if (!electron_util_1.is.development && config_1.default.get('autoUpdate')) {
    (async () => {
        const FOUR_HOURS = 1000 * 60 * 60 * 4;
        setInterval(async () => {
            await electron_updater_1.autoUpdater.checkForUpdatesAndNotify();
        }, FOUR_HOURS);
        await electron_updater_1.autoUpdater.checkForUpdatesAndNotify();
    })();
}
let mainWindow;
let isQuitting = false;
let previousMessageCount = 0;
let dockMenu;
let isDNDEnabled = false;
if (!electron_1.app.requestSingleInstanceLock()) {
    electron_1.app.quit();
}
electron_1.app.on('second-instance', () => {
    if (mainWindow) {
        if (mainWindow.isMinimized()) {
            mainWindow.restore();
        }
        mainWindow.show();
    }
});
// Preserves the window position when a display is removed and Caprine is moved to a different screen.
electron_1.app.on('ready', () => {
    electron_1.screen.on('display-removed', () => {
        const [x, y] = mainWindow.getPosition();
        mainWindow.setPosition(x, y);
    });
});
async function updateBadge(messageCount) {
    if (!electron_util_1.is.windows) {
        if (config_1.default.get('showUnreadBadge') && !isDNDEnabled) {
            electron_1.app.badgeCount = messageCount;
        }
        if (electron_util_1.is.macos
            && !isDNDEnabled
            && config_1.default.get('bounceDockOnMessage')
            && previousMessageCount !== messageCount) {
            electron_1.app.dock.bounce('informational');
            previousMessageCount = messageCount;
        }
    }
    if (!electron_util_1.is.macos) {
        if (config_1.default.get('showUnreadBadge')) {
            tray_1.default.setBadge(messageCount > 0);
        }
        if (config_1.default.get('flashWindowOnMessage')) {
            mainWindow.flashFrame(messageCount !== 0);
        }
    }
    tray_1.default.update(messageCount);
    if (electron_util_1.is.windows) {
        if (!config_1.default.get('showUnreadBadge') || messageCount === 0) {
            mainWindow.setOverlayIcon(null, '');
        }
        else {
            // Delegate drawing of overlay icon to renderer process
            updateOverlayIcon(await electron_better_ipc_1.ipcMain.callRenderer(mainWindow, 'render-overlay-icon', messageCount));
        }
    }
}
function updateOverlayIcon({ data, text }) {
    const img = electron_1.nativeImage.createFromDataURL(data);
    mainWindow.setOverlayIcon(img, text);
}
function enableHiresResources() {
    const scaleFactor = Math.max(...electron_1.screen.getAllDisplays().map(display => display.scaleFactor));
    if (scaleFactor === 1) {
        return;
    }
    const filter = { urls: [`*://*.${util_1.messengerDomain}/`] };
    electron_1.session.defaultSession.webRequest.onBeforeSendHeaders(filter, (details, callback) => {
        let cookie = details.requestHeaders.Cookie;
        if (cookie && details.method === 'GET') {
            cookie = /(?:; )?dpr=\d/.test(cookie) ? cookie.replace(/dpr=\d/, `dpr=${scaleFactor}`) : `${cookie}; dpr=${scaleFactor}`;
            details.requestHeaders.Cookie = cookie;
        }
        callback({
            cancel: false,
            requestHeaders: details.requestHeaders,
        });
    });
}
function initRequestsFiltering() {
    const filter = {
        urls: [
            `*://*.${util_1.messengerDomain}/*typ.php*`,
            `*://*.${util_1.messengerDomain}/*change_read_status.php*`,
            `*://*.${util_1.messengerDomain}/*delivery_receipts*`,
            `*://*.${util_1.messengerDomain}/*unread_threads*`,
            '*://*.fbcdn.net/images/emoji.php/v9/*',
            '*://*.facebook.com/images/emoji.php/v9/*', // Emoji
        ],
    };
    electron_1.session.defaultSession.webRequest.onBeforeRequest(filter, async ({ url }, callback) => {
        if (url.includes('emoji.php')) {
            callback(await (0, emoji_1.process)(url));
        }
        else if (url.includes('typ.php')) {
            callback({ cancel: config_1.default.get('block.typingIndicator') });
        }
        else if (url.includes('change_read_status.php')) {
            callback({ cancel: config_1.default.get('block.chatSeen') });
        }
        else if (url.includes('delivery_receipts') || url.includes('unread_threads')) {
            callback({ cancel: config_1.default.get('block.deliveryReceipt') });
        }
    });
    electron_1.session.defaultSession.webRequest.onHeadersReceived({
        urls: ['*://static.xx.fbcdn.net/rsrc.php/*'],
    }, ({ responseHeaders }, callback) => {
        if (!config_1.default.get('callRingtoneMuted') || !responseHeaders) {
            callback({});
            return;
        }
        const callRingtoneHash = '2NAu/QVqg211BbktgY5GkA==';
        callback({
            cancel: responseHeaders['content-md5'][0] === callRingtoneHash,
        });
    });
}
function setUserLocale() {
    const userLocale = (0, facebook_locales_1.bestFacebookLocaleFor)(electron_1.app.getLocale().replace('-', '_'));
    const cookie = {
        url: 'https://www.messenger.com/',
        name: 'locale',
        secure: true,
        value: userLocale,
    };
    electron_1.session.defaultSession.cookies.set(cookie);
}
function setNotificationsMute(status) {
    const label = 'Mute Notifications';
    const muteMenuItem = electron_1.Menu.getApplicationMenu().getMenuItemById('mute-notifications');
    config_1.default.set('notificationsMuted', status);
    muteMenuItem.checked = status;
    if (electron_util_1.is.macos) {
        const item = dockMenu.items.find(x => x.label === label);
        item.checked = status;
    }
}
function createMainWindow() {
    const lastWindowState = config_1.default.get('lastWindowState');
    // Messenger or Work Chat
    const mainURL = config_1.default.get('useWorkChat')
        ? 'https://work.facebook.com/chat'
        : 'https://www.messenger.com/login/';
    const win = new electron_1.BrowserWindow({
        title: electron_1.app.name,
        show: false,
        x: lastWindowState.x,
        y: lastWindowState.y,
        width: lastWindowState.width,
        height: lastWindowState.height,
        icon: electron_util_1.is.linux ? constants_1.caprineIconPath : undefined,
        minWidth: 400,
        minHeight: 200,
        alwaysOnTop: config_1.default.get('alwaysOnTop'),
        titleBarStyle: 'hiddenInset',
        trafficLightPosition: {
            x: 80,
            y: 20,
        },
        autoHideMenuBar: config_1.default.get('autoHideMenuBar'),
        webPreferences: {
            preload: node_path_1.default.join(__dirname, 'browser.js'),
            contextIsolation: true,
            nodeIntegration: true,
            spellcheck: config_1.default.get('isSpellCheckerEnabled'),
            plugins: true,
        },
    });
    require('@electron/remote/main').initialize();
    require('@electron/remote/main').enable(win.webContents);
    setUserLocale();
    initRequestsFiltering();
    let previousDarkMode = electron_util_1.darkMode.isEnabled;
    electron_util_1.darkMode.onChange(() => {
        if (electron_util_1.darkMode.isEnabled !== previousDarkMode) {
            previousDarkMode = electron_util_1.darkMode.isEnabled;
            win.webContents.send('set-theme');
        }
    });
    if (electron_util_1.is.macos) {
        win.setSheetOffset(40);
    }
    win.loadURL(mainURL);
    win.on('close', event => {
        if (config_1.default.get('quitOnWindowClose')) {
            electron_1.app.quit();
            return;
        }
        // Workaround for https://github.com/electron/electron/issues/20263
        // Closing the app window when on full screen leaves a black screen
        // Exit fullscreen before closing
        if (electron_util_1.is.macos && mainWindow.isFullScreen()) {
            mainWindow.once('leave-full-screen', () => {
                mainWindow.hide();
            });
            mainWindow.setFullScreen(false);
        }
        if (!isQuitting) {
            event.preventDefault();
            // Workaround for https://github.com/electron/electron/issues/10023
            win.blur();
            if (electron_util_1.is.macos) {
                // On macOS we're using `app.hide()` in order to focus the previous window correctly
                electron_1.app.hide();
            }
            else {
                win.hide();
            }
        }
    });
    win.on('focus', () => {
        if (config_1.default.get('flashWindowOnMessage')) {
            // This is a security in the case where messageCount is not reset by page title update
            win.flashFrame(false);
        }
    });
    win.on('resize', () => {
        const { isMaximized } = config_1.default.get('lastWindowState');
        config_1.default.set('lastWindowState', { ...win.getNormalBounds(), isMaximized });
    });
    win.on('maximize', () => {
        config_1.default.set('lastWindowState.isMaximized', true);
    });
    win.on('unmaximize', () => {
        config_1.default.set('lastWindowState.isMaximized', false);
    });
    return win;
}
(async () => {
    await Promise.all([(0, ensure_online_1.default)(), electron_1.app.whenReady()]);
    await (0, menu_1.default)();
    mainWindow = createMainWindow();
    // Workaround for https://github.com/electron/electron/issues/5256
    electron_localshortcut_1.default.register(mainWindow, 'CommandOrControl+=', () => {
        (0, util_1.sendAction)('zoom-in');
    });
    // Start in menu bar mode if enabled, otherwise start normally
    (0, menu_bar_mode_1.setUpMenuBarMode)(mainWindow);
    if (electron_util_1.is.macos) {
        const firstItem = {
            label: 'Mute Notifications',
            type: 'checkbox',
            checked: config_1.default.get('notificationsMuted'),
            async click() {
                setNotificationsMute(await electron_better_ipc_1.ipcMain.callRenderer(mainWindow, 'toggle-mute-notifications'));
            },
        };
        dockMenu = electron_1.Menu.buildFromTemplate([firstItem]);
        electron_1.app.dock.setMenu(dockMenu);
        // Dock icon is hidden initially on macOS
        if (config_1.default.get('showDockIcon')) {
            electron_1.app.dock.show();
        }
        electron_better_ipc_1.ipcMain.once('conversations', () => {
            // Messenger sorts the conversations by unread state.
            // We select the first conversation from the list.
            (0, util_1.sendAction)('jump-to-conversation', 1);
        });
        electron_better_ipc_1.ipcMain.answerRenderer('conversations', (conversations) => {
            if (conversations.length === 0) {
                return;
            }
            const items = conversations.map(({ label, icon }, index) => ({
                label: `${label}`,
                icon: electron_1.nativeImage.createFromDataURL(icon),
                click() {
                    mainWindow.show();
                    (0, util_1.sendAction)('jump-to-conversation', index + 1);
                },
            }));
            electron_1.app.dock.setMenu(electron_1.Menu.buildFromTemplate([firstItem, { type: 'separator' }, ...items]));
        });
    }
    // Update badge on conversations change
    electron_better_ipc_1.ipcMain.answerRenderer('update-tray-icon', async (messageCount) => {
        updateBadge(messageCount);
    });
    enableHiresResources();
    const { webContents } = mainWindow;
    webContents.on('dom-ready', async () => {
        // Set window title to Caprine
        mainWindow.setTitle(electron_1.app.name);
        await (0, menu_1.default)();
        const files = ['browser.css', 'dark-mode.css', 'vibrancy.css', 'code-blocks.css', 'autoplay.css', 'scrollbar.css'];
        const cssPath = node_path_1.default.join(__dirname, '..', 'css');
        for (const file of files) {
            if ((0, node_fs_1.existsSync)(node_path_1.default.join(cssPath, file))) {
                webContents.insertCSS((0, node_fs_1.readFileSync)(node_path_1.default.join(cssPath, file), 'utf8'));
            }
        }
        if (config_1.default.get('useWorkChat') && (0, node_fs_1.existsSync)(node_path_1.default.join(cssPath, 'workchat.css'))) {
            webContents.insertCSS((0, node_fs_1.readFileSync)(node_path_1.default.join(cssPath, 'workchat.css'), 'utf8'));
        }
        if ((0, node_fs_1.existsSync)(node_path_1.default.join(electron_1.app.getPath('userData'), 'custom.css'))) {
            webContents.insertCSS((0, node_fs_1.readFileSync)(node_path_1.default.join(electron_1.app.getPath('userData'), 'custom.css'), 'utf8'));
        }
        if (config_1.default.get('launchMinimized') || electron_1.app.getLoginItemSettings().wasOpenedAsHidden) {
            mainWindow.hide();
            tray_1.default.create(mainWindow);
        }
        else {
            if (config_1.default.get('lastWindowState').isMaximized) {
                mainWindow.maximize();
            }
            mainWindow.show();
        }
        if (electron_util_1.is.macos) {
            electron_better_ipc_1.ipcMain.answerRenderer('update-dnd-mode', async (initialSoundsValue) => {
                do_not_disturb_1.default.on('change', (doNotDisturb) => {
                    isDNDEnabled = doNotDisturb;
                    electron_better_ipc_1.ipcMain.callRenderer(mainWindow, 'toggle-sounds', { checked: isDNDEnabled ? false : initialSoundsValue });
                });
                isDNDEnabled = await do_not_disturb_1.default.isEnabled();
                return isDNDEnabled ? false : initialSoundsValue;
            });
        }
        setNotificationsMute(await electron_better_ipc_1.ipcMain.callRenderer(mainWindow, 'toggle-mute-notifications', {
            defaultStatus: config_1.default.get('notificationsMuted'),
        }));
        electron_better_ipc_1.ipcMain.callRenderer(mainWindow, 'toggle-message-buttons', config_1.default.get('showMessageButtons'));
        await webContents.executeJavaScript((0, node_fs_1.readFileSync)(node_path_1.default.join(__dirname, 'notifications-isolated.js'), 'utf8'));
        if (electron_util_1.is.macos) {
            await Promise.resolve().then(() => __importStar(require('./touch-bar')));
        }
    });
    webContents.setWindowOpenHandler(details => {
        if (details.disposition === 'foreground-tab' || details.disposition === 'background-tab') {
            const url = (0, util_1.stripTrackingFromUrl)(details.url);
            electron_1.shell.openExternal(url);
            return { action: 'deny' };
        }
        if (details.disposition === 'new-window') {
            if (details.url === 'about:blank' || details.url === 'about:blank#blocked') {
                if (details.frameName !== 'about:blank') {
                    // Voice/video call popup
                    return { action: 'allow', overrideBrowserWindowOptions: {
                            show: true,
                            titleBarStyle: 'default',
                            webPreferences: {
                                nodeIntegration: false,
                                preload: node_path_1.default.join(__dirname, 'browser-call.js'),
                            },
                        } };
                }
            }
            else {
                const url = (0, util_1.stripTrackingFromUrl)(details.url);
                electron_1.shell.openExternal(url);
            }
            return { action: 'deny' };
        }
        return { action: 'allow' };
    });
    webContents.on('will-navigate', async (event, url) => {
        const isMessengerDotCom = (url) => {
            const { hostname } = new URL(url);
            return hostname.endsWith('.messenger.com');
        };
        const isTwoFactorAuth = (url) => {
            const twoFactorAuthURL = 'https://www.facebook.com/checkpoint';
            return url.startsWith(twoFactorAuthURL);
        };
        const isWorkChat = (url) => {
            const { hostname, pathname } = new URL(url);
            if (hostname === 'work.facebook.com' || hostname === 'work.workplace.com') {
                return true;
            }
            if (
            // Example: https://company-name.facebook.com/login or
            //   		https://company-name.workplace.com/login
            (hostname.endsWith('.facebook.com') || hostname.endsWith('.workplace.com'))
                && (pathname.startsWith('/login') || pathname.startsWith('/chat'))) {
                return true;
            }
            if (hostname === 'login.microsoftonline.com') {
                return true;
            }
            return false;
        };
        if (isMessengerDotCom(url) || isTwoFactorAuth(url) || isWorkChat(url)) {
            return;
        }
        event.preventDefault();
        await electron_1.shell.openExternal(url);
    });
})();
if (electron_util_1.is.macos) {
    electron_better_ipc_1.ipcMain.answerRenderer('set-vibrancy', () => {
        mainWindow.setBackgroundColor('#80FFFFFF'); // Transparent, workaround for vibrancy issue.
        mainWindow.setVibrancy('sidebar');
    });
}
function toggleMaximized() {
    if (mainWindow.isMaximized()) {
        mainWindow.unmaximize();
    }
    else {
        mainWindow.maximize();
    }
}
electron_better_ipc_1.ipcMain.answerRenderer('titlebar-doubleclick', () => {
    if (electron_util_1.is.macos) {
        const doubleClickAction = electron_1.systemPreferences.getUserDefault('AppleActionOnDoubleClick', 'string');
        if (doubleClickAction === 'Minimize') {
            mainWindow.minimize();
        }
        else if (doubleClickAction === 'Maximize') {
            toggleMaximized();
        }
    }
    else {
        toggleMaximized();
    }
});
electron_1.app.on('activate', () => {
    if (mainWindow) {
        mainWindow.show();
    }
});
electron_1.app.on('before-quit', () => {
    isQuitting = true;
    // Checking whether the window exists to work around an Electron race issue:
    // https://github.com/sindresorhus/caprine/issues/809
    if (mainWindow) {
        const { isMaximized } = config_1.default.get('lastWindowState');
        config_1.default.set('lastWindowState', { ...mainWindow.getNormalBounds(), isMaximized });
    }
});
const notifications = new Map();
electron_better_ipc_1.ipcMain.answerRenderer('notification', ({ id, title, body, icon, silent }) => {
    // Don't send notifications when the window is focused
    if (mainWindow.isFocused()) {
        return;
    }
    const notification = new electron_1.Notification({
        title,
        body: config_1.default.get('notificationMessagePreview') ? body : 'You have a new message',
        hasReply: true,
        icon: electron_1.nativeImage.createFromDataURL(icon),
        silent,
    });
    notifications.set(id, notification);
    notification.on('click', () => {
        (0, util_1.sendAction)('notification-callback', { callbackName: 'onclick', id });
        notifications.delete(id);
    });
    notification.on('reply', (_event, reply) => {
        // We use onclick event used by messenger to go to the right convo
        (0, util_1.sendBackgroundAction)('notification-reply-callback', { callbackName: 'onclick', id, reply });
        notifications.delete(id);
    });
    notification.on('close', () => {
        (0, util_1.sendBackgroundAction)('notification-callback', { callbackName: 'onclose', id });
        notifications.delete(id);
    });
    notification.show();
});
electron_better_ipc_1.ipcMain.answerRenderer('get-config-useWorkChat', async () => config_1.default.get('useWorkChat'));
electron_better_ipc_1.ipcMain.answerRenderer('get-config-showMessageButtons', async () => config_1.default.get('showMessageButtons'));
electron_better_ipc_1.ipcMain.answerRenderer('get-config-theme', async () => config_1.default.get('theme'));
electron_better_ipc_1.ipcMain.answerRenderer('get-config-privateMode', async () => config_1.default.get('privateMode'));
electron_better_ipc_1.ipcMain.answerRenderer('get-config-vibrancy', async () => config_1.default.get('vibrancy'));
electron_better_ipc_1.ipcMain.answerRenderer('get-config-sidebar', async () => config_1.default.get('sidebar'));
electron_better_ipc_1.ipcMain.answerRenderer('get-config-zoomFactor', async () => config_1.default.get('zoomFactor'));
electron_better_ipc_1.ipcMain.answerRenderer('set-config-zoomFactor', async (zoomFactor) => {
    config_1.default.set('zoomFactor', zoomFactor);
});
electron_better_ipc_1.ipcMain.answerRenderer('get-config-keepMeSignedIn', async () => config_1.default.get('keepMeSignedIn'));
electron_better_ipc_1.ipcMain.answerRenderer('set-config-keepMeSignedIn', async (keepMeSignedIn) => {
    config_1.default.set('keepMeSignedIn', keepMeSignedIn);
});
electron_better_ipc_1.ipcMain.answerRenderer('get-config-autoplayVideos', async () => config_1.default.get('autoplayVideos'));
electron_better_ipc_1.ipcMain.answerRenderer('get-config-emojiStyle', async () => config_1.default.get('emojiStyle'));
electron_better_ipc_1.ipcMain.answerRenderer('set-config-emojiStyle', async (emojiStyle) => {
    config_1.default.set('emojiStyle', emojiStyle);
});
