"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const path = __importStar(require("node:path"));
const node_fs_1 = require("node:fs");
const electron_1 = require("electron");
const electron_util_1 = require("electron-util");
const config_1 = __importDefault(require("./config"));
const spell_checker_1 = __importDefault(require("./spell-checker"));
const util_1 = require("./util");
const emoji_1 = require("./emoji");
const menu_bar_mode_1 = require("./menu-bar-mode");
const constants_1 = require("./constants");
async function updateMenu() {
    const newConversationItem = {
        label: 'New Conversation',
        accelerator: 'CommandOrControl+N',
        click() {
            (0, util_1.sendAction)('new-conversation');
        },
    };
    const newRoomItem = {
        label: 'New Room',
        accelerator: 'CommandOrControl+O',
        click() {
            (0, util_1.sendAction)('new-room');
        },
    };
    const switchItems = [
        {
            label: 'Switch to Work Chat…',
            accelerator: 'CommandOrControl+Shift+2',
            visible: !config_1.default.get('useWorkChat'),
            click() {
                config_1.default.set('useWorkChat', true);
                electron_1.app.relaunch();
                electron_1.app.quit();
            },
        },
        {
            label: 'Switch to Messenger…',
            accelerator: 'CommandOrControl+Shift+1',
            visible: config_1.default.get('useWorkChat'),
            click() {
                config_1.default.set('useWorkChat', false);
                electron_1.app.relaunch();
                electron_1.app.quit();
            },
        },
        {
            label: 'Log Out',
            click() {
                (0, util_1.sendAction)('log-out');
            },
        },
    ];
    const vibrancySubmenu = [
        {
            label: 'No Vibrancy',
            type: 'checkbox',
            checked: config_1.default.get('vibrancy') === 'none',
            async click() {
                config_1.default.set('vibrancy', 'none');
                (0, util_1.sendAction)('update-vibrancy');
                await updateMenu();
            },
        },
        {
            label: 'Sidebar-only Vibrancy',
            type: 'checkbox',
            checked: config_1.default.get('vibrancy') === 'sidebar',
            async click() {
                config_1.default.set('vibrancy', 'sidebar');
                (0, util_1.sendAction)('update-vibrancy');
                await updateMenu();
            },
        },
        {
            label: 'Full-window Vibrancy',
            type: 'checkbox',
            checked: config_1.default.get('vibrancy') === 'full',
            async click() {
                config_1.default.set('vibrancy', 'full');
                (0, util_1.sendAction)('update-vibrancy');
                await updateMenu();
            },
        },
    ];
    const themeSubmenu = [
        {
            label: 'Follow System Appearance',
            type: 'checkbox',
            checked: config_1.default.get('theme') === 'system',
            async click() {
                config_1.default.set('theme', 'system');
                (0, util_1.sendAction)('set-theme');
                await updateMenu();
            },
        },
        {
            label: 'Light Mode',
            type: 'checkbox',
            checked: config_1.default.get('theme') === 'light',
            async click() {
                config_1.default.set('theme', 'light');
                (0, util_1.sendAction)('set-theme');
                await updateMenu();
            },
        },
        {
            label: 'Dark Mode',
            type: 'checkbox',
            checked: config_1.default.get('theme') === 'dark',
            async click() {
                config_1.default.set('theme', 'dark');
                (0, util_1.sendAction)('set-theme');
                await updateMenu();
            },
        },
    ];
    const sidebarSubmenu = [
        {
            label: 'Adaptive Sidebar',
            type: 'checkbox',
            checked: config_1.default.get('sidebar') === 'default',
            async click() {
                config_1.default.set('sidebar', 'default');
                (0, util_1.sendAction)('update-sidebar');
                await updateMenu();
            },
        },
        {
            label: 'Hide Sidebar',
            type: 'checkbox',
            checked: config_1.default.get('sidebar') === 'hidden',
            accelerator: 'CommandOrControl+Shift+S',
            async click() {
                // Toggle between default and hidden
                config_1.default.set('sidebar', config_1.default.get('sidebar') === 'hidden' ? 'default' : 'hidden');
                (0, util_1.sendAction)('update-sidebar');
                await updateMenu();
            },
        },
        {
            label: 'Narrow Sidebar',
            type: 'checkbox',
            checked: config_1.default.get('sidebar') === 'narrow',
            async click() {
                config_1.default.set('sidebar', 'narrow');
                (0, util_1.sendAction)('update-sidebar');
                await updateMenu();
            },
        },
        {
            label: 'Wide Sidebar',
            type: 'checkbox',
            checked: config_1.default.get('sidebar') === 'wide',
            async click() {
                config_1.default.set('sidebar', 'wide');
                (0, util_1.sendAction)('update-sidebar');
                await updateMenu();
            },
        },
    ];
    const privacySubmenu = [
        {
            label: 'Block Seen Indicator',
            type: 'checkbox',
            checked: config_1.default.get('block.chatSeen'),
            click(menuItem) {
                config_1.default.set('block.chatSeen', menuItem.checked);
            },
        },
        {
            label: 'Block Typing Indicator',
            type: 'checkbox',
            checked: config_1.default.get('block.typingIndicator'),
            click(menuItem) {
                config_1.default.set('block.typingIndicator', menuItem.checked);
            },
        },
        {
            label: 'Block Delivery Receipts',
            type: 'checkbox',
            checked: config_1.default.get('block.deliveryReceipt'),
            click(menuItem) {
                config_1.default.set('block.deliveryReceipt', menuItem.checked);
            },
        },
    ];
    const advancedSubmenu = [
        {
            label: 'Custom Styles',
            click() {
                const filePath = path.join(electron_1.app.getPath('userData'), 'custom.css');
                const defaultCustomStyle = `/*
This is the custom styles file where you can add anything you want.
The styles here will be injected into Caprine and will override default styles.
If you want to disable styles but keep the config, just comment the lines that you don't want to be used.

Press Command/Ctrl+R in Caprine to see your changes.
*/
`;
                if (!(0, node_fs_1.existsSync)(filePath)) {
                    (0, node_fs_1.writeFileSync)(filePath, defaultCustomStyle, 'utf8');
                }
                electron_1.shell.openPath(filePath);
            },
        },
    ];
    const preferencesSubmenu = [
        {
            /* TODO: Fix privacy features */
            /* If you want to help, see #1688 */
            label: 'Privacy',
            visible: electron_util_1.is.development,
            submenu: privacySubmenu,
        },
        {
            label: 'Emoji Style',
            submenu: await (0, emoji_1.generateSubmenu)(updateMenu),
        },
        {
            label: 'Bounce Dock on Message',
            type: 'checkbox',
            visible: electron_util_1.is.macos,
            checked: config_1.default.get('bounceDockOnMessage'),
            click() {
                config_1.default.set('bounceDockOnMessage', !config_1.default.get('bounceDockOnMessage'));
            },
        },
        {
            /* TODO: Fix ability to disable autoplay */
            /* GitHub issue: #1845 */
            label: 'Autoplay Videos',
            id: 'video-autoplay',
            type: 'checkbox',
            visible: electron_util_1.is.development,
            checked: config_1.default.get('autoplayVideos'),
            click() {
                config_1.default.set('autoplayVideos', !config_1.default.get('autoplayVideos'));
                (0, util_1.sendAction)('toggle-video-autoplay');
            },
        },
        {
            /* TODO: Fix notifications */
            label: 'Show Message Preview in Notifications',
            type: 'checkbox',
            visible: electron_util_1.is.development,
            checked: config_1.default.get('notificationMessagePreview'),
            click(menuItem) {
                config_1.default.set('notificationMessagePreview', menuItem.checked);
            },
        },
        {
            /* TODO: Fix notifications */
            label: 'Mute Notifications',
            id: 'mute-notifications',
            type: 'checkbox',
            visible: electron_util_1.is.development,
            checked: config_1.default.get('notificationsMuted'),
            click() {
                (0, util_1.sendAction)('toggle-mute-notifications');
            },
        },
        {
            label: 'Mute Call Ringtone',
            type: 'checkbox',
            checked: config_1.default.get('callRingtoneMuted'),
            click() {
                config_1.default.set('callRingtoneMuted', !config_1.default.get('callRingtoneMuted'));
            },
        },
        {
            /* TODO: Fix notification badge */
            label: 'Show Unread Badge',
            type: 'checkbox',
            visible: electron_util_1.is.development,
            checked: config_1.default.get('showUnreadBadge'),
            click() {
                config_1.default.set('showUnreadBadge', !config_1.default.get('showUnreadBadge'));
                (0, util_1.sendAction)('reload');
            },
        },
        {
            label: 'Spell Checker',
            type: 'checkbox',
            checked: config_1.default.get('isSpellCheckerEnabled'),
            click() {
                config_1.default.set('isSpellCheckerEnabled', !config_1.default.get('isSpellCheckerEnabled'));
                (0, util_1.showRestartDialog)('Caprine needs to be restarted to enable or disable the spell checker.');
            },
        },
        {
            label: 'Hardware Acceleration',
            type: 'checkbox',
            checked: config_1.default.get('hardwareAcceleration'),
            click() {
                config_1.default.set('hardwareAcceleration', !config_1.default.get('hardwareAcceleration'));
                (0, util_1.showRestartDialog)('Caprine needs to be restarted to change hardware acceleration.');
            },
        },
        {
            label: 'Show Menu Bar Icon',
            id: 'menuBarMode',
            type: 'checkbox',
            visible: electron_util_1.is.macos,
            checked: config_1.default.get('menuBarMode'),
            click() {
                config_1.default.set('menuBarMode', !config_1.default.get('menuBarMode'));
                (0, menu_bar_mode_1.toggleMenuBarMode)((0, util_1.getWindow)());
            },
        },
        {
            label: 'Always on Top',
            id: 'always-on-top',
            type: 'checkbox',
            accelerator: 'CommandOrControl+Shift+T',
            checked: config_1.default.get('alwaysOnTop'),
            async click(menuItem, focusedWindow, event) {
                if (!config_1.default.get('alwaysOnTop') && config_1.default.get('showAlwaysOnTopPrompt') && event.shiftKey) {
                    const result = await electron_1.dialog.showMessageBox(focusedWindow, {
                        message: 'Are you sure you want the window to stay on top of other windows?',
                        detail: 'This was triggered by Command/Control+Shift+T.',
                        buttons: [
                            'Display on Top',
                            'Don\'t Display on Top',
                        ],
                        defaultId: 0,
                        cancelId: 1,
                        checkboxLabel: 'Don\'t ask me again',
                    });
                    config_1.default.set('showAlwaysOnTopPrompt', !result.checkboxChecked);
                    if (result.response === 0) {
                        config_1.default.set('alwaysOnTop', !config_1.default.get('alwaysOnTop'));
                        focusedWindow?.setAlwaysOnTop(menuItem.checked);
                    }
                    else if (result.response === 1) {
                        menuItem.checked = false;
                    }
                }
                else {
                    config_1.default.set('alwaysOnTop', !config_1.default.get('alwaysOnTop'));
                    focusedWindow?.setAlwaysOnTop(menuItem.checked);
                }
            },
        },
        {
            /* TODO: Add support for Linux */
            label: 'Launch at Login',
            visible: !electron_util_1.is.linux,
            type: 'checkbox',
            checked: electron_1.app.getLoginItemSettings().openAtLogin,
            click(menuItem) {
                electron_1.app.setLoginItemSettings({
                    openAtLogin: menuItem.checked,
                    openAsHidden: menuItem.checked,
                });
            },
        },
        {
            label: 'Auto Hide Menu Bar',
            type: 'checkbox',
            visible: !electron_util_1.is.macos,
            checked: config_1.default.get('autoHideMenuBar'),
            click(menuItem, focusedWindow) {
                config_1.default.set('autoHideMenuBar', menuItem.checked);
                focusedWindow?.setAutoHideMenuBar(menuItem.checked);
                focusedWindow?.setMenuBarVisibility(!menuItem.checked);
                if (menuItem.checked) {
                    electron_1.dialog.showMessageBox({
                        type: 'info',
                        message: 'Press the Alt key to toggle the menu bar.',
                        buttons: ['OK'],
                    });
                }
            },
        },
        {
            label: 'Automatic Updates',
            type: 'checkbox',
            checked: config_1.default.get('autoUpdate'),
            click() {
                config_1.default.set('autoUpdate', !config_1.default.get('autoUpdate'));
            },
        },
        {
            /* TODO: Fix notifications */
            label: 'Flash Window on Message',
            type: 'checkbox',
            visible: electron_util_1.is.development,
            checked: config_1.default.get('flashWindowOnMessage'),
            click(menuItem) {
                config_1.default.set('flashWindowOnMessage', menuItem.checked);
            },
        },
        {
            id: 'showTrayIcon',
            label: 'Show Tray Icon',
            type: 'checkbox',
            enabled: !electron_util_1.is.macos && !config_1.default.get('launchMinimized'),
            checked: config_1.default.get('showTrayIcon'),
            click() {
                (0, util_1.toggleTrayIcon)();
            },
        },
        {
            label: 'Launch Minimized',
            type: 'checkbox',
            visible: !electron_util_1.is.macos,
            checked: config_1.default.get('launchMinimized'),
            click() {
                (0, util_1.toggleLaunchMinimized)(menu);
            },
        },
        {
            label: 'Quit on Window Close',
            type: 'checkbox',
            checked: config_1.default.get('quitOnWindowClose'),
            click() {
                config_1.default.set('quitOnWindowClose', !config_1.default.get('quitOnWindowClose'));
            },
        },
        {
            type: 'separator',
        },
        {
            label: 'Advanced',
            submenu: advancedSubmenu,
        },
    ];
    const viewSubmenu = [
        {
            label: 'Reset Text Size',
            accelerator: 'CommandOrControl+0',
            click() {
                (0, util_1.sendAction)('zoom-reset');
            },
        },
        {
            label: 'Increase Text Size',
            accelerator: 'CommandOrControl+Plus',
            click() {
                (0, util_1.sendAction)('zoom-in');
            },
        },
        {
            label: 'Decrease Text Size',
            accelerator: 'CommandOrControl+-',
            click() {
                (0, util_1.sendAction)('zoom-out');
            },
        },
        {
            type: 'separator',
        },
        {
            label: 'Theme',
            submenu: themeSubmenu,
        },
        {
            label: 'Vibrancy',
            visible: electron_util_1.is.macos,
            submenu: vibrancySubmenu,
        },
        {
            type: 'separator',
        },
        {
            label: 'Hide Names and Avatars',
            id: 'privateMode',
            type: 'checkbox',
            checked: config_1.default.get('privateMode'),
            accelerator: 'CommandOrControl+Shift+N',
            async click(menuItem, _browserWindow, event) {
                if (!config_1.default.get('privateMode') && config_1.default.get('showPrivateModePrompt') && event.shiftKey) {
                    const result = await electron_1.dialog.showMessageBox(_browserWindow, {
                        message: 'Are you sure you want to hide names and avatars?',
                        detail: 'This was triggered by Command/Control+Shift+N.',
                        buttons: [
                            'Hide',
                            'Don\'t Hide',
                        ],
                        defaultId: 0,
                        cancelId: 1,
                        checkboxLabel: 'Don\'t ask me again',
                    });
                    config_1.default.set('showPrivateModePrompt', !result.checkboxChecked);
                    if (result.response === 0) {
                        config_1.default.set('privateMode', !config_1.default.get('privateMode'));
                        (0, util_1.sendAction)('set-private-mode');
                    }
                    else if (result.response === 1) {
                        menuItem.checked = false;
                    }
                }
                else {
                    config_1.default.set('privateMode', !config_1.default.get('privateMode'));
                    (0, util_1.sendAction)('set-private-mode');
                }
            },
        },
        {
            type: 'separator',
        },
        {
            label: 'Sidebar',
            submenu: sidebarSubmenu,
        },
        {
            label: 'Show Message Buttons',
            type: 'checkbox',
            checked: config_1.default.get('showMessageButtons'),
            click() {
                config_1.default.set('showMessageButtons', !config_1.default.get('showMessageButtons'));
                (0, util_1.sendAction)('toggle-message-buttons');
            },
        },
        {
            type: 'separator',
        },
        {
            label: 'Show Main Chats',
            click() {
                (0, util_1.sendAction)('show-chats-view');
            },
        },
        {
            label: 'Show Active Contacts',
            click() {
                (0, util_1.sendAction)('show-people-view');
            },
        },
        {
            label: 'Show Marketplace Chats',
            click() {
                (0, util_1.sendAction)('show-marketplace-view');
            },
        },
        {
            label: 'Show Message Requests',
            click() {
                (0, util_1.sendAction)('show-requests-view');
            },
        },
        {
            label: 'Show Archived Chats',
            click() {
                (0, util_1.sendAction)('show-archive-view');
            },
        },
    ];
    const spellCheckerSubmenu = (0, spell_checker_1.default)();
    const conversationSubmenu = [
        {
            /* TODO: Fix conversation controls */
            label: 'Mute Conversation',
            visible: electron_util_1.is.development,
            accelerator: 'CommandOrControl+Shift+M',
            click() {
                (0, util_1.sendAction)('mute-conversation');
            },
        },
        {
            /* TODO: Fix conversation controls */
            label: 'Hide Conversation',
            visible: electron_util_1.is.development,
            accelerator: 'CommandOrControl+Shift+H',
            click() {
                (0, util_1.sendAction)('hide-conversation');
            },
        },
        {
            /* TODO: Fix conversation controls */
            label: 'Delete Conversation',
            visible: electron_util_1.is.development,
            accelerator: 'CommandOrControl+Shift+D',
            click() {
                (0, util_1.sendAction)('delete-conversation');
            },
        },
        {
            /* TODO: Fix conversation controls */
            label: 'Select Next Conversation',
            visible: electron_util_1.is.development,
            accelerator: 'Control+Tab',
            click() {
                (0, util_1.sendAction)('next-conversation');
            },
        },
        {
            /* TODO: Fix conversation controls */
            label: 'Select Previous Conversation',
            visible: electron_util_1.is.development,
            accelerator: 'Control+Shift+Tab',
            click() {
                (0, util_1.sendAction)('previous-conversation');
            },
        },
        {
            label: 'Find Conversation',
            accelerator: 'CommandOrControl+K',
            click() {
                (0, util_1.sendAction)('find');
            },
        },
        {
            /* TODO: Fix conversation controls */
            label: 'Search in Conversation',
            visible: electron_util_1.is.development,
            accelerator: 'CommandOrControl+F',
            click() {
                (0, util_1.sendAction)('search');
            },
        },
        {
            label: 'Insert GIF',
            accelerator: 'CommandOrControl+G',
            click() {
                (0, util_1.sendAction)('insert-gif');
            },
        },
        {
            label: 'Insert Sticker',
            accelerator: 'CommandOrControl+S',
            click() {
                (0, util_1.sendAction)('insert-sticker');
            },
        },
        {
            label: 'Insert Emoji',
            accelerator: 'CommandOrControl+E',
            click() {
                (0, util_1.sendAction)('insert-emoji');
            },
        },
        {
            label: 'Attach Files',
            accelerator: 'CommandOrControl+T',
            click() {
                (0, util_1.sendAction)('attach-files');
            },
        },
        {
            label: 'Focus Text Input',
            accelerator: 'CommandOrControl+I',
            click() {
                (0, util_1.sendAction)('focus-text-input');
            },
        },
        {
            type: 'separator',
        },
        {
            label: 'Spell Checker Language',
            visible: !electron_util_1.is.macos && config_1.default.get('isSpellCheckerEnabled'),
            submenu: spellCheckerSubmenu,
        },
    ];
    const helpSubmenu = [
        (0, electron_util_1.openUrlMenuItem)({
            label: 'Website',
            url: 'https://sindresorhus.com/caprine',
        }),
        (0, electron_util_1.openUrlMenuItem)({
            label: 'Source Code',
            url: 'https://github.com/sindresorhus/caprine',
        }),
        (0, electron_util_1.openUrlMenuItem)({
            label: 'Donate…',
            url: 'https://github.com/sindresorhus/caprine?sponsor=1',
        }),
        {
            label: 'Report an Issue…',
            click() {
                const body = `
<!-- Please succinctly describe your issue and steps to reproduce it. -->


---

${(0, electron_util_1.debugInfo)()}`;
                (0, electron_util_1.openNewGitHubIssue)({
                    user: 'sindresorhus',
                    repo: 'caprine',
                    body,
                });
            },
        },
    ];
    if (!electron_util_1.is.macos) {
        helpSubmenu.push({
            type: 'separator',
        }, (0, electron_util_1.aboutMenuItem)({
            icon: constants_1.caprineIconPath,
            copyright: 'Created by Sindre Sorhus',
            text: 'Maintainers:\nDušan Simić\nLefteris Garyfalakis\nMichael Quevillon\nNikolas Spiridakis',
            website: 'https://sindresorhus.com/caprine',
        }));
    }
    const debugSubmenu = [
        {
            label: 'Show Settings',
            click() {
                config_1.default.openInEditor();
            },
        },
        {
            label: 'Show App Data',
            click() {
                electron_1.shell.openPath(electron_1.app.getPath('userData'));
            },
        },
        {
            type: 'separator',
        },
        {
            label: 'Delete Settings',
            click() {
                config_1.default.clear();
                electron_1.app.relaunch();
                electron_1.app.quit();
            },
        },
        {
            label: 'Delete App Data',
            click() {
                electron_1.shell.trashItem(electron_1.app.getPath('userData'));
                electron_1.app.relaunch();
                electron_1.app.quit();
            },
        },
    ];
    const macosTemplate = [
        (0, electron_util_1.appMenu)([
            {
                label: 'Caprine Preferences',
                submenu: preferencesSubmenu,
            },
            {
                label: 'Messenger Preferences…',
                accelerator: 'Command+,',
                click() {
                    (0, util_1.sendAction)('show-preferences');
                },
            },
            {
                type: 'separator',
            },
            ...switchItems,
            {
                type: 'separator',
            },
            {
                label: 'Relaunch Caprine',
                click() {
                    electron_1.app.relaunch();
                    electron_1.app.quit();
                },
            },
        ]),
        {
            role: 'fileMenu',
            submenu: [
                newConversationItem,
                newRoomItem,
                {
                    type: 'separator',
                },
                {
                    role: 'close',
                },
            ],
        },
        {
            role: 'editMenu',
        },
        {
            role: 'viewMenu',
            submenu: viewSubmenu,
        },
        {
            label: 'Conversation',
            submenu: conversationSubmenu,
        },
        {
            role: 'windowMenu',
        },
        {
            role: 'help',
            submenu: helpSubmenu,
        },
    ];
    const linuxWindowsTemplate = [
        {
            role: 'fileMenu',
            submenu: [
                newConversationItem,
                newRoomItem,
                {
                    type: 'separator',
                },
                {
                    label: 'Caprine Settings',
                    submenu: preferencesSubmenu,
                },
                {
                    label: 'Messenger Settings',
                    accelerator: 'Control+,',
                    click() {
                        (0, util_1.sendAction)('show-preferences');
                    },
                },
                {
                    type: 'separator',
                },
                ...switchItems,
                {
                    type: 'separator',
                },
                {
                    label: 'Relaunch Caprine',
                    click() {
                        electron_1.app.relaunch();
                        electron_1.app.quit();
                    },
                },
                {
                    role: 'quit',
                },
            ],
        },
        {
            role: 'editMenu',
        },
        {
            role: 'viewMenu',
            submenu: viewSubmenu,
        },
        {
            label: 'Conversation',
            submenu: conversationSubmenu,
        },
        {
            role: 'help',
            submenu: helpSubmenu,
        },
    ];
    const template = electron_util_1.is.macos ? macosTemplate : linuxWindowsTemplate;
    if (electron_util_1.is.development) {
        template.push({
            label: 'Debug',
            submenu: debugSubmenu,
        });
    }
    const menu = electron_1.Menu.buildFromTemplate(template);
    electron_1.Menu.setApplicationMenu(menu);
    return menu;
}
exports.default = updateMenu;
