/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.catalog.parser;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.gradle.api.initialization.dsl.VersionCatalogBuilder;
import org.gradle.api.internal.catalog.parser.StrictVersionParser;
import org.gradle.api.internal.catalog.problems.DefaultCatalogProblemBuilder;
import org.gradle.api.internal.catalog.problems.VersionCatalogProblemId;
import org.gradle.api.problems.DocLink;
import org.gradle.api.problems.ProblemBuilder;
import org.gradle.api.problems.ProblemBuilderDefiningCategory;
import org.gradle.api.problems.ProblemBuilderDefiningLabel;
import org.gradle.api.problems.ProblemBuilderDefiningLocation;
import org.gradle.api.problems.Problems;
import org.gradle.api.problems.ReportableProblem;
import org.gradle.api.problems.Severity;
import org.gradle.internal.RenderingUtils;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.util.internal.TextUtil;
import org.tomlj.Toml;
import org.tomlj.TomlArray;
import org.tomlj.TomlInvalidTypeException;
import org.tomlj.TomlParseError;
import org.tomlj.TomlParseResult;
import org.tomlj.TomlTable;

public class TomlCatalogFileParser {
    public static final String CURRENT_VERSION = "1.1";
    private static final Splitter SPLITTER = Splitter.on((String)":").trimResults();
    private static final String METADATA_KEY = "metadata";
    private static final String LIBRARIES_KEY = "libraries";
    private static final String BUNDLES_KEY = "bundles";
    private static final String VERSIONS_KEY = "versions";
    private static final String PLUGINS_KEY = "plugins";
    private static final Set<String> TOP_LEVEL_ELEMENTS = ImmutableSet.of((Object)"metadata", (Object)"libraries", (Object)"bundles", (Object)"versions", (Object)"plugins");
    private static final Set<String> PLUGIN_COORDINATES = ImmutableSet.of((Object)"id", (Object)"version");
    private static final Set<String> LIBRARY_COORDINATES = ImmutableSet.of((Object)"group", (Object)"name", (Object)"version", (Object)"module");
    private static final Set<String> VERSION_KEYS = ImmutableSet.of((Object)"ref", (Object)"require", (Object)"strictly", (Object)"prefer", (Object)"reject", (Object)"rejectAll", (Object[])new String[0]);
    private final Path catalogFilePath;
    private final VersionCatalogBuilder versionCatalogBuilder;
    private final Supplier<Problems> problemServiceSupplier;

    public TomlCatalogFileParser(Path catalogFilePath, VersionCatalogBuilder builder, Supplier<Problems> problemServiceSupplier) {
        this.catalogFilePath = catalogFilePath;
        this.versionCatalogBuilder = builder;
        this.problemServiceSupplier = problemServiceSupplier;
    }

    public static void parse(Path catalogFilePath, VersionCatalogBuilder builder, Supplier<Problems> problemServiceSupplier) throws IOException {
        new TomlCatalogFileParser(catalogFilePath, builder, problemServiceSupplier).parse();
    }

    private void parse() throws IOException {
        StrictVersionParser strictVersionParser = new StrictVersionParser((Interner<String>)Interners.newStrongInterner());
        try (InputStream inputStream = Files.newInputStream(this.catalogFilePath, new OpenOption[0]);){
            TomlParseResult result = Toml.parse((InputStream)inputStream);
            this.assertNoParseErrors(result, this.catalogFilePath, this.versionCatalogBuilder);
            TomlTable metadataTable = result.getTable(METADATA_KEY);
            this.verifyMetadata(metadataTable);
            TomlTable librariesTable = result.getTable(LIBRARIES_KEY);
            TomlTable bundlesTable = result.getTable(BUNDLES_KEY);
            TomlTable versionsTable = result.getTable(VERSIONS_KEY);
            TomlTable pluginsTable = result.getTable(PLUGINS_KEY);
            Sets.SetView unknownTle = Sets.difference((Set)result.keySet(), TOP_LEVEL_ELEMENTS);
            if (!unknownTle.isEmpty()) {
                throw this.throwVersionCatalogProblemException(this.problemServiceSupplier.get().create(builder -> TomlCatalogFileParser.configureVersionCatalogError(builder, DefaultCatalogProblemBuilder.getProblemInVersionCatalog(this.versionCatalogBuilder) + ", unknown top level elements " + unknownTle, VersionCatalogProblemId.TOML_SYNTAX_ERROR).details("TOML file contains an unexpected top-level element").solution("Make sure the top-level elements of your TOML file is one of " + RenderingUtils.oxfordListOf(TOP_LEVEL_ELEMENTS, (String)"or"))));
            }
            this.parseLibraries(librariesTable, strictVersionParser);
            this.parsePlugins(pluginsTable, strictVersionParser);
            this.parseBundles(bundlesTable);
            this.parseVersions(versionsTable, strictVersionParser);
        }
    }

    @Nonnull
    private static ProblemBuilder configureVersionCatalogError(ProblemBuilderDefiningLabel builder, String message, VersionCatalogProblemId catalogProblemId) {
        return TomlCatalogFileParser.configureVersionCatalogError(builder, message, catalogProblemId, (Function<ProblemBuilderDefiningLocation, ProblemBuilderDefiningCategory>)((Function)ProblemBuilderDefiningLocation::noLocation));
    }

    private static ProblemBuilder configureVersionCatalogError(ProblemBuilderDefiningLabel builder, String message, VersionCatalogProblemId catalogProblemId, Function<ProblemBuilderDefiningLocation, ProblemBuilderDefiningCategory> locationDefiner) {
        ProblemBuilderDefiningLocation definingLocation = builder.label(message, new Object[0]).documentedAt((DocLink)Documentation.userManual((String)"version_catalog_problems", (String)catalogProblemId.name().toLowerCase()));
        ProblemBuilderDefiningCategory definingCategory = (ProblemBuilderDefiningCategory)locationDefiner.apply((Object)definingLocation);
        return definingCategory.category("dependency-version-catalog", new String[]{TextUtil.screamingSnakeToKebabCase((String)catalogProblemId.name())}).severity(Severity.ERROR);
    }

    private void assertNoParseErrors(TomlParseResult result, Path catalogFilePath, VersionCatalogBuilder versionCatalogBuilder) {
        if (result.hasErrors()) {
            List errors = result.errors();
            throw this.throwVersionCatalogProblemException(this.problemServiceSupplier.get().create(builder -> TomlCatalogFileParser.configureVersionCatalogError(builder, DefaultCatalogProblemBuilder.getProblemInVersionCatalog(versionCatalogBuilder) + ", parsing failed with " + errors.size() + " error" + TextUtil.getPluralEnding((Collection)errors) + ".", VersionCatalogProblemId.TOML_SYNTAX_ERROR, (Function<ProblemBuilderDefiningLocation, ProblemBuilderDefiningCategory>)((Function)definingLocation -> {
                errors.forEach(error -> definingLocation.fileLocation(catalogFilePath.toAbsolutePath().toString(), Integer.valueOf(error.position().line()), Integer.valueOf(error.position().column()), null));
                return definingLocation.noLocation();
            })).details(TomlCatalogFileParser.getErrorText(catalogFilePath, errors)).solution("Fix the TOML file according to the syntax described at https://toml.io")));
        }
    }

    private static String getErrorText(Path catalogFilePath, List<TomlParseError> errors) {
        return errors.stream().map(error -> "In file '" + catalogFilePath.toAbsolutePath() + "' at line " + error.position().line() + ", column " + error.position().column() + ": " + error.getMessage()).collect(Collectors.joining("\n"));
    }

    private void verifyMetadata(@Nullable TomlTable metadataTable) {
        String format;
        if (metadataTable != null && (format = metadataTable.getString("format.version")) != null && !CURRENT_VERSION.equals(format)) {
            throw this.throwVersionCatalogProblemException(this.problemServiceSupplier.get().create(builder -> TomlCatalogFileParser.configureVersionCatalogError(builder, DefaultCatalogProblemBuilder.getProblemInVersionCatalog(this.versionCatalogBuilder) + ", unsupported version catalog format " + format + ".", VersionCatalogProblemId.UNSUPPORTED_FORMAT_VERSION).details("This version of Gradle only supports format version 1.1").solution("Try to upgrade to a newer version of Gradle which supports the catalog format version " + format + ".")));
        }
    }

    private void parseLibraries(@Nullable TomlTable librariesTable, StrictVersionParser strictVersionParser) {
        if (librariesTable == null) {
            return;
        }
        librariesTable.keySet().stream().sorted(Comparator.comparing(String::length)).forEach(alias -> this.parseLibrary((String)alias, librariesTable, this.versionCatalogBuilder, strictVersionParser));
    }

    private void parsePlugins(@Nullable TomlTable pluginsTable, StrictVersionParser strictVersionParser) {
        if (pluginsTable == null) {
            return;
        }
        pluginsTable.keySet().stream().sorted(Comparator.comparing(String::length)).forEach(alias -> this.parsePlugin((String)alias, pluginsTable, this.versionCatalogBuilder, strictVersionParser));
    }

    private void parseVersions(@Nullable TomlTable versionsTable, StrictVersionParser strictVersionParser) {
        if (versionsTable == null) {
            return;
        }
        versionsTable.keySet().stream().sorted(Comparator.comparing(String::length)).forEach(alias -> this.parseVersion((String)alias, versionsTable, this.versionCatalogBuilder, strictVersionParser));
    }

    private void parseBundles(@Nullable TomlTable bundlesTable) {
        if (bundlesTable == null) {
            return;
        }
        bundlesTable.keySet().stream().sorted().forEach(alias -> {
            List bundled = this.expectArray("bundle", (String)alias, bundlesTable, (String)alias).toList().stream().map(String::valueOf).collect(Collectors.toList());
            this.versionCatalogBuilder.bundle(alias, bundled);
        });
    }

    @Nullable
    private String expectString(String kind, String name, TomlTable table, @Nullable String element) {
        try {
            String path = name;
            if (element != null) {
                path = path + "." + element;
            }
            return this.notEmpty(table.getString(path), element, name);
        }
        catch (TomlInvalidTypeException ex) {
            throw this.throwUnexpectedTypeError(kind, name, "a string", ex);
        }
    }

    private RuntimeException throwUnexpectedTypeError(String kind, String name, String typeLabel, TomlInvalidTypeException ex) {
        throw this.throwVersionCatalogProblemException(this.problemServiceSupplier.get().create(builder -> TomlCatalogFileParser.configureVersionCatalogError(builder, "Unexpected type for " + kind + " '" + name + "'", VersionCatalogProblemId.TOML_SYNTAX_ERROR).details("Expected " + typeLabel + " but " + StringUtils.uncapitalize((String)ex.getMessage())).solution("Use " + typeLabel + " instead")));
    }

    @Nullable
    private TomlArray expectArray(String kind, String alias, TomlTable table, String element) {
        try {
            return table.getArray(element);
        }
        catch (TomlInvalidTypeException ex) {
            throw this.throwUnexpectedTypeError(kind, alias, "an array", ex);
        }
    }

    @Nullable
    private Boolean expectBoolean(String kind, String alias, TomlTable table, String element) {
        try {
            return table.getBoolean(element);
        }
        catch (TomlInvalidTypeException ex) {
            throw this.throwUnexpectedTypeError(kind, alias, "a boolean", ex);
        }
    }

    private static void expectedKeys(TomlTable table, Set<String> allowedKeys, String context) {
        Set actualKeys = table.keySet();
        if (!allowedKeys.containsAll(actualKeys)) {
            Sets.SetView difference = Sets.difference((Set)actualKeys, allowedKeys);
            throw new InvalidUserDataException("On " + context + " expected to find any of " + RenderingUtils.oxfordListOf(allowedKeys, (String)"or") + " but found unexpected key" + TextUtil.getPluralEnding((Collection)difference) + " " + RenderingUtils.oxfordListOf((Collection)difference, (String)"and") + ".");
        }
    }

    private void parseLibrary(String alias, TomlTable librariesTable, VersionCatalogBuilder versionCatalogBuilder, StrictVersionParser strictVersionParser) {
        Object gav = librariesTable.get(alias);
        if (gav instanceof String) {
            List split = SPLITTER.splitToList((CharSequence)((String)gav));
            if (split.size() != 3) {
                throw this.throwVersionCatalogProblemException(this.problemServiceSupplier.get().create(builder -> TomlCatalogFileParser.configureVersionCatalogError(builder, DefaultCatalogProblemBuilder.getInVersionCatalog(versionCatalogBuilder.getName()) + ", on alias '" + alias + "' notation '" + gav + "' is not a valid dependency notation.", VersionCatalogProblemId.INVALID_DEPENDENCY_NOTATION).details("When using a string to declare library coordinates, you must use a valid dependency notation").solution("Make sure that the coordinates consist of 3 parts separated by colons, eg: my.group:artifact:1.2")));
            }
            String group = this.notEmpty((String)split.get(0), "group", alias);
            String name = this.notEmpty((String)split.get(1), "name", alias);
            String version = this.notEmpty((String)split.get(2), "version", alias);
            StrictVersionParser.RichVersion rich = strictVersionParser.parse(version);
            TomlCatalogFileParser.registerDependency(versionCatalogBuilder, alias, group, name, null, rich.require, rich.strictly, rich.prefer, null, null);
            return;
        }
        if (gav instanceof TomlTable) {
            TomlCatalogFileParser.expectedKeys((TomlTable)gav, LIBRARY_COORDINATES, "library declaration '" + alias + "'");
        }
        String group = this.expectString("alias", alias, librariesTable, "group");
        String name = this.expectString("alias", alias, librariesTable, "name");
        Object version = librariesTable.get(alias + ".version");
        String mi = this.expectString("alias", alias, librariesTable, "module");
        if (mi != null) {
            List split = SPLITTER.splitToList((CharSequence)mi);
            if (split.size() == 2) {
                group = this.notEmpty((String)split.get(0), "group", alias);
                name = this.notEmpty((String)split.get(1), "name", alias);
            } else {
                throw this.throwVersionCatalogProblemException(this.problemServiceSupplier.get().create(builder -> TomlCatalogFileParser.configureVersionCatalogError(builder, DefaultCatalogProblemBuilder.getInVersionCatalog(versionCatalogBuilder.getName()) + ", on alias '" + alias + "' module '" + mi + "' is not a valid module notation.", VersionCatalogProblemId.INVALID_MODULE_NOTATION).details("When using a string to declare library module coordinates, you must use a valid module notation").solution("Make sure that the module consist of 2 parts separated by colons, eg: my.group:artifact")));
            }
        }
        String versionRef = null;
        String require = null;
        String strictly = null;
        String prefer = null;
        List rejectedVersions = null;
        Boolean rejectAll = null;
        if (version instanceof String) {
            require = (String)version;
            StrictVersionParser.RichVersion richVersion = strictVersionParser.parse(require);
            require = richVersion.require;
            prefer = richVersion.prefer;
            strictly = richVersion.strictly;
        } else if (version instanceof TomlTable) {
            TomlTable versionTable = (TomlTable)version;
            TomlCatalogFileParser.expectedKeys(versionTable, VERSION_KEYS, "version declaration of alias '" + alias + "'");
            versionRef = this.notEmpty(versionTable.getString("ref"), "version reference", alias);
            require = this.notEmpty(versionTable.getString("require"), "required version", alias);
            prefer = this.notEmpty(versionTable.getString("prefer"), "preferred version", alias);
            strictly = this.notEmpty(versionTable.getString("strictly"), "strict version", alias);
            TomlArray rejectedArray = this.expectArray("alias", alias, versionTable, "reject");
            rejectedVersions = rejectedArray != null ? rejectedArray.toList().stream().map(String::valueOf).map(v -> this.notEmpty((String)v, "rejected version", alias)).collect(Collectors.toList()) : null;
            rejectAll = this.expectBoolean("alias", alias, versionTable, "rejectAll");
        } else if (version != null) {
            throw this.throwUnexpectedVersionSyntax(alias, version);
        }
        if (group == null) {
            throw this.throwVersionCatalogAliasException(alias, "group");
        }
        if (name == null) {
            throw this.throwVersionCatalogAliasException(alias, "name");
        }
        TomlCatalogFileParser.registerDependency(versionCatalogBuilder, alias, group, name, versionRef, require, strictly, prefer, rejectedVersions, rejectAll);
    }

    @Nonnull
    private RuntimeException throwVersionCatalogAliasException(String alias, String aliasType) {
        throw this.throwVersionCatalogProblemException(this.problemServiceSupplier.get().create(builder -> TomlCatalogFileParser.configureVersionCatalogError(builder, "Alias definition '" + alias + "' is invalid", VersionCatalogProblemId.TOML_SYNTAX_ERROR).details(StringUtils.capitalize((String)aliasType) + " for alias '" + alias + "' wasn't set").solution("Add the '" + aliasType + "' element on alias '" + alias + "'")));
    }

    private void parsePlugin(String alias, TomlTable librariesTable, VersionCatalogBuilder versionCatalogBuilder, StrictVersionParser strictVersionParser) {
        Object coordinates = librariesTable.get(alias);
        if (coordinates instanceof String) {
            List split = SPLITTER.splitToList((CharSequence)((String)coordinates));
            if (split.size() == 2) {
                String id = this.notEmpty((String)split.get(0), "id", alias);
                String version = this.notEmpty((String)split.get(1), "version", alias);
                StrictVersionParser.RichVersion rich = strictVersionParser.parse(version);
                TomlCatalogFileParser.registerPlugin(versionCatalogBuilder, alias, id, null, rich.require, rich.strictly, rich.prefer, null, null);
                return;
            }
            throw this.throwVersionCatalogProblemException(this.problemServiceSupplier.get().create(builder -> TomlCatalogFileParser.configureVersionCatalogError(builder, DefaultCatalogProblemBuilder.getInVersionCatalog(versionCatalogBuilder.getName()) + ", on alias '" + alias + "' notation '" + coordinates + "' is not a valid plugin notation.", VersionCatalogProblemId.INVALID_PLUGIN_NOTATION).details("When using a string to declare plugin coordinates, you must use a valid plugin notation").solution("Make sure that the coordinates consist of 2 parts separated by colons, eg: my.plugin.id:1.2")));
        }
        if (coordinates instanceof TomlTable) {
            TomlCatalogFileParser.expectedKeys((TomlTable)coordinates, PLUGIN_COORDINATES, "plugin declaration '" + alias + "'");
        }
        String id = this.expectString("alias", alias, librariesTable, "id");
        Object version = librariesTable.get(alias + ".version");
        String versionRef = null;
        String require = null;
        String strictly = null;
        String prefer = null;
        List rejectedVersions = null;
        Boolean rejectAll = null;
        if (version instanceof String) {
            require = (String)version;
            StrictVersionParser.RichVersion richVersion = strictVersionParser.parse(require);
            require = richVersion.require;
            prefer = richVersion.prefer;
            strictly = richVersion.strictly;
        } else if (version instanceof TomlTable) {
            TomlTable versionTable = (TomlTable)version;
            TomlCatalogFileParser.expectedKeys(versionTable, VERSION_KEYS, "version declaration of alias '" + alias + "'");
            versionRef = this.notEmpty(versionTable.getString("ref"), "version reference", alias);
            require = this.notEmpty(versionTable.getString("require"), "required version", alias);
            prefer = this.notEmpty(versionTable.getString("prefer"), "preferred version", alias);
            strictly = this.notEmpty(versionTable.getString("strictly"), "strict version", alias);
            TomlArray rejectedArray = this.expectArray("alias", alias, versionTable, "reject");
            rejectedVersions = rejectedArray != null ? rejectedArray.toList().stream().map(String::valueOf).map(v -> this.notEmpty((String)v, "rejected version", alias)).collect(Collectors.toList()) : null;
            rejectAll = this.expectBoolean("alias", alias, versionTable, "rejectAll");
        } else if (version != null) {
            throw this.throwUnexpectedVersionSyntax(alias, version);
        }
        if (id == null) {
            throw this.throwVersionCatalogProblemException(this.problemServiceSupplier.get().create(builder -> TomlCatalogFileParser.configureVersionCatalogError(builder, "Alias definition '" + alias + "' is invalid", VersionCatalogProblemId.TOML_SYNTAX_ERROR).details("Id for plugin alias '" + alias + "' wasn't set").solution("Add the 'id' element on alias '" + alias + "'")));
        }
        TomlCatalogFileParser.registerPlugin(versionCatalogBuilder, alias, id, versionRef, require, strictly, prefer, rejectedVersions, rejectAll);
    }

    private RuntimeException throwUnexpectedVersionSyntax(String alias, Object version) {
        throw this.throwVersionCatalogProblemException(this.problemServiceSupplier.get().create(builder -> TomlCatalogFileParser.configureVersionCatalogError(builder, "Alias definition '" + alias + "' is invalid", VersionCatalogProblemId.TOML_SYNTAX_ERROR).details("expected a version as a String or a table but got " + version.getClass().getSimpleName()).solution("Use a String notation, e.g version = \"1.1\"").solution("Use a version reference, e.g version.ref = \"some-version\"").solution("Use a rich version table, e.g version = { require=\"[1.0, 2.0[\", prefer=\"1.5\" }")));
    }

    private void parseVersion(String alias, TomlTable versionsTable, VersionCatalogBuilder builder, StrictVersionParser strictVersionParser) {
        String require = null;
        String strictly = null;
        String prefer = null;
        List rejectedVersions = null;
        Boolean rejectAll = null;
        Object version = versionsTable.get(alias);
        if (version instanceof String) {
            require = this.notEmpty((String)version, "version", alias);
            StrictVersionParser.RichVersion richVersion = strictVersionParser.parse(require);
            require = richVersion.require;
            prefer = richVersion.prefer;
            strictly = richVersion.strictly;
        } else if (version instanceof TomlTable) {
            TomlTable versionTable = (TomlTable)version;
            require = this.notEmpty(versionTable.getString("require"), "required version", alias);
            prefer = this.notEmpty(versionTable.getString("prefer"), "preferred version", alias);
            strictly = this.notEmpty(versionTable.getString("strictly"), "strict version", alias);
            TomlArray rejectedArray = this.expectArray("alias", alias, versionTable, "reject");
            rejectedVersions = rejectedArray != null ? rejectedArray.toList().stream().map(String::valueOf).map(v -> this.notEmpty((String)v, "rejected version", alias)).collect(Collectors.toList()) : null;
            rejectAll = this.expectBoolean("alias", alias, versionTable, "rejectAll");
        } else if (version != null) {
            throw this.throwUnexpectedVersionSyntax(alias, version);
        }
        TomlCatalogFileParser.registerVersion(builder, alias, require, strictly, prefer, rejectedVersions, rejectAll);
    }

    @Nullable
    private String notEmpty(@Nullable String string, @Nullable String member, String alias) {
        if (string == null) {
            return null;
        }
        if (string.isEmpty()) {
            throw this.throwVersionCatalogProblemException(this.problemServiceSupplier.get().create(builder -> TomlCatalogFileParser.configureVersionCatalogError(builder, "Alias definition '" + alias + "' is invalid", VersionCatalogProblemId.TOML_SYNTAX_ERROR).details("Empty " + member + " for plugin alias '" + alias + "'" + (member == null ? "value" : StringUtils.capitalize((String)member)) + " for '" + alias + "' must not be empty").solution("Remove the '" + member + "' element on alias '" + alias + "'")));
        }
        return string;
    }

    private static void registerDependency(VersionCatalogBuilder builder, String alias, String group, String name, @Nullable String versionRef, @Nullable String require, @Nullable String strictly, @Nullable String prefer, @Nullable List<String> rejectedVersions, @Nullable Boolean rejectAll) {
        VersionCatalogBuilder.LibraryAliasBuilder aliasBuilder = builder.library(alias, group, name);
        if (versionRef != null) {
            aliasBuilder.versionRef(versionRef);
            return;
        }
        aliasBuilder.version(v -> TomlCatalogFileParser.configureVersion(require, strictly, prefer, rejectedVersions, rejectAll, v));
    }

    private static void configureVersion(@Nullable String require, @Nullable String strictly, @Nullable String prefer, @Nullable List<String> rejectedVersions, @Nullable Boolean rejectAll, MutableVersionConstraint v) {
        if (require != null) {
            v.require(require);
        }
        if (strictly != null) {
            v.strictly(strictly);
        }
        if (prefer != null) {
            v.prefer(prefer);
        }
        if (rejectedVersions != null) {
            v.reject(rejectedVersions.toArray(new String[0]));
        }
        if (rejectAll != null && rejectAll.booleanValue()) {
            v.rejectAll();
        }
    }

    private static void registerPlugin(VersionCatalogBuilder builder, String alias, String id, @Nullable String versionRef, @Nullable String require, @Nullable String strictly, @Nullable String prefer, @Nullable List<String> rejectedVersions, @Nullable Boolean rejectAll) {
        VersionCatalogBuilder.PluginAliasBuilder aliasBuilder = builder.plugin(alias, id);
        if (versionRef != null) {
            aliasBuilder.versionRef(versionRef);
            return;
        }
        aliasBuilder.version(v -> TomlCatalogFileParser.configureVersion(require, strictly, prefer, rejectedVersions, rejectAll, v));
    }

    private static void registerVersion(VersionCatalogBuilder builder, String alias, @Nullable String require, @Nullable String strictly, @Nullable String prefer, @Nullable List<String> rejectedVersions, @Nullable Boolean rejectAll) {
        builder.version(alias, v -> TomlCatalogFileParser.configureVersion(require, strictly, prefer, rejectedVersions, rejectAll, v));
    }

    private RuntimeException throwVersionCatalogProblemException(ReportableProblem problem) {
        throw DefaultCatalogProblemBuilder.throwErrorWithNewProblemsApi("Invalid TOML catalog definition", (Collection<ReportableProblem>)ImmutableList.of((Object)problem));
    }
}

