/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FilePermissions;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.DefaultFilePermissions;
import org.gradle.api.internal.file.archive.AbstractArchiveFileTree;
import org.gradle.api.internal.file.archive.AbstractArchiveFileTreeElement;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.resources.ResourceException;
import org.gradle.api.resources.internal.ReadableResourceInternal;
import org.gradle.cache.internal.DecompressionCache;
import org.gradle.internal.file.Chmod;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.util.internal.GFileUtils;

public class TarFileTree
extends AbstractArchiveFileTree {
    private final Provider<File> tarFileProvider;
    private final Provider<ReadableResourceInternal> resource;
    private final Chmod chmod;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;
    private final FileHasher fileHasher;

    public TarFileTree(Provider<File> tarFileProvider, Provider<ReadableResourceInternal> resource, Chmod chmod, DirectoryFileTreeFactory directoryFileTreeFactory, FileHasher fileHasher, DecompressionCache decompressionCache) {
        super(decompressionCache);
        this.tarFileProvider = tarFileProvider;
        this.resource = resource;
        this.chmod = chmod;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
        this.fileHasher = fileHasher;
    }

    public String getDisplayName() {
        return String.format("TAR '%s'", ((ReadableResourceInternal)this.resource.get()).getDisplayName());
    }

    public DirectoryFileTree getMirror() {
        return this.directoryFileTreeFactory.create(this.getExpandedDir());
    }

    public void visit(FileVisitor visitor) {
        this.decompressionCache.useCache(() -> {
            BufferedInputStream inputStream;
            try {
                inputStream = new BufferedInputStream(((ReadableResourceInternal)this.resource.get()).read());
            }
            catch (ResourceException e) {
                throw this.cannotExpand((Exception)((Object)e));
            }
            try {
                try {
                    Objects.requireNonNull(visitor);
                    this.visitImpl(visitor, inputStream);
                }
                finally {
                    ((InputStream)inputStream).close();
                }
            }
            catch (Exception e) {
                String message = "Unable to expand " + this.getDisplayName() + "\n  The tar might be corrupted or it is compressed in an unexpected way.\n  By default the tar tree tries to guess the compression based on the file extension.\n  If you need to specify the compression explicitly please refer to the DSL reference.";
                throw new GradleException(message, (Throwable)e);
            }
        });
    }

    private void visitImpl(FileVisitor visitor, InputStream inputStream) throws IOException {
        TarArchiveEntry entry;
        this.checkFormat(inputStream);
        AtomicBoolean stopFlag = new AtomicBoolean();
        DetailsImpl.NoCloseTarArchiveInputStream tar = new DetailsImpl.NoCloseTarArchiveInputStream(inputStream);
        File expandedDir = this.getExpandedDir();
        ReadableResourceInternal resource = (ReadableResourceInternal)this.resource.get();
        while (!stopFlag.get() && (entry = (TarArchiveEntry)tar.getNextEntry()) != null) {
            if (entry.isDirectory()) {
                visitor.visitDir((FileVisitDetails)new DetailsImpl(resource, expandedDir, entry, tar, stopFlag, this.chmod));
                continue;
            }
            visitor.visitFile((FileVisitDetails)new DetailsImpl(resource, expandedDir, entry, tar, stopFlag, this.chmod));
        }
    }

    @Override
    public Provider<File> getBackingFileProvider() {
        return this.tarFileProvider;
    }

    private File getExpandedDir() {
        File tarFile = (File)this.tarFileProvider.get();
        HashCode fileHash = this.hashFile(tarFile);
        String expandedDirName = "tar_" + fileHash;
        return new File(this.decompressionCache.getBaseDir(), expandedDirName);
    }

    private HashCode hashFile(File tarFile) {
        try {
            return this.fileHasher.hash(tarFile);
        }
        catch (Exception e) {
            throw this.cannotExpand(e);
        }
    }

    private RuntimeException cannotExpand(Exception e) {
        throw new InvalidUserDataException(String.format("Cannot expand %s.", this.getDisplayName()), (Throwable)e);
    }

    private void checkFormat(InputStream inputStream) throws IOException {
        if (!inputStream.markSupported()) {
            throw new IOException("TAR input stream does not support mark/reset.");
        }
        int tarHeaderSize = 512;
        inputStream.mark(tarHeaderSize);
        byte[] tarHeader = new byte[tarHeaderSize];
        int signatureLength = IOUtils.readFully((InputStream)inputStream, (byte[])tarHeader);
        inputStream.reset();
        if (TarArchiveInputStream.matches((byte[])tarHeader, (int)signatureLength)) {
            return;
        }
        if (signatureLength >= tarHeaderSize) {
            try (TarArchiveInputStream tais = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(tarHeader));){
                TarArchiveEntry tarEntry = tais.getNextTarEntry();
                if (tarEntry == null) {
                    return;
                }
                if (tarEntry.isCheckSumOK()) {
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new IOException("Not a TAR archive");
    }

    private static final class DetailsImpl
    extends AbstractArchiveFileTreeElement {
        private final TarArchiveEntry entry;
        private final NoCloseTarArchiveInputStream tar;
        private final ReadableResourceInternal resource;
        private boolean read;

        public DetailsImpl(ReadableResourceInternal resource, File expandedDir, TarArchiveEntry entry, NoCloseTarArchiveInputStream tar, AtomicBoolean stopFlag, Chmod chmod) {
            super(chmod, expandedDir, stopFlag);
            this.resource = resource;
            this.entry = entry;
            this.tar = tar;
        }

        public String getDisplayName() {
            return String.format("tar entry %s!%s", this.resource.getDisplayName(), this.entry.getName());
        }

        public InputStream open() {
            if (this.read) {
                this.getFile();
                return GFileUtils.openInputStream((File)this.getFile());
            }
            if (this.tar.getCurrentEntry() != this.entry) {
                throw new UnsupportedOperationException(String.format("The contents of %s has already been read.", new Object[]{this}));
            }
            this.read = true;
            return this.tar;
        }

        public FilePermissions getPermissions() {
            return new DefaultFilePermissions(this.entry.getMode());
        }

        @Override
        protected String getEntryName() {
            return this.entry.getName();
        }

        protected TarArchiveEntry getArchiveEntry() {
            return this.entry;
        }

        private static final class NoCloseTarArchiveInputStream
        extends TarArchiveInputStream {
            public NoCloseTarArchiveInputStream(InputStream is) {
                super(is);
            }

            public void close() {
            }
        }
    }
}

