/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Buildable;
import org.gradle.api.Task;
import org.gradle.api.internal.provider.AbstractProviderWithValue;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.internal.tasks.TaskDependencyUtil;
import org.gradle.internal.Factory;

public class BuildableBackedProvider<T>
extends AbstractProviderWithValue<T> {
    private final Buildable buildable;
    private final Class<T> valueType;
    private final Factory<T> valueFactory;

    public BuildableBackedProvider(Buildable buildable, Class<T> valueType, Factory<T> valueFactory) {
        this.buildable = buildable;
        this.valueType = valueType;
        this.valueFactory = valueFactory;
    }

    @Override
    @Nullable
    public Class<T> getType() {
        return this.valueType;
    }

    @Override
    public ValueSupplier.ValueProducer getProducer() {
        return new ValueSupplier.ValueProducer(){

            @Override
            public boolean isProducesDifferentValueOverTime() {
                return false;
            }

            @Override
            public void visitProducerTasks(Action<? super Task> visitor) {
                for (Task dependency : BuildableBackedProvider.this.buildableDependencies()) {
                    visitor.execute((Object)dependency);
                }
            }
        };
    }

    @Override
    public ValueSupplier.ExecutionTimeValue<? extends T> calculateExecutionTimeValue() {
        if (this.contentsAreBuiltByTask()) {
            return ValueSupplier.ExecutionTimeValue.changingValue(this);
        }
        return ValueSupplier.ExecutionTimeValue.fixedValue(this.get());
    }

    private boolean contentsAreBuiltByTask() {
        return !this.buildableDependencies().isEmpty();
    }

    private Set<? extends Task> buildableDependencies() {
        return TaskDependencyUtil.getDependenciesForInternalUse(this.buildable);
    }

    @Override
    protected ValueSupplier.Value<? extends T> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
        return ValueSupplier.Value.ofNullable(this.valueFactory.create());
    }
}

