/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.compilerapi.constants;

import java.util.Collections;
import java.util.Map;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.constants.ConstantToDependentsMappingBuilder;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.deps.DependentsSet;

public class ConstantToDependentsMapping {
    private final Map<String, DependentsSet> constantDependents;

    public ConstantToDependentsMapping(Map<String, DependentsSet> constantDependents) {
        this.constantDependents = constantDependents;
    }

    public Map<String, DependentsSet> getConstantDependents() {
        return this.constantDependents;
    }

    public DependentsSet getConstantDependentsForClass(String constantOrigin) {
        return this.constantDependents.getOrDefault(constantOrigin, DependentsSet.empty());
    }

    public static ConstantToDependentsMapping empty() {
        return new ConstantToDependentsMapping(Collections.emptyMap());
    }

    public static ConstantToDependentsMappingBuilder builder() {
        return new ConstantToDependentsMappingBuilder();
    }
}

