/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental.sourceparser;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.internal.serialize.AbstractCollectionSerializer;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.ListSerializer;
import org.gradle.internal.serialize.Serializer;
import org.gradle.language.nativeplatform.internal.Expression;
import org.gradle.language.nativeplatform.internal.Include;
import org.gradle.language.nativeplatform.internal.IncludeDirectives;
import org.gradle.language.nativeplatform.internal.IncludeType;
import org.gradle.language.nativeplatform.internal.Macro;
import org.gradle.language.nativeplatform.internal.MacroFunction;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.ArgsMappingMacroFunction;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.ComplexExpression;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.DefaultIncludeDirectives;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.IncludeWithMacroFunctionCallExpression;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.IncludeWithSimpleExpression;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.MacroWithComplexExpression;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.MacroWithSimpleExpression;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.ReturnFixedValueMacroFunction;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.ReturnParameterMacroFunction;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.SimpleExpression;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.UnresolvableMacro;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.UnresolvableMacroFunction;

public class IncludeDirectivesSerializer
implements Serializer<IncludeDirectives> {
    public static final IncludeDirectivesSerializer INSTANCE = new IncludeDirectivesSerializer();
    private final Serializer<IncludeType> enumSerializer = new BaseSerializerFactory().getSerializerFor(IncludeType.class);
    private final Serializer<Expression> expressionSerializer = new ExpressionSerializer(this.enumSerializer);
    private final ListSerializer<Include> includeListSerializer = new ListSerializer((Serializer)new IncludeSerializer(this.enumSerializer, this.expressionSerializer));
    private final CollectionSerializer<Macro> macroListSerializer = new CollectionSerializer<Macro>(new MacroSerializer(this.enumSerializer, this.expressionSerializer));
    private final CollectionSerializer<MacroFunction> macroFunctionListSerializer = new CollectionSerializer<MacroFunction>(new MacroFunctionSerializer(this.enumSerializer, this.expressionSerializer));

    private IncludeDirectivesSerializer() {
    }

    public IncludeDirectives read(Decoder decoder) throws Exception {
        return DefaultIncludeDirectives.of((ImmutableList<Include>)ImmutableList.copyOf((Collection)this.includeListSerializer.read(decoder)), (ImmutableList<Macro>)ImmutableList.copyOf((Collection)this.macroListSerializer.read(decoder)), (ImmutableList<MacroFunction>)ImmutableList.copyOf((Collection)this.macroFunctionListSerializer.read(decoder)));
    }

    public void write(Encoder encoder, IncludeDirectives value) throws Exception {
        this.includeListSerializer.write(encoder, (Collection)value.getAll());
        this.macroListSerializer.write(encoder, value.getAllMacros());
        this.macroFunctionListSerializer.write(encoder, value.getAllMacroFunctions());
    }

    private static class CollectionSerializer<T>
    extends AbstractCollectionSerializer<T, Collection<T>> {
        CollectionSerializer(Serializer<T> entrySerializer) {
            super(entrySerializer);
        }

        protected Collection<T> createCollection(int size) {
            return new ArrayList(size);
        }
    }

    private static class MacroFunctionSerializer
    implements Serializer<MacroFunction> {
        private static final byte FIXED_VALUE = 1;
        private static final byte RETURN_PARAM = 2;
        private static final byte MAPPING = 3;
        private static final byte UNRESOLVED = 4;
        private final Serializer<IncludeType> enumSerializer;
        private final Serializer<List<Expression>> expressionSerializer;

        MacroFunctionSerializer(Serializer<IncludeType> enumSerializer, Serializer<Expression> expressionSerializer) {
            this.enumSerializer = enumSerializer;
            this.expressionSerializer = new ListSerializer(expressionSerializer);
        }

        public MacroFunction read(Decoder decoder) throws Exception {
            byte tag = decoder.readByte();
            if (tag == 1) {
                String name = decoder.readString();
                int parameters = decoder.readSmallInt();
                IncludeType type = (IncludeType)this.enumSerializer.read(decoder);
                String value = decoder.readNullableString();
                ImmutableList args = ImmutableList.copyOf((Collection)((Collection)this.expressionSerializer.read(decoder)));
                return new ReturnFixedValueMacroFunction(name, parameters, type, value, (List<Expression>)args);
            }
            if (tag == 2) {
                String name = decoder.readString();
                int parameters = decoder.readSmallInt();
                int parameterToReturn = decoder.readSmallInt();
                return new ReturnParameterMacroFunction(name, parameters, parameterToReturn);
            }
            if (tag == 3) {
                String name = decoder.readString();
                int parameters = decoder.readSmallInt();
                IncludeType type = (IncludeType)this.enumSerializer.read(decoder);
                String value = decoder.readNullableString();
                ImmutableList arguments = ImmutableList.copyOf((Collection)((Collection)this.expressionSerializer.read(decoder)));
                int mapCount = decoder.readSmallInt();
                int[] argsMap = new int[mapCount];
                for (int i = 0; i < mapCount; ++i) {
                    argsMap[i] = decoder.readSmallInt();
                }
                return new ArgsMappingMacroFunction(name, parameters, argsMap, type, value, (List<Expression>)arguments);
            }
            if (tag == 4) {
                String name = decoder.readString();
                int parameters = decoder.readSmallInt();
                return new UnresolvableMacroFunction(name, parameters);
            }
            throw new IllegalArgumentException();
        }

        public void write(Encoder encoder, MacroFunction value) throws Exception {
            if (value instanceof ReturnFixedValueMacroFunction) {
                ReturnFixedValueMacroFunction fixedValueFunction = (ReturnFixedValueMacroFunction)value;
                encoder.writeByte((byte)1);
                encoder.writeString((CharSequence)value.getName());
                encoder.writeSmallInt(value.getParameterCount());
                this.enumSerializer.write(encoder, (Object)fixedValueFunction.getType());
                encoder.writeNullableString((CharSequence)fixedValueFunction.getValue());
                this.expressionSerializer.write(encoder, fixedValueFunction.getArguments());
            } else if (value instanceof ReturnParameterMacroFunction) {
                ReturnParameterMacroFunction returnParameterFunction = (ReturnParameterMacroFunction)value;
                encoder.writeByte((byte)2);
                encoder.writeString((CharSequence)value.getName());
                encoder.writeSmallInt(value.getParameterCount());
                encoder.writeSmallInt(returnParameterFunction.getParameterToReturn());
            } else if (value instanceof ArgsMappingMacroFunction) {
                ArgsMappingMacroFunction argsMappingFunction = (ArgsMappingMacroFunction)value;
                encoder.writeByte((byte)3);
                encoder.writeString((CharSequence)value.getName());
                encoder.writeSmallInt(value.getParameterCount());
                this.enumSerializer.write(encoder, (Object)argsMappingFunction.getType());
                encoder.writeNullableString((CharSequence)argsMappingFunction.getValue());
                this.expressionSerializer.write(encoder, argsMappingFunction.getArguments());
                int[] argsMap = argsMappingFunction.getArgsMap();
                encoder.writeSmallInt(argsMap.length);
                for (int anArgsMap : argsMap) {
                    encoder.writeSmallInt(anArgsMap);
                }
            } else if (value instanceof UnresolvableMacroFunction) {
                encoder.writeByte((byte)4);
                encoder.writeString((CharSequence)value.getName());
                encoder.writeSmallInt(value.getParameterCount());
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    private static class MacroSerializer
    implements Serializer<Macro> {
        private static final byte SIMPLE = 1;
        private static final byte COMPLEX = 2;
        private static final byte UNRESOLVED = 3;
        private final Serializer<IncludeType> enumSerializer;
        private final Serializer<List<Expression>> expressionSerializer;

        MacroSerializer(Serializer<IncludeType> enumSerializer, Serializer<Expression> expressionSerializer) {
            this.enumSerializer = enumSerializer;
            this.expressionSerializer = new ListSerializer(expressionSerializer);
        }

        public Macro read(Decoder decoder) throws Exception {
            byte tag = decoder.readByte();
            if (tag == 1) {
                String name = decoder.readString();
                IncludeType type = (IncludeType)this.enumSerializer.read(decoder);
                String value = decoder.readNullableString();
                return new MacroWithSimpleExpression(name, type, value);
            }
            if (tag == 2) {
                String name = decoder.readString();
                IncludeType type = (IncludeType)this.enumSerializer.read(decoder);
                String value = decoder.readNullableString();
                ImmutableList args = ImmutableList.copyOf((Collection)((Collection)this.expressionSerializer.read(decoder)));
                return new MacroWithComplexExpression(name, type, value, (List<Expression>)args);
            }
            if (tag == 3) {
                String name = decoder.readString();
                return new UnresolvableMacro(name);
            }
            throw new IllegalArgumentException();
        }

        public void write(Encoder encoder, Macro value) throws Exception {
            if (value instanceof MacroWithSimpleExpression) {
                encoder.writeByte((byte)1);
                encoder.writeString((CharSequence)value.getName());
                this.enumSerializer.write(encoder, (Object)value.getType());
                encoder.writeNullableString((CharSequence)value.getValue());
            } else if (value instanceof MacroWithComplexExpression) {
                encoder.writeByte((byte)2);
                encoder.writeString((CharSequence)value.getName());
                this.enumSerializer.write(encoder, (Object)value.getType());
                encoder.writeNullableString((CharSequence)value.getValue());
                this.expressionSerializer.write(encoder, (Object)value.getArguments());
            } else if (value instanceof UnresolvableMacro) {
                encoder.writeByte((byte)3);
                encoder.writeString((CharSequence)value.getName());
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    private static class IncludeSerializer
    implements Serializer<Include> {
        private final Serializer<IncludeType> enumSerializer;
        private final Serializer<Expression> expressionSerializer;

        private IncludeSerializer(Serializer<IncludeType> enumSerializer, Serializer<Expression> expressionSerializer) {
            this.enumSerializer = enumSerializer;
            this.expressionSerializer = expressionSerializer;
        }

        public Include read(Decoder decoder) throws Exception {
            String value = decoder.readString();
            boolean isImport = decoder.readBoolean();
            IncludeType type = (IncludeType)this.enumSerializer.read(decoder);
            int argsCount = decoder.readSmallInt();
            if (argsCount == 0) {
                return IncludeWithSimpleExpression.create(value, isImport, type);
            }
            ArrayList<Expression> args = new ArrayList<Expression>(argsCount);
            for (int i = 0; i < argsCount; ++i) {
                args.add((Expression)this.expressionSerializer.read(decoder));
            }
            return new IncludeWithMacroFunctionCallExpression(value, isImport, (ImmutableList<Expression>)ImmutableList.copyOf(args));
        }

        public void write(Encoder encoder, Include value) throws Exception {
            encoder.writeString((CharSequence)value.getValue());
            encoder.writeBoolean(value.isImport());
            this.enumSerializer.write(encoder, (Object)value.getType());
            if (value instanceof IncludeWithSimpleExpression) {
                encoder.writeSmallInt(0);
            } else if (value instanceof IncludeWithMacroFunctionCallExpression) {
                encoder.writeSmallInt(value.getArguments().size());
                for (Expression expression : value.getArguments()) {
                    this.expressionSerializer.write(encoder, (Object)expression);
                }
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    private static class ExpressionSerializer
    implements Serializer<Expression> {
        private static final byte SIMPLE = 1;
        private static final byte COMPLEX_ONE_ARG = 2;
        private static final byte COMPLEX_MULTIPLE_ARGS = 3;
        private static final byte EMPTY_TOKENS = 4;
        private static final byte EMPTY_ARGS = 5;
        private static final byte COMMA = 6;
        private static final byte LEFT_PAREN = 7;
        private static final byte RIGHT_PAREN = 8;
        private final Serializer<IncludeType> enumSerializer;
        private final Serializer<List<Expression>> argsSerializer;

        ExpressionSerializer(Serializer<IncludeType> enumSerializer) {
            this.enumSerializer = enumSerializer;
            this.argsSerializer = new ListSerializer((Serializer)this);
        }

        public Expression read(Decoder decoder) throws Exception {
            byte tag = decoder.readByte();
            if (tag == 1) {
                String expressionValue = decoder.readNullableString();
                IncludeType expressionType = (IncludeType)this.enumSerializer.read(decoder);
                return new SimpleExpression(expressionValue, expressionType);
            }
            if (tag == 4) {
                return SimpleExpression.EMPTY_EXPRESSIONS;
            }
            if (tag == 5) {
                return SimpleExpression.EMPTY_ARGS;
            }
            if (tag == 6) {
                return SimpleExpression.COMMA;
            }
            if (tag == 7) {
                return SimpleExpression.LEFT_PAREN;
            }
            if (tag == 8) {
                return SimpleExpression.RIGHT_PAREN;
            }
            if (tag == 2) {
                String expressionValue = decoder.readNullableString();
                IncludeType type = (IncludeType)this.enumSerializer.read(decoder);
                ImmutableList args = ImmutableList.of((Object)this.read(decoder));
                return new ComplexExpression(type, expressionValue, (List<Expression>)args);
            }
            if (tag == 3) {
                String expressionValue = decoder.readNullableString();
                IncludeType type = (IncludeType)this.enumSerializer.read(decoder);
                ImmutableList args = ImmutableList.copyOf((Collection)((Collection)this.argsSerializer.read(decoder)));
                return new ComplexExpression(type, expressionValue, (List<Expression>)args);
            }
            throw new IllegalArgumentException();
        }

        public void write(Encoder encoder, Expression value) throws Exception {
            if (value instanceof SimpleExpression) {
                if (value.equals(SimpleExpression.EMPTY_EXPRESSIONS)) {
                    encoder.writeByte((byte)4);
                } else if (value.equals(SimpleExpression.EMPTY_ARGS)) {
                    encoder.writeByte((byte)5);
                } else if (value.equals(SimpleExpression.COMMA)) {
                    encoder.writeByte((byte)6);
                } else if (value.equals(SimpleExpression.LEFT_PAREN)) {
                    encoder.writeByte((byte)7);
                } else if (value.equals(SimpleExpression.RIGHT_PAREN)) {
                    encoder.writeByte((byte)8);
                } else {
                    encoder.writeByte((byte)1);
                    encoder.writeNullableString((CharSequence)value.getValue());
                    this.enumSerializer.write(encoder, (Object)value.getType());
                }
            } else if (value instanceof ComplexExpression) {
                if (value.getArguments().size() == 1) {
                    encoder.writeByte((byte)2);
                    encoder.writeNullableString((CharSequence)value.getValue());
                    this.enumSerializer.write(encoder, (Object)value.getType());
                    this.write(encoder, (Expression)value.getArguments().get(0));
                } else {
                    encoder.writeByte((byte)3);
                    encoder.writeNullableString((CharSequence)value.getValue());
                    this.enumSerializer.write(encoder, (Object)value.getType());
                    this.argsSerializer.write(encoder, (Object)value.getArguments());
                }
            } else {
                throw new IllegalArgumentException();
            }
        }
    }
}

