/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.internal;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.DocsType;
import org.gradle.api.attributes.Usage;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRolesForMigration;
import org.gradle.api.internal.artifacts.dsl.LazyPublishArtifact;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.DefaultSourceSetOutput;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.internal.DefaultJavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.internal.Cast;
import org.gradle.util.internal.TextUtil;

public class JvmPluginsHelper {
    @Deprecated
    public static void configureForSourceSet(SourceSet sourceSet, SourceDirectorySet sourceDirectorySet, AbstractCompile compile, CompileOptions options, Project target) {
        compile.setDescription("Compiles the " + sourceDirectorySet.getDisplayName() + ".");
        compile.setSource((FileTree)sourceSet.getJava());
        JvmPluginsHelper.compileAgainstJavaOutputs(compile, sourceSet, target.getObjects());
        JvmPluginsHelper.configureAnnotationProcessorPath(sourceSet, sourceDirectorySet, options, target);
    }

    public static void compileAgainstJavaOutputs(AbstractCompile compileTask, SourceSet sourceSet, ObjectFactory objectFactory) {
        ConfigurableFileCollection classpath = objectFactory.fileCollection();
        classpath.from(new Object[]{() -> sourceSet.getCompileClasspath().plus((FileCollection)objectFactory.fileCollection().from(new Object[]{sourceSet.getJava().getClassesDirectory()}))});
        compileTask.getConventionMapping().map("classpath", () -> classpath);
    }

    public static void configureAnnotationProcessorPath(SourceSet sourceSet, SourceDirectorySet sourceDirectorySet, CompileOptions options, Project target) {
        ConventionMapping conventionMapping = new DslObject((Object)options).getConventionMapping();
        conventionMapping.map("annotationProcessorPath", () -> ((SourceSet)sourceSet).getAnnotationProcessorPath());
        String annotationProcessorGeneratedSourcesChildPath = "generated/sources/annotationProcessor/" + sourceDirectorySet.getName() + "/" + sourceSet.getName();
        options.getGeneratedSourceOutputDirectory().convention(target.getLayout().getBuildDirectory().dir(annotationProcessorGeneratedSourcesChildPath));
    }

    @Deprecated
    public static void configureOutputDirectoryForSourceSet(SourceSet sourceSet, SourceDirectorySet sourceDirectorySet, Project target, Provider<? extends AbstractCompile> compileTask, Provider<CompileOptions> options) {
        TaskProvider taskProvider = (TaskProvider)Cast.uncheckedCast(compileTask);
        JvmPluginsHelper.configureOutputDirectoryForSourceSet(sourceSet, sourceDirectorySet, target, (TaskProvider<? extends AbstractCompile>)taskProvider, options);
    }

    public static void configureOutputDirectoryForSourceSet(SourceSet sourceSet, SourceDirectorySet sourceDirectorySet, Project target, TaskProvider<? extends AbstractCompile> compileTask, Provider<CompileOptions> options) {
        String sourceSetChildPath = "classes/" + sourceDirectorySet.getName() + "/" + sourceSet.getName();
        sourceDirectorySet.getDestinationDirectory().convention(target.getLayout().getBuildDirectory().dir(sourceSetChildPath));
        DefaultSourceSetOutput sourceSetOutput = (DefaultSourceSetOutput)Cast.cast(DefaultSourceSetOutput.class, (Object)sourceSet.getOutput());
        sourceSetOutput.getClassesDirs().from(new Object[]{sourceDirectorySet.getDestinationDirectory()}).builtBy(new Object[]{compileTask});
        sourceSetOutput.getGeneratedSourcesDirs().from(new Object[]{options.flatMap(CompileOptions::getGeneratedSourceOutputDirectory)});
        sourceDirectorySet.compiledBy(compileTask, AbstractCompile::getDestinationDirectory);
    }

    public static void configureJavaDocTask(String displayName, SourceSet sourceSet, TaskContainer tasks, @Nullable JavaPluginExtension javaPluginExtension) {
        String javadocTaskName = sourceSet.getJavadocTaskName();
        if (!tasks.getNames().contains(javadocTaskName)) {
            tasks.register(javadocTaskName, Javadoc.class, javadoc -> {
                javadoc.setDescription("Generates Javadoc API documentation for the " + displayName + ".");
                javadoc.setGroup("documentation");
                javadoc.setClasspath(sourceSet.getOutput().plus(sourceSet.getCompileClasspath()));
                javadoc.setSource((FileTree)sourceSet.getAllJava());
                if (javaPluginExtension != null) {
                    javadoc.getConventionMapping().map("destinationDir", () -> ((Directory)javaPluginExtension.getDocsDir().dir(javadocTaskName).get()).getAsFile());
                    javadoc.getModularity().getInferModulePath().convention((Provider)javaPluginExtension.getModularity().getInferModulePath());
                }
            });
        }
    }

    public static Configuration createDocumentationVariantWithArtifact(String variantName, @Nullable String featureName, String docsType, List<Capability> capabilities, String jarTaskName, Object artifactSource, ProjectInternal project) {
        Configuration variant = project.getConfigurations().maybeCreateMigratingUnlocked(variantName, ConfigurationRolesForMigration.CONSUMABLE_DEPENDENCY_SCOPE_TO_CONSUMABLE);
        variant.setVisible(false);
        variant.setDescription(docsType + " elements for " + (featureName == null ? "main" : featureName) + ".");
        ObjectFactory objectFactory = project.getObjects();
        AttributeContainer attributes = variant.getAttributes();
        attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)objectFactory.named(Usage.class, "java-runtime")));
        attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)objectFactory.named(Category.class, "documentation")));
        attributes.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)objectFactory.named(Bundling.class, "external")));
        attributes.attribute(DocsType.DOCS_TYPE_ATTRIBUTE, (Object)((DocsType)objectFactory.named(DocsType.class, docsType)));
        capabilities.forEach(arg_0 -> ((ConfigurationPublications)variant.getOutgoing()).capability(arg_0));
        TaskContainerInternal tasks = project.getTasks();
        if (!tasks.getNames().contains(jarTaskName)) {
            TaskProvider jarTask = tasks.register(jarTaskName, Jar.class, jar -> {
                jar.setDescription("Assembles a jar archive containing the " + (featureName == null ? "main " + docsType + "." : docsType + " of the '" + featureName + "' feature."));
                jar.setGroup("build");
                jar.from(new Object[]{artifactSource});
                jar.getArchiveClassifier().set((Object)TextUtil.camelToKebabCase((String)(featureName == null ? docsType : featureName + "-" + docsType)));
            });
            if (tasks.getNames().contains("assemble")) {
                tasks.named("assemble").configure(task -> task.dependsOn(new Object[]{jarTask}));
            }
        }
        TaskProvider jar2 = tasks.named(jarTaskName, Jar.class);
        variant.getOutgoing().artifact((Object)new LazyPublishArtifact((Provider)jar2, project.getFileResolver(), project.getTaskDependencyFactory()));
        return variant;
    }

    public static void configureCompileDefaults(AbstractCompile compile, DefaultJavaPluginExtension javaExtension, BiFunction<JavaVersion, Supplier<JavaVersion>, JavaVersion> compatibilityComputer) {
        ConventionMapping conventionMapping = compile.getConventionMapping();
        conventionMapping.map("sourceCompatibility", () -> JvmPluginsHelper.computeSourceCompatibilityConvention(javaExtension, compatibilityComputer).toString());
        conventionMapping.map("targetCompatibility", () -> JvmPluginsHelper.computeTargetCompatibilityConvention(javaExtension, compile, compatibilityComputer).toString());
    }

    private static JavaVersion computeSourceCompatibilityConvention(DefaultJavaPluginExtension javaExtension, BiFunction<JavaVersion, Supplier<JavaVersion>, JavaVersion> compatibilityComputer) {
        return compatibilityComputer.apply(javaExtension.getRawSourceCompatibility(), javaExtension::getSourceCompatibility);
    }

    private static JavaVersion computeTargetCompatibilityConvention(DefaultJavaPluginExtension javaExtension, AbstractCompile compile, BiFunction<JavaVersion, Supplier<JavaVersion>, JavaVersion> compatibilityComputer) {
        JavaVersion rawTargetCompatibility = javaExtension.getRawTargetCompatibility();
        if (rawTargetCompatibility == null) {
            rawTargetCompatibility = JavaVersion.toVersion((Object)compile.getSourceCompatibility());
        }
        return compatibilityComputer.apply(rawTargetCompatibility, javaExtension::getTargetCompatibility);
    }
}

