/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.problems.DocLink;
import org.gradle.api.problems.Problem;
import org.gradle.api.problems.ProblemCategory;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.DefaultProblemCategory;
import org.gradle.api.problems.locations.ProblemLocation;

@NonNullApi
public class DefaultProblem
implements Problem {
    private String label;
    private Severity severity;
    private List<ProblemLocation> where;
    private DocLink documentationLink;
    private String description;
    private List<String> solutions;
    private Throwable cause;
    private String problemCategory;
    private Map<String, String> additionalMetadata;

    public DefaultProblem(String label, Severity severity, List<ProblemLocation> locations, @Nullable DocLink documentationUrl, @Nullable String description, @Nullable List<String> solutions, @Nullable Throwable cause, String problemCategory, Map<String, String> additionalMetadata) {
        this.label = label;
        this.severity = severity;
        this.where = locations;
        this.documentationLink = documentationUrl;
        this.description = description;
        this.solutions = solutions == null ? Collections.emptyList() : solutions;
        this.cause = cause;
        this.problemCategory = problemCategory;
        this.additionalMetadata = additionalMetadata;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Severity getSeverity() {
        return this.severity;
    }

    @Override
    public List<ProblemLocation> getLocations() {
        return this.where;
    }

    @Override
    @Nullable
    public DocLink getDocumentationLink() {
        return this.documentationLink;
    }

    @Override
    public String getDetails() {
        return this.description;
    }

    @Override
    public List<String> getSolutions() {
        return this.solutions;
    }

    @Override
    public Throwable getException() {
        return this.cause;
    }

    @Override
    public ProblemCategory getProblemCategory() {
        return new DefaultProblemCategory(this.problemCategory);
    }

    @Override
    public Map<String, String> getAdditionalData() {
        return this.additionalMetadata;
    }

    private static boolean equals(@Nullable Object a, @Nullable Object b) {
        return a == b || a != null && a.equals(b);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultProblem that = (DefaultProblem)o;
        return DefaultProblem.equals(this.label, that.label) && this.severity == that.severity && DefaultProblem.equals(this.where, that.where) && DefaultProblem.equals(this.problemCategory, that.problemCategory) && DefaultProblem.equals(this.documentationLink, that.documentationLink) && DefaultProblem.equals(this.description, that.description) && DefaultProblem.equals(this.solutions, that.solutions) && DefaultProblem.equals(this.cause, that.cause) && DefaultProblem.equals(this.additionalMetadata, that.additionalMetadata);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.label, this.severity, this.where, this.documentationLink, this.description, this.solutions, this.cause, this.additionalMetadata});
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }
}

