"use strict";(self.webpackChunkdeck=self.webpackChunkdeck||[]).push([["src_CardSelector_vue"],{48961:(t,e,n)=>{n.d(e,{Z:()=>l});var o=n(87537),a=n.n(o),r=n(23645),s=n.n(r)()(a());s.push([t.id,"\n#modal-inner[data-v-e232cea0] {\n\twidth: 90vw;\n\tmax-width: 400px;\n\tpadding: 20px;\n\theight: 200px;\n}\n.multiselect[data-v-e232cea0] {\n\twidth: 100%;\n\tmargin-bottom: 10px;\n}\nul[data-v-e232cea0] {\n\tmin-height: 100px;\n}\nli[data-v-e232cea0] {\n\tpadding: 6px;\n\tborder: 1px solid transparent;\n}\nli[data-v-e232cea0]:hover, li[data-v-e232cea0]:focus {\n\tbackground-color: var(--color-background-dark);\n}\n.board-bullet[data-v-e232cea0] {\n\tdisplay: inline-block;\n\twidth: 12px;\n\theight: 12px;\n\tborder: none;\n\tborder-radius: 50%;\n\tcursor: pointer;\n}\nbutton[data-v-e232cea0] {\n\tfloat: right;\n}\n.card-selector[data-v-e232cea0] .modal-container {\n\toverflow: visible !important;\n}\n","",{version:3,sources:["webpack://./src/CardSelector.vue"],names:[],mappings:";AAgLA;CACA,WAAA;CACA,gBAAA;CACA,aAAA;CACA,aAAA;AACA;AAEA;CACA,WAAA;CACA,mBAAA;AACA;AAEA;CACA,iBAAA;AACA;AAEA;CACA,YAAA;CACA,6BAAA;AACA;AAEA;CACA,8CAAA;AACA;AAEA;CACA,qBAAA;CACA,WAAA;CACA,YAAA;CACA,YAAA;CACA,kBAAA;CACA,eAAA;AACA;AAEA;CACA,YAAA;AACA;AAEA;CACA,4BAAA;AACA",sourcesContent:["\x3c!--\n  - @copyright Copyright (c) 2019 Julius Härtl <jus@bitgrid.net>\n  -\n  - @author Julius Härtl <jus@bitgrid.net>\n  -\n  - @license GNU AGPL version 3 or any later version\n  -\n  - This program is free software: you can redistribute it and/or modify\n  - it under the terms of the GNU Affero General Public License as\n  - published by the Free Software Foundation, either version 3 of the\n  - License, or (at your option) any later version.\n  -\n  - This program is distributed in the hope that it will be useful,\n  - but WITHOUT ANY WARRANTY; without even the implied warranty of\n  - MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n  - GNU Affero General Public License for more details.\n  -\n  - You should have received a copy of the GNU Affero General Public License\n  - along with this program. If not, see <http://www.gnu.org/licenses/>.\n  -\n  --\x3e\n\n<template>\n\t<NcModal class=\"card-selector\" @close=\"close\">\n\t\t<div id=\"modal-inner\" :class=\"{ 'icon-loading': loading }\">\n\t\t\t<h3>{{ title }}</h3>\n\t\t\t<NcMultiselect v-model=\"selectedBoard\"\n\t\t\t\t:placeholder=\"t('deck', 'Select a board')\"\n\t\t\t\t:options=\"boards\"\n\t\t\t\t:disabled=\"loading\"\n\t\t\t\tlabel=\"title\"\n\t\t\t\t@select=\"fetchCardsFromBoard\">\n\t\t\t\t<template slot=\"singleLabel\" slot-scope=\"props\">\n\t\t\t\t\t<span>\n\t\t\t\t\t\t<span :style=\"{ 'backgroundColor': '#' + props.option.color }\" class=\"board-bullet\" />\n\t\t\t\t\t\t<span>{{ props.option.title }}</span>\n\t\t\t\t\t</span>\n\t\t\t\t</template>\n\t\t\t\t<template slot=\"option\" slot-scope=\"props\">\n\t\t\t\t\t<span>\n\t\t\t\t\t\t<span :style=\"{ 'backgroundColor': '#' + props.option.color }\" class=\"board-bullet\" />\n\t\t\t\t\t\t<span>{{ props.option.title }}</span>\n\t\t\t\t\t</span>\n\t\t\t\t</template>\n\t\t\t</NcMultiselect>\n\n\t\t\t<NcMultiselect v-model=\"selectedCard\"\n\t\t\t\t:placeholder=\"t('deck', 'Select a card')\"\n\t\t\t\t:options=\"cardsFromBoard\"\n\t\t\t\t:disabled=\"loading || selectedBoard === ''\"\n\t\t\t\tlabel=\"title\" />\n\n\t\t\t<button :disabled=\"!isBoardAndStackChoosen\" class=\"primary\" @click=\"select\">\n\t\t\t\t{{ action }}\n\t\t\t</button>\n\t\t\t<button @click=\"close\">\n\t\t\t\t{{ t('deck', 'Cancel') }}\n\t\t\t</button>\n\t\t</div>\n\t</NcModal>\n</template>\n\n<script>\nimport { generateUrl } from '@nextcloud/router'\nimport { NcModal, NcMultiselect } from '@nextcloud/vue'\nimport axios from '@nextcloud/axios'\n\nexport default {\n\tname: 'CardSelector',\n\tcomponents: {\n\t\tNcModal,\n\t\tNcMultiselect,\n\t},\n\tprops: {\n\t\ttitle: {\n\t\t\ttype: String,\n\t\t\tdefault: t('deck', 'Select the card to link to a project'),\n\t\t},\n\t\taction: {\n\t\t\ttype: String,\n\t\t\tdefault: t('deck', 'Link to card'),\n\t\t},\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tboards: [],\n\t\t\tselectedBoard: '',\n\t\t\tcardsFromBoard: [],\n\t\t\tselectedCard: '',\n\t\t\tloading: true,\n\t\t}\n\t},\n\tcomputed: {\n\t\tisBoardAndStackChoosen() {\n\t\t\treturn !(this.selectedBoard === '' || this.selectedCard === '')\n\t\t},\n\t},\n\tbeforeMount() {\n\t\tthis.fetchBoards()\n\t},\n\tmethods: {\n\t\tfetchBoards() {\n\t\t\taxios.get(generateUrl('/apps/deck/boards')).then((response) => {\n\t\t\t\tthis.boards = response.data\n\t\t\t\tthis.loading = false\n\t\t\t})\n\t\t},\n\t\tasync fetchCardsFromBoard(board) {\n\t\t\ttry {\n\t\t\t\tthis.cardsFromBoard = []\n\t\t\t\tconst url = generateUrl('/apps/deck/stacks/' + board.id)\n\t\t\t\tconst response = await axios.get(url)\n\t\t\t\tresponse.data.forEach(stack => {\n\t\t\t\t\tthis.cardsFromBoard.push(...stack.cards)\n\t\t\t\t})\n\t\t\t} catch (err) {\n\t\t\t\treturn err\n\t\t\t}\n\n\t\t},\n\t\tclose() {\n\t\t\tthis.$root.$emit('close')\n\t\t},\n\t\tselect() {\n\t\t\tthis.$root.$emit('select', this.selectedCard.id)\n\n\t\t},\n\t},\n\n}\n<\/script>\n\n<style scoped>\n\t#modal-inner {\n\t\twidth: 90vw;\n\t\tmax-width: 400px;\n\t\tpadding: 20px;\n\t\theight: 200px;\n\t}\n\n\t.multiselect {\n\t\twidth: 100%;\n\t\tmargin-bottom: 10px;\n\t}\n\n\tul {\n\t\tmin-height: 100px;\n\t}\n\n\tli {\n\t\tpadding: 6px;\n\t\tborder: 1px solid transparent;\n\t}\n\n\tli:hover, li:focus {\n\t\tbackground-color: var(--color-background-dark);\n\t}\n\n\t.board-bullet {\n\t\tdisplay: inline-block;\n\t\twidth: 12px;\n\t\theight: 12px;\n\t\tborder: none;\n\t\tborder-radius: 50%;\n\t\tcursor: pointer;\n\t}\n\n\tbutton {\n\t\tfloat: right;\n\t}\n\n\t.card-selector:deep(.modal-container) {\n\t\toverflow: visible !important;\n\t}\n</style>\n"],sourceRoot:""}]);const l=s},4761:(e,n,o)=>{o.r(n),o.d(n,{default:()=>B});var a=o(79753),r=o(15961),s=o(93664);const l={name:"CardSelector",components:{NcModal:r.Jc,NcMultiselect:r.Z2},props:{title:{type:String,default:t("deck","Select the card to link to a project")},action:{type:String,default:t("deck","Link to card")}},data:()=>({boards:[],selectedBoard:"",cardsFromBoard:[],selectedCard:"",loading:!0}),computed:{isBoardAndStackChoosen(){return!(""===this.selectedBoard||""===this.selectedCard)}},beforeMount(){this.fetchBoards()},methods:{fetchBoards(){s.Z.get((0,a.generateUrl)("/apps/deck/boards")).then((t=>{this.boards=t.data,this.loading=!1}))},async fetchCardsFromBoard(t){try{this.cardsFromBoard=[];const e=(0,a.generateUrl)("/apps/deck/stacks/"+t.id);(await s.Z.get(e)).data.forEach((t=>{this.cardsFromBoard.push(...t.cards)}))}catch(t){return t}},close(){this.$root.$emit("close")},select(){this.$root.$emit("select",this.selectedCard.id)}}};var d=o(93379),c=o.n(d),i=o(7795),A=o.n(i),p=o(90569),u=o.n(p),h=o(3565),b=o.n(h),C=o(19216),m=o.n(C),g=o(44589),f=o.n(g),k=o(48961),v={};v.styleTagTransform=f(),v.setAttributes=b(),v.insert=u().bind(null,"head"),v.domAPI=A(),v.insertStyleElement=m();c()(k.Z,v);k.Z&&k.Z.locals&&k.Z.locals;const B=(0,o(51900).Z)(l,(function(){var t=this,e=t._self._c;return e("NcModal",{staticClass:"card-selector",on:{close:t.close}},[e("div",{class:{"icon-loading":t.loading},attrs:{id:"modal-inner"}},[e("h3",[t._v(t._s(t.title))]),t._v(" "),e("NcMultiselect",{attrs:{placeholder:t.t("deck","Select a board"),options:t.boards,disabled:t.loading,label:"title"},on:{select:t.fetchCardsFromBoard},scopedSlots:t._u([{key:"singleLabel",fn:function(n){return[e("span",[e("span",{staticClass:"board-bullet",style:{backgroundColor:"#"+n.option.color}}),t._v(" "),e("span",[t._v(t._s(n.option.title))])])]}},{key:"option",fn:function(n){return[e("span",[e("span",{staticClass:"board-bullet",style:{backgroundColor:"#"+n.option.color}}),t._v(" "),e("span",[t._v(t._s(n.option.title))])])]}}]),model:{value:t.selectedBoard,callback:function(e){t.selectedBoard=e},expression:"selectedBoard"}}),t._v(" "),e("NcMultiselect",{attrs:{placeholder:t.t("deck","Select a card"),options:t.cardsFromBoard,disabled:t.loading||""===t.selectedBoard,label:"title"},model:{value:t.selectedCard,callback:function(e){t.selectedCard=e},expression:"selectedCard"}}),t._v(" "),e("button",{staticClass:"primary",attrs:{disabled:!t.isBoardAndStackChoosen},on:{click:t.select}},[t._v("\n\t\t\t"+t._s(t.action)+"\n\t\t")]),t._v(" "),e("button",{on:{click:t.close}},[t._v("\n\t\t\t"+t._s(t.t("deck","Cancel"))+"\n\t\t")])],1)])}),[],!1,null,"e232cea0",null).exports}}]);
//# sourceMappingURL=deck-src_CardSelector_vue.js.map?v=16c853d01f127e9a15cf