/*
 @licstart  The following is the entire license notice for the JavaScript code in this file.

 The MIT License (MIT)

 Copyright (C) 1997-2020 by Dimitri van Heesch

 Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 and associated documentation files (the "Software"), to deal in the Software without restriction,
 including without limitation the rights to use, copy, modify, merge, publish, distribute,
 sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all copies or
 substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 @licend  The above is the entire license notice for the JavaScript code in this file
*/
var NAVTREE =
[
  [ "OGRE", "index.html", [
    [ "API Reference Start Page", "index.html", "index" ],
    [ "Setting Up Ogre", "_setting_up_ogre.html", [
      [ "Windows", "_setting_up_ogre_windows.html", [
        [ "Requirements", "_setting_up_ogre_windows.html#RequirementsWindows", null ],
        [ "Downloading Ogre", "_setting_up_ogre_windows.html#DownloadingOgreWindows", null ],
        [ "Building Dependencies", "_setting_up_ogre_windows.html#BuildingDependenciesWindows", null ],
        [ "Building Ogre", "_setting_up_ogre_windows.html#BuildingOgreWindows", null ]
      ] ],
      [ "Linux", "_setting_up_ogre_linux.html", [
        [ "Requirements", "_setting_up_ogre_linux.html#RequirementsLinux", null ],
        [ "Downloading Ogre", "_setting_up_ogre_linux.html#DownloadingOgreLinux", null ],
        [ "Building Dependencies", "_setting_up_ogre_linux.html#BuildingDependenciesLinux", null ],
        [ "Building Ogre", "_setting_up_ogre_linux.html#BuildingOgreLinux", null ],
        [ "Setting Up Ogre with QtCreator", "_setting_up_ogre_linux.html#SettingUpOgreWithQtCreatorLinux", null ]
      ] ],
      [ "iOS", "_setting_up_ogre_i_o_s.html", [
        [ "Requirements", "_setting_up_ogre_i_o_s.html#Requirements_iOS", null ],
        [ "Downloading Ogre", "_setting_up_ogre_i_o_s.html#DownloadingOgre_iOS", null ],
        [ "Building Ogre", "_setting_up_ogre_i_o_s.html#BuildingOgre_iOS", null ]
      ] ],
      [ "macOS", "_setting_up_ogre_mac_o_s.html", [
        [ "Install cmake", "_setting_up_ogre_mac_o_s.html#autotoc_md12", null ],
        [ "Install dependencies", "_setting_up_ogre_mac_o_s.html#autotoc_md13", [
          [ "Install SDL2 using brew", "_setting_up_ogre_mac_o_s.html#autotoc_md14", null ]
        ] ],
        [ "Build Ogre", "_setting_up_ogre_mac_o_s.html#autotoc_md15", null ],
        [ "Build offline version of the docs", "_setting_up_ogre_mac_o_s.html#autotoc_md16", null ]
      ] ],
      [ "Android", "_setting_up_ogre_android.html", [
        [ "Requirements", "_setting_up_ogre_android.html#RequirementsAndroid", null ],
        [ "Downloading and building Ogre", "_setting_up_ogre_android.html#DownloadingOgreAndroid", null ],
        [ "Building Samples", "_setting_up_ogre_android.html#BuildingSamplesAndroid", null ]
      ] ]
    ] ],
    [ "Using Ogre in your App", "_using_ogre_in_your_app.html", [
      [ "Overview", "_using_ogre_in_your_app.html#UsingOgreInYourAppOverview", null ],
      [ "Speeding things up", "_using_ogre_in_your_app.html#SpeedingThingsUp", [
        [ "Small note about iOS", "_using_ogre_in_your_app.html#SmallNoteAbout_iOS", null ],
        [ "Apple specific", "_using_ogre_in_your_app.html#autotoc_md17", null ],
        [ "Creating your application with 'EmptyProject' script", "_using_ogre_in_your_app.html#CreatingYourApplication", [
          [ "A note about copied files from Samples/2.0/Common", "_using_ogre_in_your_app.html#AnoteaboutcopiedfilesfromSamples_20_Common", null ]
        ] ],
        [ "Supporting Multithreading loops from the get go", "_using_ogre_in_your_app.html#SupportingMultithreadingLoopsFromTheGetGo", null ]
      ] ]
    ] ],
    [ "Manual", "manual.html", [
      [ "Ogre Next Samples (Feature demonstrations)", "_samples.html", [
        [ "Showcase: Forward3D", "_samples.html#forward3d", null ],
        [ "Showcase: HDR", "_samples.html#hdr", null ],
        [ "Showcase: HDR/SMAA", "_samples.html#hdrsmaa", null ],
        [ "Showcase: PBS Materials", "_samples.html#pbsmaterials", null ],
        [ "Showcase: Post Processing", "_samples.html#postprocessing", null ],
        [ "API Usage: Animation tag points", "_samples.html#animationtagpoints", null ],
        [ "API Usage: Area Light Approximation", "_samples.html#arealighapprox", null ],
        [ "API Usage: Custom Renderable", "_samples.html#customrenderable", null ],
        [ "API Usage: Decals", "_samples.html#decals", null ],
        [ "API Usage: Dynamic Geometry", "_samples.html#dynamicgeometry", null ],
        [ "API Usage: IES Photometric Profiles", "_samples.html#iesprofiles", null ],
        [ "API Usage: Shared Skeleton", "_samples.html#sharedskeleton", null ],
        [ "API Usage: Instanced Stereo", "_samples.html#instancedstero", null ],
        [ "API Usage: Instant Radiosity", "_samples.html#instantradiosity", null ],
        [ "API Usage: Local Reflections Using Parallax Corrected Cubemaps", "_samples.html#localcubemaps", null ],
        [ "API Usage: Local Reflections Using Parallax Corrected Cubemaps With Manual Probes", "_samples.html#localcubemapsmp", null ],
        [ "API Usage: Automatic LOD Generation", "_samples.html#autolod", null ],
        [ "API Usage: Morph Animations", "_samples.html#morphanimation", null ],
        [ "API Usage: Automatically Placed Parallax Corrected Cubemap Probes Via PccPerPixelGridPlacement", "_samples.html#autopcc", null ],
        [ "API Usage: Planar Reflections", "_samples.html#planarreflections", null ],
        [ "API Usage: Refractions", "_samples.html#refractions", null ],
        [ "API Usage: SceneFormat Export / Import Sample", "_samples.html#sceneformat", null ],
        [ "API Usage: Screen Space Reflections", "_samples.html#ssreflections", null ],
        [ "API Usage: Shadow Map Debugging", "_samples.html#shadowdebug", null ],
        [ "API Usage: Shadow Map From Code", "_samples.html#shadowfromcode", null ],
        [ "API Usage: Static Shadow Map", "_samples.html#staticshadowmap", null ],
        [ "API Usage: Stencil Test", "_samples.html#stenciltest", null ],
        [ "API Usage: Stereo Rendering", "_samples.html#stereorendering", null ],
        [ "API Usage: Updating Decals And Area Lights' Textures", "_samples.html#updatedecal", null ],
        [ "API Usage: Ogre V1 Interfaces", "_samples.html#v1interface", null ],
        [ "API Usage: Ogre Next Manual Object", "_samples.html#onmanualobject", null ],
        [ "API Usage: Ogre Next V2 Meshes", "_samples.html#v2Mesh", null ],
        [ "Tutorial: Tutorial 00 - Basic", "_samples.html#tutorial00", null ],
        [ "Tutorial: Tutorial 01 - Initialisation", "_samples.html#tutorial01", null ],
        [ "Tutorial: Tutorial 02 - Variable Framerate", "_samples.html#tutorial02", null ],
        [ "Tutorial: Tutorial 03 - Deterministic Loop", "_samples.html#tutorial03", null ],
        [ "Tutorial: Tutorial 04 - Interpolation Loop", "_samples.html#tutorial04", null ],
        [ "Tutorial: Tutorial 05 - Multithreading Basics", "_samples.html#tutorial05", null ],
        [ "Tutorial: Tutorial 06 - Multithreading", "_samples.html#tutorial06", null ],
        [ "Tutorial: Compute 01 - UAV Textures", "_samples.html#compute01", null ],
        [ "Tutorial: Compute 02 - UAV Buffers", "_samples.html#compute02", null ],
        [ "Tutorial: Distortion", "_samples.html#tut_distortion", null ],
        [ "Tutorial: Dynamic Cube Map", "_samples.html#dyncubemap", null ],
        [ "Tutorial: EGL Headless", "_samples.html#eglheadless", null ],
        [ "Tutorial: Open VR", "_samples.html#openVR", null ],
        [ "Tutorial: Reconstructing Position From Depth", "_samples.html#reconpfromd", null ],
        [ "Tutorial: Rendering Sky As A Postprocess With A Single Shader", "_samples.html#skypost", null ],
        [ "Tutorial: SMAA", "_samples.html#SMAA", null ],
        [ "Tutorial: SSAO", "_samples.html#ssao", null ],
        [ "Tutorial: Terra Terrain", "_samples.html#terrain", null ],
        [ "Tutorial: Texture Baking", "_samples.html#texturebaking", null ],
        [ "Tutorial: UAV Setup 1 Example", "_samples.html#uav1", null ],
        [ "Tutorial: UAV Setup 2 Example", "_samples.html#uav2", null ]
      ] ],
      [ "Changes: Objects, Scene & Nodes", "_ogre20_changes.html", [
        [ "Names are now optional", "_ogre20_changes.html#NamesAreNowOptional", null ],
        [ "How to debug MovableObjects' (and Nodes) data", "_ogre20_changes.html#HowToDebugMovableObjectsData", [
          [ "Interpreting ArrayVector3", "_ogre20_changes.html#InterpretingArrayVector3", null ],
          [ "Dummy pointers instead of NULL", "_ogre20_changes.html#DummyPointers", null ]
        ] ],
        [ "Attachment and Visibility", "_ogre20_changes.html#AttachmentAndVisibility", null ],
        [ "Attaching/Detaching is more expensive than hiding", "_ogre20_changes.html#AttachingDetachingIsMoreExpensive", null ],
        [ "All MovableObjects require a SceneNode (Lights & Cameras)", "_ogre20_changes.html#AllMovableObjectsRequireSceneNode", null ],
        [ "Obtaining derived transforms", "_ogre20_changes.html#DerivedTransforms", null ],
        [ "SCENE_STATIC and SCENE_DYNAMIC", "_ogre20_changes.html#SceneStaticSceneDynamic", [
          [ "What means a Node to be SCENE_STATIC", "_ogre20_changes.html#SceneStaticNode", null ],
          [ "What means a Entities (and InstancedEntities) to be SCENE_STATIC", "_ogre20_changes.html#SceneStaticEntities", null ],
          [ "General", "_ogre20_changes.html#SceneStaticGeneral", null ]
        ] ],
        [ "Ogre asserts mCachedAabbOutOfDate or mCachedTransformOutOfDate while in debug mode", "_ogre20_changes.html#AssersionCachedOutOfDate", null ],
        [ "Custom classes derived from Renderable or MovableObject", "_ogre20_changes.html#DerivingRenderable", null ],
        [ "How do I get the vertex information from the new v2 Mesh classes?", "_ogre20_changes.html#V2MeshInformation", null ],
        [ "How do I set the element offsets, vertex buffer's source and index?", "_ogre20_changes.html#V2MeshElementOffset", null ],
        [ "My scene looks too dark or dull!", "_ogre20_changes.html#SceneLooksDarkDull", null ],
        [ "I activated gamma correction, but now my GUI textures look washed out!", "_ogre20_changes.html#GUIWashedOut", null ]
      ] ],
      [ "Technical Overview", "_technical_overview.html", [
        [ "Overview", "_technical_overview.html#TechnicalOverviewOverview", [
          [ "SIMD Coherence", "_technical_overview.html#SIMDCoherence", null ]
        ] ],
        [ "Memory Managers usage patterns", "_technical_overview.html#MemoryManagerUsagePatterns", [
          [ "Cleanups", "_technical_overview.html#MemoryManagerCleanups", null ]
        ] ],
        [ "Memory preallocation", "_technical_overview.html#MemoryPreallocation", null ],
        [ "Configuring memory managers", "_technical_overview.html#ConfiguringMemoryManagers", null ],
        [ "Where is RenderTarget::update? Why do I get errors in Viewport?", "_technical_overview.html#RenderTargetUpdate", null ],
        [ "Porting from 1.x to 2.0", "_technical_overview.html#PortingV1ToV2", null ],
        [ "Porting from 2.0 to 2.1", "_technical_overview.html#PortingV20ToV21", null ]
      ] ],
      [ "Compositor", "compositor.html", [
        [ "Nodes", "compositor.html#CompositorNodes", [
          [ "Input & output channels and RTTs", "compositor.html#CompositorNodesChannelsAndRTTs", [
            [ "Locally declared textures", "compositor.html#CompositorNodesChannelsAndRTTsLocalTextures", null ],
            [ "It comes from an input channel", "compositor.html#CompositorNodesChannelsAndRTTsFromInputChannel", null ],
            [ "It is a global texture", "compositor.html#CompositorNodesChannelsAndRTTsGlobal", null ],
            [ "Main RenderTarget", "compositor.html#CompositorNodesChannelsAndRTTsMainRenderTarget", null ]
          ] ],
          [ "Target", "compositor.html#CompositorNodesTarget", null ],
          [ "Passes", "compositor.html#CompositorNodesPasses", [
            [ "clear", "compositor.html#CompositorNodesPassesClear", null ],
            [ "generate_mipmaps", "compositor.html#CompositorNodesPassesGenerateMipmaps", null ],
            [ "quad", "compositor.html#CompositorNodesPassesQuad", null ],
            [ "resolve", "compositor.html#CompositorNodesPassesResolve", null ],
            [ "render_scene", "compositor.html#CompositorNodesPassesRenderScene", null ],
            [ "shadows", "compositor.html#CompositorNodesPassesShadows", null ],
            [ "stencil", "compositor.html#CompositorNodesPassesStencil", null ],
            [ "uav_queue", "compositor.html#CompositorNodesPassesUavQueue", [
              [ "Synchronization", "compositor.html#CompositorNodesPassesUavQueueSync", null ]
            ] ],
            [ "compute", "compositor.html#CompositorNodesPassesCompute", null ]
          ] ],
          [ "Textures", "compositor.html#CompositorNodesTextures", [
            [ "MSAA: Explicit vs Implicit resolves", "compositor.html#CompositorNodesTexturesMsaa", [
              [ "Implicit resolves", "compositor.html#CompositorNodesTexturesMsaaImplicit", null ],
              [ "Explicit resolves", "compositor.html#CompositorNodesTexturesMsaaExplicit", null ],
              [ "Resources", "compositor.html#CompositorNodesTexturesMsaaResources", null ]
            ] ],
            [ "Depth Textures", "compositor.html#CompositorNodesTexturesDepth", null ]
          ] ]
        ] ],
        [ "Shadow Nodes", "compositor.html#CompositorShadowNodes", [
          [ "Setting up shadow nodes", "compositor.html#CompositorShadowNodesSetup", null ],
          [ "Example", "compositor.html#CompositorShadowNodesExample", null ],
          [ "Shadow map atlas & Point Lights", "compositor.html#CompositorShadowNodesAtlasAndPointLights", null ],
          [ "Reuse, recalculate and first", "compositor.html#CompositorShadowNodesReuseEtc", null ],
          [ "Shadow mapping setup types", "compositor.html#CompositorShadowNodesTypes", [
            [ "Uniform shadow mapping", "compositor.html#CompositorShadowNodesTypesUniform", null ],
            [ "Focused", "compositor.html#CompositorShadowNodesTypesFocused", null ],
            [ "PSSM / CSM", "compositor.html#CompositorShadowNodesTypesPssm", null ],
            [ "Plane Optimal", "compositor.html#CompositorShadowNodesTypesPlaneOptimal", null ]
          ] ],
          [ "Writing shaders", "compositor.html#CompositorShadowNodesShaders", null ]
        ] ],
        [ "Workspaces", "compositor.html#CompositorWorkspaces", [
          [ "Data dependencies between nodes and circular dependencies", "compositor.html#CompositorWorkspacesDataDependencies", null ]
        ] ],
        [ "Setting up code", "compositor.html#CompositorSetupCode", [
          [ "Initializing the workspace", "compositor.html#CompositorWorkspacesSetupInitialize", null ],
          [ "Simple bootstrap for beginners", "compositor.html#CompositorWorkspacesSetupSimple", null ],
          [ "Advanced C++ users", "compositor.html#CompositorWorkspacesSetupAdvanced", null ]
        ] ],
        [ "Stereo and Split-Screen Rendering", "compositor.html#StereoAndSplitScreenRendering", [
          [ "Per-Workspace offset and scale", "compositor.html#CompositorWorkspacesStereoPerWorkspace", null ],
          [ "Viewport modifier mask", "compositor.html#CompositorWorkspacesStereoViewportMask", null ],
          [ "Execution mask", "compositor.html#CompositorWorkspacesStereoExecutionMask", null ],
          [ "Default values", "compositor.html#CompositorWorkspacesStereoDefaultValues", null ]
        ] ],
        [ "Advanced MSAA", "compositor.html#autotoc_md76", [
          [ "What is MSAA?", "compositor.html#autotoc_md77", [
            [ "Supersampling Antialiasing (SSAA) vs MSAA", "compositor.html#autotoc_md78", null ],
            [ "MSAA approach to the problem", "compositor.html#autotoc_md79", null ]
          ] ],
          [ "Ogre + MSAA with Implicit Resolves", "compositor.html#autotoc_md80", null ],
          [ "Ogre + MSAA with Explicit Resolves", "compositor.html#autotoc_md81", null ]
        ] ]
      ] ],
      [ "Global Illumination Methods", "_gi_methods.html", [
        [ "Ambient Lighting", "_gi_methods.html#GiAmbientLighting", [
          [ "Flat", "_gi_methods.html#GiAmbientLightingFlat", null ],
          [ "Hemisphere", "_gi_methods.html#GiAmbientLightingHemisphere", null ],
          [ "Spherical Harmonics", "_gi_methods.html#GiAmbientLightingSH", null ]
        ] ],
        [ "Parallax Corrected Cubemaps (PCC)", "_gi_methods.html#GiPCC", [
          [ "Auto PCC", "_gi_methods.html#GiPCCAuto", null ],
          [ "Manual PCC", "_gi_methods.html#GiPCCManual", null ]
        ] ],
        [ "Per Pixel PCC", "_gi_methods.html#GiPPPCC", [
          [ "PCC Per Pixel Grid Placement", "_gi_methods.html#GiPPGridPlacement", null ]
        ] ],
        [ "Instant Radiosity", "_gi_methods.html#GiInstantRadiosity", null ],
        [ "Irradiance Volume", "_gi_methods.html#GiIrradianceVolume", null ],
        [ "Voxel Cone Tracing (aka VCT)", "_gi_methods.html#GiVCT", [
          [ "VCT + Per Pixel PCC Hybrid", "_gi_methods.html#GiVCTPlusPPPCC", null ]
        ] ],
        [ "Irradiance Field with Depth (IFD)", "_gi_methods.html#GiIFD", null ],
        [ "Cascaded Image Voxel Cone Tracing (CIVCT)", "_gi_methods.html#GiCIVCT", null ],
        [ "What technique should I choose?", "_gi_methods.html#GiWhatTechniqueChoose", null ],
        [ "Image Voxel Cone Tracing", "_image_voxel_cone_tracing.html", [
          [ "Step 1: Image Voxelizer", "_image_voxel_cone_tracing.html#IVCT_Step1", [
            [ "Downside", "_image_voxel_cone_tracing.html#IVCT_Step1_Downside", [
              [ "Non-researched solutions:", "_image_voxel_cone_tracing.html#autotoc_md29", null ]
            ] ],
            [ "Trivia", "_image_voxel_cone_tracing.html#autotoc_md30", null ]
          ] ],
          [ "Step 2: Row Translation", "_image_voxel_cone_tracing.html#IVCT_Step2", null ],
          [ "Step 3: Cascades", "_image_voxel_cone_tracing.html#IVCT_Step3", null ],
          [ "Wait isn't this what UE5's Lumen does?", "_image_voxel_cone_tracing.html#autotoc_md31", null ],
          [ "Wait isn't this what Godot does?", "_image_voxel_cone_tracing.html#autotoc_md32", null ]
        ] ]
      ] ],
      [ "Image Voxel Cone Tracing", "_image_voxel_cone_tracing.html", [
        [ "Step 1: Image Voxelizer", "_image_voxel_cone_tracing.html#IVCT_Step1", [
          [ "Downside", "_image_voxel_cone_tracing.html#IVCT_Step1_Downside", [
            [ "Non-researched solutions:", "_image_voxel_cone_tracing.html#autotoc_md29", null ]
          ] ],
          [ "Trivia", "_image_voxel_cone_tracing.html#autotoc_md30", null ]
        ] ],
        [ "Step 2: Row Translation", "_image_voxel_cone_tracing.html#IVCT_Step2", null ],
        [ "Step 3: Cascades", "_image_voxel_cone_tracing.html#IVCT_Step3", null ],
        [ "Wait isn't this what UE5's Lumen does?", "_image_voxel_cone_tracing.html#autotoc_md31", null ],
        [ "Wait isn't this what Godot does?", "_image_voxel_cone_tracing.html#autotoc_md32", null ]
      ] ],
      [ "Instancing", "instancing.html", [
        [ "What is instancing?", "instancing.html#WhatIsInstancing", null ],
        [ "Instancing 101", "instancing.html#Instancing101", [
          [ "Instances per batch", "instancing.html#InstancesPerBatch", null ]
        ] ],
        [ "Techniques", "instancing.html#InstancingTechniques", [
          [ "ShaderBased", "instancing.html#InstancingTechniquesShaderBased", null ],
          [ "VTF (Software)", "instancing.html#InstancingTechniquesVTFSoftware", null ],
          [ "HW VTF", "instancing.html#InstancingTechniquesHWVTF", [
            [ "HW VTF LUT", "instancing.html#InstancingTechniquesHW", null ]
          ] ],
          [ "HW Basic", "instancing.html#InstancingTechniquesHWBasic", null ]
        ] ],
        [ "Custom parameters", "instancing.html#InstancingCustomParameters", null ],
        [ "Supporting multiple submeshes", "instancing.html#InstancingMultipleSubmeshes", null ],
        [ "Defragmenting batches", "instancing.html#InstancingDefragmentingBatches", [
          [ "What is batch fragmentation?", "instancing.html#InstancingDefragmentingBatchesIntro", null ],
          [ "Prevention: Avoiding fragmentation", "instancing.html#InstancingDefragmentingBatchesPrevention", null ],
          [ "Cure: Defragmenting on the fly", "instancing.html#InstancingDefragmentingBatchesOnTheFly", null ]
        ] ],
        [ "Troubleshooting", "instancing.html#InstancingTroubleshooting", null ]
      ] ],
      [ "Threading", "threading.html", [
        [ "Initializing", "threading.html#ThreadingInitializing", [
          [ "Ideal number of threads", "threading.html#ThreadingInitializingNumberOfThreads", null ],
          [ "More info about InstancingThreadedCullingMethod", "threading.html#ThreadingInitializingCullingMethod", null ]
        ] ],
        [ "What tasks are threaded in Ogre", "threading.html#ThreadingInOgre", null ],
        [ "Using Ogre's threading system for custom tasks", "threading.html#ThreadingCustomTasks", null ],
        [ "Thread safety of SceneNodes", "threading.html#ThreadSafetySceneNodes", null ]
      ] ],
      [ "Performance Hints", "performance.html", null ],
      [ "HLMS: High Level Material System", "hlms.html", [
        [ "Fundamental changes", "hlms.html#HlmsChanges", [
          [ "Viewports and Scissor tests", "hlms.html#HlmsChangesViewports", null ],
          [ "A lot of data is stored in \"Blocks\"", "hlms.html#HlmsChangesBlocks", null ],
          [ "Materials are still alive", "hlms.html#HlmsChangesMaterialsAlive", null ],
          [ "Fixed Function has been removed", "hlms.html#HlmsChangesFFP", null ]
        ] ],
        [ "The three components", "hlms.html#HlmsComponents", null ],
        [ "Blocks", "hlms.html#HlmsBlocks", [
          [ "Datablocks", "hlms.html#HlmsBlocksDatablocks", null ],
          [ "Macroblocks", "hlms.html#HlmsBlocksMacroblocks", null ],
          [ "Blendblocks", "hlms.html#HlmsBlocksBlendblocks", null ],
          [ "Samplerblocks", "hlms.html#HlmsBlocksSampleblocks", null ]
        ] ],
        [ "Hlms templates", "hlms.html#HlmsTemplates", null ],
        [ "The Hlms preprocessor", "hlms.html#HlmsPreprocessor", [
          [ "Preprocessor syntax", "hlms.html#HlmsPreprocessorSyntax", [
            [ "@property( expression )", "hlms.html#HlmsPreprocessorSyntaxProperty", null ],
            [ "@foreach( count, scopedVar, [start] )", "hlms.html#HlmsPreprocessorSyntaxForeach", null ],
            [ "@counter( variable )", "hlms.html#HlmsPreprocessorSyntaxCounter", null ],
            [ "@value( variable )", "hlms.html#HlmsPreprocessorSyntaxValue", null ],
            [ "@set add sub mul div mod min max", "hlms.html#HlmsPreprocessorSyntaxSetEtc", null ],
            [ "@piece( nameOfPiece )", "hlms.html#HlmsPreprocessorSyntaxPiece", null ],
            [ "@insertpiece( nameOfPiece )", "hlms.html#HlmsPreprocessorSyntaxInsertpiece", null ],
            [ "@undefpiece( nameOfPiece )", "hlms.html#HlmsPreprocessorSyntaxUndefpiece", null ],
            [ "@pset padd psub pmul pdiv pmod pmin pmax", "hlms.html#HlmsPreprocessorSyntaxPsetEtc", null ]
          ] ]
        ] ],
        [ "Creation of shaders", "hlms.html#HlmsCreationOfShaders", [
          [ "C++ interaction with shader templates", "hlms.html#HlmsCreationOfShadersCpp", null ],
          [ "Common conventions", "hlms.html#HlmsCreationOfShadersConventions", null ],
          [ "Hot reloading", "hlms.html#HlmsCreationOfShadersHotReloading", null ],
          [ "Disabling a stage", "hlms.html#HlmsCreationOfShadersDisablingStage", null ],
          [ "Customizing an existing implementation", "hlms.html#HlmsCreationOfShadersCustomizing", null ]
        ] ],
        [ "Run-time rendering", "hlms.html#HlmsRuntimeRendering", [
          [ "preparePassHash", "hlms.html#HlmsRuntimeRenderingPreparePassHash", null ],
          [ "fillBuffersFor", "hlms.html#HlmsRuntimeRenderingFillBuffersFor", null ]
        ] ],
        [ "Using the HLMS implementations", "hlms.html#UsingHlmsImplementation", [
          [ "Initialization", "hlms.html#UsingHlmsImplementationInitialization", null ],
          [ "Deinitialization", "hlms.html#UsingHlmsImplementationDeinitilization", null ],
          [ "Creating a datablock", "hlms.html#UsingHlmsImplementationCreatingDatablock", null ]
        ] ],
        [ "The Hlms Texture Manager", "hlms.html#HlmsTextureManager", [
          [ "Automatic batching", "hlms.html#HlmsTextureManagerAutomaticBatching", [
            [ "Texture types", "hlms.html#HlmsTextureManagerAutomaticBatchingTextureTypes", null ],
            [ "Automatic parameters", "hlms.html#HlmsTextureManagerAutomaticBatchingAutoParams", null ],
            [ "Loading a texture twice (i.e. with a different format) via aliasing", "hlms.html#HlmsTextureManagerAutomaticBatchingLoadingTwice", null ]
          ] ],
          [ "Manual: Texture packs", "hlms.html#HlmsTextureManagerTexturePacks", null ],
          [ "Watching out for memory consumption", "hlms.html#HlmsTextureManagerWatchOutMemory", [
            [ "Additional memory considerations", "hlms.html#HlmsTextureManagerWatchOutMemoryConsiderations", null ],
            [ "setWorkerThreadMinimumBudget warning", "hlms.html#setWorkerThreadMinimumBudget", null ]
          ] ]
        ] ],
        [ "Troubleshooting", "hlms.html#HlmsTroubleshooting", [
          [ "My shadows don't show up or are very glitchy", "hlms.html#HlmsTroubleshootingShadow", null ]
        ] ]
      ] ],
      [ "AZDO changes (Aproaching Zero Driver Overhead)", "azdo.html", [
        [ "V2 and v1 objects", "azdo.html#V2AndV1Objects", [
          [ "Longevity of the v1 objects and deprecation", "azdo.html#V2AndV1ObjectsV1Longevity", null ]
        ] ],
        [ "Render Queue", "azdo.html#RenderQueue", null ],
        [ "The VaoManager", "azdo.html#VaoMaanger", null ]
      ] ],
      [ "The Command Buffer", "commandbuffer.html", [
        [ "Adding a command", "commandbuffer.html#CommandBufferAddCommand", null ],
        [ "Structure of a command", "commandbuffer.html#CommandBufferCommandStructure", null ],
        [ "Execution table", "commandbuffer.html#CommandBufferExecutionTable", [
          [ "Hacks and Tricks", "commandbuffer.html#CommandBufferExecutionTableHacks", null ]
        ] ],
        [ "Post-processing the command buffer", "commandbuffer.html#CommandBufferPostProcessing", null ]
      ] ],
      [ "Terra System", "_terra_system.html", [
        [ "Vertex-bufferless rendering", "_terra_system.html#autotoc_md67", null ],
        [ "Vertex Trick in Terra", "_terra_system.html#autotoc_md68", null ],
        [ "Terra cells", "_terra_system.html#autotoc_md69", [
          [ "First layer, the 4x4 block", "_terra_system.html#autotoc_md70", null ],
          [ "Outer layers", "_terra_system.html#autotoc_md71", null ]
        ] ],
        [ "Skirts", "_terra_system.html#autotoc_md72", null ],
        [ "Shadows", "_terra_system.html#autotoc_md73", null ],
        [ "Shading", "_terra_system.html#autotoc_md74", null ],
        [ "Why is it not a component?", "_terra_system.html#autotoc_md75", null ]
      ] ],
      [ "Tunning memory consumption and resources", "_tuning_memory_resources.html", [
        [ "Grouping textures by type", "_tuning_memory_resources.html#GroupingTexturesByType", null ],
        [ "Dynamic vs Default buffers", "_tuning_memory_resources.html#DynamicVsDefaultBuffers", null ],
        [ "Tweaking default memory consumption by VaoManager", "_tuning_memory_resources.html#TweakingVaoManager", [
          [ "Vulkan and <tt>TEXTURES_OPTIMAL</tt>", "_tuning_memory_resources.html#autotoc_md33", null ]
        ] ]
      ] ],
      [ "What's new in Ogre 2.2", "_ogre22_changes.html", [
        [ "Load Store semantics", "_ogre22_changes.html#autotoc_md34", [
          [ "Now that we’ve explained how TBDRs work, we can explain load and store actions", "_ogre22_changes.html#autotoc_md35", null ]
        ] ],
        [ "More control over MSAA", "_ogre22_changes.html#autotoc_md36", null ],
        [ "Porting to Ogre 2.2 from 2.1", "_ogre22_changes.html#autotoc_md37", [
          [ "PixelFormats", "_ogre22_changes.html#autotoc_md38", [
            [ "Common pixel format equivalencies", "_ogre22_changes.html#autotoc_md39", null ]
          ] ],
          [ "Useful code snippets", "_ogre22_changes.html#autotoc_md40", [
            [ "Create a TextureGpu based on a file", "_ogre22_changes.html#autotoc_md41", null ],
            [ "Create a TextureGpu based that you manually fill", "_ogre22_changes.html#autotoc_md42", null ],
            [ "Uploading data to a TextureGpu", "_ogre22_changes.html#autotoc_md43", null ],
            [ "Upload streaming", "_ogre22_changes.html#autotoc_md44", null ],
            [ "Downloading data from TextureGpu into CPU", "_ogre22_changes.html#autotoc_md45", null ],
            [ "Downloading streaming", "_ogre22_changes.html#autotoc_md46", null ]
          ] ]
        ] ],
        [ "Difference between depth, numSlices and depthOrSlices", "_ogre22_changes.html#autotoc_md47", null ],
        [ "Memory layout of textures and images", "_ogre22_changes.html#autotoc_md48", null ],
        [ "Troubleshooting errors", "_ogre22_changes.html#autotoc_md49", null ],
        [ "RenderPassDescriptors", "_ogre22_changes.html#autotoc_md50", null ],
        [ "DescriptorSetTexture & co.", "_ogre22_changes.html#autotoc_md51", null ],
        [ "Does 2.2 interoperate well with the HLMS texture arrays?", "_ogre22_changes.html#autotoc_md52", null ],
        [ "Hlms porting", "_ogre22_changes.html#autotoc_md53", null ],
        [ "Things to watch out when porting", "_ogre22_changes.html#autotoc_md54", null ]
      ] ],
      [ "Behavor of StagingTexture in D3D11", "_behavor_staging_texture_d3_d11.html", [
        [ "Attempting to be contiguous", "_behavor_staging_texture_d3_d11.html#autotoc_md18", null ],
        [ "Slicing in 3", "_behavor_staging_texture_d3_d11.html#autotoc_md19", null ],
        [ "Slicing in the middle", "_behavor_staging_texture_d3_d11.html#autotoc_md20", null ]
      ] ],
      [ "What's new in Ogre 2.3", "_ogre23_changes.html", [
        [ "Switch importV1 to createByImportingV1", "_ogre23_changes.html#autotoc_md55", null ],
        [ "Shadow's Normal Offset Bias", "_ogre23_changes.html#autotoc_md56", null ],
        [ "Unlit vertex and pixel shaders unified", "_ogre23_changes.html#autotoc_md57", null ],
        [ "Added HlmsMacroblock::mDepthClamp", "_ogre23_changes.html#autotoc_md58", null ],
        [ "Added shadow pancaking", "_ogre23_changes.html#autotoc_md59", null ],
        [ "PluginOptional", "_ogre23_changes.html#autotoc_md60", null ],
        [ "Other relevant information when porting", "_ogre23_changes.html#autotoc_md61", [
          [ "Do not call notifyDataIsReady more than needed", "_ogre23_changes.html#autotoc_md62", null ],
          [ "Global changes for Vulkan compatibility:", "_ogre23_changes.html#autotoc_md63", null ]
        ] ]
      ] ],
      [ "Root Layouts", "_root_layouts.html", [
        [ "Old APIs (i.e. D3D11 and GL)", "_root_layouts.html#RootLayoutsOldAPIs", null ],
        [ "New APIs and Root Layouts", "_root_layouts.html#RootLayoutsNewAPIs", null ],
        [ "Setting up root layouts", "_root_layouts.html#RootLayoutsSettingUp", [
          [ "Could you have used e.g. \"const_buffers\" : [0,7] instead of [4,7]?", "_root_layouts.html#autotoc_md64", null ]
        ] ],
        [ "Declaring Root Layouts in shaders", "_root_layouts.html#RootLayoutsDeclaringInShaders", null ],
        [ "Baked sets", "_root_layouts.html#RootLayoutsBakedSets", null ],
        [ "Prefab Root Layouts for low level materials", "_root_layouts.html#RootLayoutPrefabs", null ],
        [ "Arrays of Textures", "_root_layouts.html#RootLayoutsArraysOfTextures", [
          [ "C++", "_root_layouts.html#RootLayoutsAoTCpp", null ],
          [ "Inline shader declaration", "_root_layouts.html#RootLayoutsAoTInlineShader", null ],
          [ "Automatic", "_root_layouts.html#RootLayoutsAoTAuto", null ],
          [ "Making GLSL shaders compatible with both Vulkan and OpenGL", "_root_layouts.html#RootLayoutsGLSLForGLandVK", [
            [ "Example:", "_root_layouts.html#RootLayoutsGLSLForGLandVKExample", [
              [ "OpenGL", "_root_layouts.html#autotoc_md65", null ],
              [ "Vulkan", "_root_layouts.html#autotoc_md66", null ]
            ] ]
          ] ]
        ] ]
      ] ]
    ] ],
    [ "Deprecated List", "deprecated.html", null ],
    [ "Topics", "topics.html", "topics" ],
    [ "Namespaces", "namespaces.html", [
      [ "Namespace List", "namespaces.html", "namespaces_dup" ],
      [ "Namespace Members", "namespacemembers.html", [
        [ "All", "namespacemembers.html", "namespacemembers_dup" ],
        [ "Functions", "namespacemembers_func.html", null ],
        [ "Variables", "namespacemembers_vars.html", null ],
        [ "Typedefs", "namespacemembers_type.html", "namespacemembers_type" ],
        [ "Enumerations", "namespacemembers_enum.html", null ],
        [ "Enumerator", "namespacemembers_eval.html", "namespacemembers_eval" ]
      ] ]
    ] ],
    [ "Classes", "annotated.html", [
      [ "Class List", "annotated.html", "annotated_dup" ],
      [ "Class Index", "classes.html", null ],
      [ "Class Hierarchy", "hierarchy.html", "hierarchy" ],
      [ "Class Members", "functions.html", [
        [ "All", "functions.html", "functions_dup" ],
        [ "Functions", "functions_func.html", "functions_func" ],
        [ "Variables", "functions_vars.html", "functions_vars" ],
        [ "Typedefs", "functions_type.html", "functions_type" ],
        [ "Enumerations", "functions_enum.html", null ],
        [ "Enumerator", "functions_eval.html", "functions_eval" ],
        [ "Properties", "functions_prop.html", null ],
        [ "Related Symbols", "functions_rela.html", "functions_rela" ]
      ] ]
    ] ],
    [ "Files", "files.html", [
      [ "File List", "files.html", "files_dup" ],
      [ "File Members", "globals.html", [
        [ "All", "globals.html", "globals_dup" ],
        [ "Functions", "globals_func.html", null ],
        [ "Typedefs", "globals_type.html", null ],
        [ "Enumerations", "globals_enum.html", null ],
        [ "Enumerator", "globals_eval.html", null ],
        [ "Macros", "globals_defs.html", "globals_defs" ]
      ] ]
    ] ]
  ] ]
];

var NAVTREEINDEX =
[
"_android_2_ogre_config_dialog_imp_8h.html",
"_ogre_buffer_packed_8h.html#ab66e67b60d5f40dacf69ea55b82868aba740abc88b46822e30de8802282f1b86a",
"_ogre_d3_d11_plugin_8h.html",
"_ogre_g_l_e_s2_prerequisites_8h.html#a1ed5ecb0c8aea39e35289f08df88a14a",
"_ogre_hlms_pbs_prerequisites_8h.html#a342a992a9d37255505fc5fbb7f0584d9a1d824feba8ee4c7c8b593d319436d479",
"_ogre_metal_program_8h.html",
"_ogre_prerequisites_8h.html#ab6e842a18caf062ed73a5d3badd0dd4c",
"_ogre_simple_spline_8h.html",
"_ogre_thread_defines_poco_8h.html#ace4a3180018d84c5295b17251233abfb",
"_ogre_vulkan_global_binding_table_8h.html#a8ea612cd4e3340a99b41fcdbef0c65c5a422388fa0796545b2dc10c283b3cbec1",
"_samples.html#tutorial04",
"class_ogre_1_1_absolute_pixel_count_lod_strategy.html",
"class_ogre_1_1_android_e_g_l_window.html#a3649200bc76f575f6241beff14dd80d0",
"class_ogre_1_1_android_log_listener.html#a8357fe4fb4849772b94baa4bf47c7ded",
"class_ogre_1_1_array_aabb.html#af6cce5a6680360aca28dab72143428c7",
"class_ogre_1_1_array_ray.html#a446c150f80233b39a7c4d6f93cd6a9d3",
"class_ogre_1_1_async_texture_ticket.html#a25041a6b2f21149ddfd4a85d82006b00",
"class_ogre_1_1_auto_param_data_source.html#aaccd003a6c19e21199020afa408b7a8b",
"class_ogre_1_1_bone.html#a63fc6bdc2eb6aeac24898a77ec5e2023",
"class_ogre_1_1_c_preprocessor.html",
"class_ogre_1_1_camera.html#a57e0523432c6e5133ff4fc251111a60e",
"class_ogre_1_1_camera.html#abe7acc15cb68a5c42b7241f0a1ba84c2",
"class_ogre_1_1_cocoa_window.html#a76b56f475ba7474c83760b557c34c6a5",
"class_ogre_1_1_command_buffer.html#ac738bd71ca00d243bc894d4f182a1f12",
"class_ogre_1_1_compositor_node_def.html#ab84105d5b109ca471e5e582902740676",
"class_ogre_1_1_compositor_pass_def.html#a544008d76e21be83ab7b91f96f36b3bc",
"class_ogre_1_1_compositor_pass_mipmap_def.html#a7446207e62dfceb532bd3dc3cf78039b",
"class_ogre_1_1_compositor_pass_scene_def.html#acb46d4b0a597156d9ba5abc39d127792",
"class_ogre_1_1_compositor_pass_target_barrier_def.html#acb37409e6e5fbc0467773942e8c14bdc",
"class_ogre_1_1_compositor_shadow_node_def.html#a0b832d936fde223d0e19076097e95054",
"class_ogre_1_1_compositor_workspace_def.html#a87d95f1066f10ce9e0fd54d6ec545633",
"class_ogre_1_1_const_buffer_packed.html#acb46d4b0a597156d9ba5abc39d127792",
"class_ogre_1_1_create_high_level_gpu_program_script_compiler_event.html#ae5f8dc7dd5e16fd36160c86a5a6095b3",
"class_ogre_1_1_d3_d11_async_ticket.html#aed1464ac3de21ff20db8f9f1f8608dc7",
"class_ogre_1_1_d3_d11_depth_buffer.html#a9854c57374adef41216bae68544a5b7ea821faf32a09ac92606a6585fc61e24f7",
"class_ogre_1_1_d3_d11_depth_texture.html#aadcef30707e8e10fbac61d65e1e73e52",
"class_ogre_1_1_d3_d11_device.html#a0795f202077b6d65db6f0eb208d17213",
"class_ogre_1_1_d3_d11_gpu_program_manager.html#abbb523a827bc6ea90d3b5ec80f0cf770",
"class_ogre_1_1_d3_d11_h_l_s_l_program.html#a8eb34a9034aab62fd537c021a79e3366",
"class_ogre_1_1_d3_d11_mappings.html#aca0490de1bc9d2fd45bcf08d2341ad8d",
"class_ogre_1_1_d3_d11_null_texture.html#a1c727e879a260c37b00ce5505fe8e144",
"class_ogre_1_1_d3_d11_null_texture_target.html#a32f2e646a09dcdaef810ea402bc92155",
"class_ogre_1_1_d3_d11_read_only_buffer_packed.html#ae2b3c0f529c83f8f69d3344fa766f686",
"class_ogre_1_1_d3_d11_render_system.html#a62b358abe191b667b1b4beec17972ce4",
"class_ogre_1_1_d3_d11_render_system.html#af8ab96ff92deaf480cc8e5867400f684",
"class_ogre_1_1_d3_d11_render_window_base.html#a4b42772d32712767391c749f4745397a",
"class_ogre_1_1_d3_d11_render_window_swap_chain_based.html#a62a35f19422bd10282b044909e757b2e",
"class_ogre_1_1_d3_d11_stereo_driver_a_m_d.html#ab2635c990eb9efe650bbf5f0845538e0",
"class_ogre_1_1_d3_d11_texture.html#a104d9db8bfcff1f37b29157bbe070f7a",
"class_ogre_1_1_d3_d11_texture_gpu.html#a2e45ab2f1617d1d51c45f687d9ebee8c",
"class_ogre_1_1_d3_d11_texture_gpu_manager.html#a6e96132817c27bfae1c0374e98d20dfc",
"class_ogre_1_1_d3_d11_texture_gpu_render_target.html#ac965a34686dd8e378e1b614b1211e2c9",
"class_ogre_1_1_d3_d11_texture_gpu_window.html#acc159b3ac817e04b1fa9e69431f8e41d",
"class_ogre_1_1_d3_d11_uav_buffer_packed.html#a564935579f2252627f46dff29142e7ff",
"class_ogre_1_1_d3_d11_video_mode_list.html",
"class_ogre_1_1_d3_d9_depth_buffer.html#a595ea4c05da8aa987d3800e65d23355d",
"class_ogre_1_1_d3_d9_driver.html#a93e6a86dde5483c053ca0f2a85bbfd6c",
"class_ogre_1_1_d3_d9_gpu_fragment_program.html#ab422c67a2c8844f410fe822a357cba3b",
"class_ogre_1_1_d3_d9_gpu_program.html#aa31bef1bfaa87731622e56f11b548e27",
"class_ogre_1_1_d3_d9_gpu_program_manager.html#af6b1156d96165528bd587e92267cc741",
"class_ogre_1_1_d3_d9_gpu_vertex_program.html#af0be69f3df55f71c0bded2e36c89dfa6",
"class_ogre_1_1_d3_d9_h_l_s_l_program.html#acce55ed43f888d8c4c5ed5c5aaf9d1db",
"class_ogre_1_1_d3_d9_hardware_pixel_buffer.html#aaa3b402158015eb4e91c53c5c0c0326c",
"class_ogre_1_1_d3_d9_multi_render_target.html#acb46d4b0a597156d9ba5abc39d127792",
"class_ogre_1_1_d3_d9_render_system.html#a51cbd7a790f8bad97ac8983e00fcbfb2",
"class_ogre_1_1_d3_d9_render_system.html#ac27c2134455ce86c7886c8450a0393ae",
"class_ogre_1_1_d3_d9_render_texture.html#ab16d079db49b93e915e9386b4e27880b",
"class_ogre_1_1_d3_d9_render_window.html#ad7c1644812658f13813df5dae8836478",
"class_ogre_1_1_d3_d9_stereo_driver_n_v_i_d_i_a.html#ac0bdd94939814460b0b654fd704e88ab",
"class_ogre_1_1_d3_d9_texture.html#aee3fd3170df592c3cc679cc38d3d9f60",
"class_ogre_1_1_d3_d9_video_mode_list.html#acb46d4b0a597156d9ba5abc39d127792",
"class_ogre_1_1_decal.html#a9a72ade896561e23c32cf8659f1640e4",
"class_ogre_1_1_default_intersection_scene_query.html#a467a4c2459e8bad4fb14eba9f9d8f567",
"class_ogre_1_1_default_scene_manager.html#a0fec5de5b1af8423dbdae70fa1d18954",
"class_ogre_1_1_default_scene_manager.html#a76cbf15335510f68db04b743ac1e25dd",
"class_ogre_1_1_default_scene_manager.html#add6fe27d7a9500aafbe9325c21985801",
"class_ogre_1_1_default_work_queue.html#a54f438bd00567fe192bfadcac50b7317",
"class_ogre_1_1_depth_buffer.html#a9854c57374adef41216bae68544a5b7eac3e2a2eeb9d97edbf973e52499d190ec",
"class_ogre_1_1_e_g_l_g_l_support.html#ae5eebd1e301e98a051389601418bb7ad",
"class_ogre_1_1_e_g_l_window.html#a9439f12db8a964f79f4b743493a0fd75",
"class_ogre_1_1_egl_p_buffer_window.html#a22779bbfb123c76e922942ba876e330a",
"class_ogre_1_1_emitter_commands_1_1_cmd_velocity.html",
"class_ogre_1_1_emscripten_e_g_l_window.html#a814de6b1529bba5f7aa80ea3ac537ae1",
"class_ogre_1_1_external_texture_source_manager.html",
"class_ogre_1_1_file_system_layer.html#a1c727e879a260c37b00ce5505fe8e144",
"class_ogre_1_1_font_manager.html#adce32528577d71b228692df906ecd17c",
"class_ogre_1_1_free_image_codec2.html#ae5b74cfd0cb797a2ac139b4adb7ac557",
"class_ogre_1_1_g_l3_plus_async_texture_ticket.html#a93e6a86dde5483c053ca0f2a85bbfd6c",
"class_ogre_1_1_g_l3_plus_depth_buffer.html#a595ea4c05da8aa987d3800e65d23355d",
"class_ogre_1_1_g_l3_plus_depth_texture.html#a8ab9418311a7b4a116139a7871e57a4b",
"class_ogre_1_1_g_l3_plus_depth_texture_target.html#af13e0f1d822d7fc1ed65bc0360b1ab60",
"class_ogre_1_1_g_l3_plus_f_b_o_render_texture.html#a0c00ca9d1ba7f3efc248ae86511fbff9",
"class_ogre_1_1_g_l3_plus_null_texture.html#a04969ca1d25bf40e71e907f2cdb7443b",
"class_ogre_1_1_g_l3_plus_null_texture_target.html#a15f59cd1b4a2b2e65fcee349d78ae490a5ee29312d754f2244987dc0d1f5894e8",
"class_ogre_1_1_g_l3_plus_read_only_buffer_emulated_packed.html#a1f35a4a63b023187026b9abc1c897a71",
"class_ogre_1_1_g_l3_plus_read_only_uav_buffer_packed.html#adce32528577d71b228692df906ecd17c",
"class_ogre_1_1_g_l3_plus_render_system.html#a6a34f2ded473d4cbaeda6e954f76dbaf",
"class_ogre_1_1_g_l3_plus_render_system.html#afb6f61d5c70531c1eb718cdfbefb0330",
"class_ogre_1_1_g_l3_plus_staging_buffer.html#afe091313c974edab09f0f9daabf8034d",
"class_ogre_1_1_g_l3_plus_tex_buffer_packed.html#a8357fe4fb4849772b94baa4bf47c7ded",
"class_ogre_1_1_g_l3_plus_texture.html#ae0a0007de944eb3c2f933a372a752b35",
"class_ogre_1_1_g_l3_plus_texture_gpu.html#aed1464ac3de21ff20db8f9f1f8608dc7",
"class_ogre_1_1_g_l3_plus_texture_gpu_headless_window.html#af3e85ec353d2f79da71c96ad69b4048a",
"class_ogre_1_1_g_l3_plus_texture_gpu_render_target.html#a9078e54f74753c91de4a74462bdff406",
"class_ogre_1_1_g_l3_plus_texture_gpu_window.html#a93e6a86dde5483c053ca0f2a85bbfd6c",
"class_ogre_1_1_g_l3_plus_uav_buffer_packed.html",
"class_ogre_1_1_g_l_e_s2_async_ticket.html#acb46d4b0a597156d9ba5abc39d127792",
"class_ogre_1_1_g_l_e_s2_depth_buffer.html#acb08c0ee96e38c80f9c61a918961771c",
"class_ogre_1_1_g_l_e_s2_f_b_o_manager.html#aecea9ceccfdf7484a7d7ff56a971342e",
"class_ogre_1_1_g_l_e_s2_gpu_program_manager.html#a1eadda53bbed16d5a3804cdba2ad687e",
"class_ogre_1_1_g_l_e_s2_null_texture_target.html#a4b42772d32712767391c749f4745397a",
"class_ogre_1_1_g_l_e_s2_render_system.html#a172ecbfb3f437bd609f6d653bcb83b27",
"class_ogre_1_1_g_l_e_s2_render_system.html#a9b1ee9f299e9097bec1185a4ec478cf7",
"class_ogre_1_1_g_l_e_s2_render_texture.html#a286cd44d638d6b668160d5123f087a32",
"class_ogre_1_1_g_l_e_s2_tex_buffer_emulated_packed.html#a1c727e879a260c37b00ce5505fe8e144",
"class_ogre_1_1_g_l_e_s2_texture_manager.html#af33a91a3a918df919de56635b13a532e",
"class_ogre_1_1_g_l_s_l_e_s_program_pipeline.html#aa2bbf63617d7c69b0d7bd23c1c64cc64",
"class_ogre_1_1_g_l_s_l_program.html#afc203076edbe6bf41d42373461e12d05",
"class_ogre_1_1_g_l_s_l_shader.html#a77d5f72e02500f6db6f460bb48eac721",
"class_ogre_1_1_g_l_s_l_shader_manager.html#a48c565d0e63b286c6388439ae73417df",
"class_ogre_1_1_g_l_x_utils.html#a696ce1b07de0d84e1ce965ff065445bc",
"class_ogre_1_1_g_t_k_window.html#a4b42772d32712767391c749f4745397aaa9d982cf6f703ba525577fdd487ae5e8",
"class_ogre_1_1_gpu_program.html#a33dbdfb93317b9f8192e2272f1679f28",
"class_ogre_1_1_gpu_program_parameters.html#a155c886f15e0c10d2c33c224f0d43ce3a709e64ce954b9369269ab28545ed8cb6",
"class_ogre_1_1_gpu_program_usage.html#a75e48f93f8076f90ea0cfbe63052683d",
"class_ogre_1_1_hashed_vector.html#a60b694e07c1dfeee89d09ea378a4f2a3",
"class_ogre_1_1_hlms.html#a1c727e879a260c37b00ce5505fe8e144",
"class_ogre_1_1_hlms_compute_job.html#a29709c020f2dbe9fd7bac1df927f5bc0",
"class_ogre_1_1_hlms_low_level.html#a619db6c1e977e02966786a9e25ed8785",
"class_ogre_1_1_hlms_pbs.html#a9b258ad7ac37f1544ee0fc0fab344b5d",
"class_ogre_1_1_hlms_pbs_mobile_datablock.html#a8939f5409032260e4a4fa65ad7686e66",
"class_ogre_1_1_hlms_unlit_mobile.html#a42e458f42a60363648a6b1ce368feb4b",
"class_ogre_1_1_ifd_probe_visualizer.html#a41b58fe7a0d317cbc00052e6668cf4ef",
"class_ogre_1_1_image.html#a5312a67dfaeb1716ae9ab72c1af766cb",
"class_ogre_1_1_index_buffer_packed.html#a3d389b0aae18bb6dcb82af84c93b77de",
"class_ogre_1_1_internal_cubemap_probe.html#a7241fd29a548973d1d2fa56bcc9f13a4",
"class_ogre_1_1_invalid_call_exception.html#a9bdf9b8a0a83b95818d676848beaa29ba65ef64423bae408d90e0af0166bac152",
"class_ogre_1_1_item.html#a6b823b52684730302908ecfd1a8e6d54",
"class_ogre_1_1_kf_transform_array_memory_manager.html#a8c128b8ba585ecb04205e81d2aa2c341",
"class_ogre_1_1_light.html#ab1014fe5901c78f1b51f00227a6d9f84",
"class_ogre_1_1_lod_collapse_cost.html#a354e7502246237f033d48fec0adfad4f",
"class_ogre_1_1_lod_strategy.html#a8357fe4fb4849772b94baa4bf47c7ded",
"class_ogre_1_1_lw_string.html#aaff93d2d88f5d0c43986b100814be0e1",
"class_ogre_1_1_manual_object.html#ad66149b7a6f5ba1cd5c58fbd69f0446a",
"class_ogre_1_1_map_iterator.html#a7d788cb5bce74b71aafeee0c13340f7c",
"class_ogre_1_1_material_manager_1_1_listener.html#aefe59620e9a345442740cfae43a86f02",
"class_ogre_1_1_mathlib_c.html#ae98e2bcd6bbcf97f7a38af886994837b",
"class_ogre_1_1_mesh.html#aa9d1d491d2473e762d8ee442ed9bbff4",
"class_ogre_1_1_metal_async_texture_ticket.html#a89bea6111361e89646624550ea24c83a",
"class_ogre_1_1_metal_depth_buffer.html#a7af5c611687492846891914dcac303d2",
"class_ogre_1_1_metal_depth_texture.html#aa561d8d03383bb59ecce5c4278ed8da6",
"class_ogre_1_1_metal_device_list.html#a010554b0f42a6b41974a528a5b2ea053",
"class_ogre_1_1_metal_gpu_program_manager.html#acd4223279e97a7687e2f9994f05e2491",
"class_ogre_1_1_metal_null_texture.html#a017b0d0590ce4afc079f2f1f85a686b8",
"class_ogre_1_1_metal_null_texture_target.html#a01b1440d6644ac11e3c5042f26c13cdd",
"class_ogre_1_1_metal_program.html#a1686b8aef3b2c8d3892ae453086073c4",
"class_ogre_1_1_metal_program_factory.html#a5399460ea5773073bf7130afb35671ec",
"class_ogre_1_1_metal_render_system.html#a2eb75175291761881bdc0d73ec379089",
"class_ogre_1_1_metal_render_system.html#ac33cff318b8ae9c4f1b9a35b97250322",
"class_ogre_1_1_metal_render_texture.html#ab16d079db49b93e915e9386b4e27880b",
"class_ogre_1_1_metal_tex_buffer_packed.html#aac7d5a7fc76d5e3086620800003e55b5",
"class_ogre_1_1_metal_texture.html#aed1464ac3de21ff20db8f9f1f8608dc7",
"class_ogre_1_1_metal_texture_gpu.html#af79e22c90559d13385d75dc19970806d",
"class_ogre_1_1_metal_texture_gpu_render_target.html#a96c0f33134c2401b0e711506c8055623",
"class_ogre_1_1_metal_texture_gpu_window.html#a9be2b0daaad98d2140ca22efc6685684",
"class_ogre_1_1_metal_texture_manager.html#af4b66fba75a4c341bd1c1dd16decfec8",
"class_ogre_1_1_metal_window.html#a1da544529153a89991172ba7a83598c5",
"class_ogre_1_1_movable_object.html#ac4b8f3f72f7bf7a6bc20dd0677e125c1",
"class_ogre_1_1_movable_plane.html#ab2cfac9af1b0d71c780ec969166b3585",
"class_ogre_1_1_n_u_l_l_async_texture_ticket.html#afe11bd546cf7315f4526488e7078cc7da61729c4ae25807d6132d5bc46580ff3d",
"class_ogre_1_1_n_u_l_l_read_only_buffer_packed.html#a7cfd9629389ccf2aedec4b37f5a1b403",
"class_ogre_1_1_n_u_l_l_render_system.html#a7d6c7c84f9b85cb342dd559de75d585f",
"class_ogre_1_1_n_u_l_l_render_texture.html#a2bdfaa76a186e49b807b06c7a92b720e",
"class_ogre_1_1_n_u_l_l_render_window.html#a98450b1ee7ec1dc378b220322e951cba",
"class_ogre_1_1_n_u_l_l_tex_buffer_packed.html#a69984ccd67bf7c801cc33dd20780b581",
"class_ogre_1_1_n_u_l_l_texture.html#ae229b1f58092109adef55bfc6f864d79",
"class_ogre_1_1_n_u_l_l_texture_gpu_render_target.html#a359fd32c4f8c31cdd4db4baf72c1b70c",
"class_ogre_1_1_n_u_l_l_texture_manager.html#af484f2b60c8d9bc87f37fa8af8e630c5",
"class_ogre_1_1_n_u_l_l_window.html#a5b1947429a1d331724fd49d3dcb58acd",
"class_ogre_1_1_na_cl_window.html#a74f922747c11f98718be00c2fa86165c",
"class_ogre_1_1_node.html#ab4cb21c7d7270547ae33b5eab8c8b02d",
"class_ogre_1_1_null_entity.html#a98fe88f82f86eafa19308074495db809",
"class_ogre_1_1_obj_cmd_buffer.html#ada9e6a477c7ab935d4370de139ab9b7a",
"class_ogre_1_1_page.html#a7d54d0141d86f76a8ef49ecd3c48aeea",
"class_ogre_1_1_paged_world.html#adce32528577d71b228692df906ecd17c",
"class_ogre_1_1_parallax_corrected_cubemap_auto.html#a440a7ee7f09c8b7afc678cfceb73ae20",
"class_ogre_1_1_particle_affector.html#a5f401d9023e7bb484ff3ff49e70c9510",
"class_ogre_1_1_particle_system.html#a6944af26e8944b13756ade50cd1092d8",
"class_ogre_1_1_particle_system_renderer_factory.html#adce32528577d71b228692df906ecd17c",
"class_ogre_1_1_pcc_per_pixel_grid_placement.html#a475cfc98745d04539575861c511c571a",
"class_ogre_1_1_plane.html#a1f5ace6a3a4bedc91a283895fb77a6a8",
"class_ogre_1_1_profile_instance.html#a584eaa396f1b06fd16c666e5a9e42730",
"class_ogre_1_1_quaternion.html#a821a464cce9a81d5d20c620025043851",
"class_ogre_1_1_r_t_shader_1_1_f_f_p_alpha_test.html#a05aa9a2678f41393dcf36c8ac41d0d2d",
"class_ogre_1_1_r_t_shader_1_1_f_f_p_texturing.html#a69c40940e108e1169e914a8e23329da6",
"class_ogre_1_1_r_t_shader_1_1_h_l_s_l_program_writer.html#ab77fed92caa5cf0351ba50c013968ec6",
"class_ogre_1_1_r_t_shader_1_1_layered_blending.html#aed1464ac3de21ff20db8f9f1f8608dc7",
"class_ogre_1_1_r_t_shader_1_1_parameter.html#a4fa6286f097d19e92a8ed91645fbfbe7a951a04e1de9730a072ef64af53711e80",
"class_ogre_1_1_r_t_shader_1_1_program_writer.html#ab422c67a2c8844f410fe822a357cba3b",
"class_ogre_1_1_r_t_shader_1_1_sub_render_state_factory.html",
"class_ogre_1_1_r_t_shader_1_1_uniform_parameter.html#a4fa6286f097d19e92a8ed91645fbfbe7a935e3497dc372489d1cebcb4bc5d701f",
"class_ogre_1_1_ray_scene_query_listener.html",
"class_ogre_1_1_rectangle2_d.html#a6991726994f0775c8d158722f664b04d",
"class_ogre_1_1_region_scene_query.html#a8be0cafc960c53f65cb7972ced8f5b83",
"class_ogre_1_1_render_system.html#a987cf400154a21403b4ff5192d423971",
"class_ogre_1_1_render_target.html#a3d389b0aae18bb6dcb82af84c93b77de",
"class_ogre_1_1_render_window.html#af72cb6156c72e9d9568591dadcc54217",
"class_ogre_1_1_rendering_a_p_i_exception.html#a9bdf9b8a0a83b95818d676848beaa29b",
"class_ogre_1_1_resource_manager.html#a2b2b134c38b4ead5ef13bd157fe2329a",
"class_ogre_1_1_s_d_l_g_l_support.html",
"class_ogre_1_1_s_d_l_window.html#af8854efa9b905e9becd10e062a53ae3a",
"class_ogre_1_1_scene_manager.html#a22e12455f2cfefa6e33d042056d07ec2",
"class_ogre_1_1_scene_manager.html#a89dcc1f1ba9edf96523eca20e18e0a12",
"class_ogre_1_1_scene_manager.html#af4a61278b3ac74c9e16a7ba9cb45815b",
"class_ogre_1_1_scene_node.html#a6e4f546194a1dcf79703ef2ffd6cead4",
"class_ogre_1_1_screen_ratio_pixel_count_lod_strategy.html#a8357fe4fb4849772b94baa4bf47c7ded",
"class_ogre_1_1_shadow_texture_definition.html#ac6810d8af2224855822bb72e6b9e159c",
"class_ogre_1_1_simple_page_content_collection_factory.html#ab422c67a2c8844f410fe822a357cba3b",
"class_ogre_1_1_skeleton_track.html#a8c07c92b7ad65f59e67efc8a758248f7",
"class_ogre_1_1_small_vector_3_01_t_00_010_01_4.html#aea596193580db53967668c72412d57e4",
"class_ogre_1_1_small_vector_template_base_3_01_t_00_01true_01_4.html#aa5c7ed10e04b28acc1fecd075879a3e3",
"class_ogre_1_1_staging_buffer.html#a0512e57da9c9f75e7666133a10883126",
"class_ogre_1_1_string_converter.html#ab6f7c4fb9bf4be031282c8ccf5b38727",
"class_ogre_1_1_sub_string_ref.html#acc90b67b3b44138b73f829ee96074c86",
"class_ogre_1_1_terrain.html#a09fa76cb7d0c852aa15b5beb7a0433ea",
"class_ogre_1_1_terrain_1_1_default_gpu_buffer_allocator.html#af98bc1200700effb840c37f3d7b60b6f",
"class_ogre_1_1_terrain_material_generator.html#a1c727e879a260c37b00ce5505fe8e144",
"class_ogre_1_1_terrain_quad_tree_node.html#a20aec2a5359be7a4621188e98c6fdd4e",
"class_ogre_1_1_texture.html#acb46d4b0a597156d9ba5abc39d127792",
"class_ogre_1_1_texture_filter_1_1_leave_channel_r.html#a1c727e879a260c37b00ce5505fe8e144",
"class_ogre_1_1_texture_gpu_manager.html#a7dc898578da3113affb78ed60f209b71",
"class_ogre_1_1_texture_unit_state.html#a72a88b1cf11053da98fa25f98689931ea50895f1c891eedb007500965ca4c204a",
"class_ogre_1_1_uav_buffer_packed.html#a7cfd9629389ccf2aedec4b37f5a1b403",
"class_ogre_1_1_user_object_bindings.html#aed1464ac3de21ff20db8f9f1f8608dc7",
"class_ogre_1_1_vct_image_voxelizer.html#a9e9d6a701188ebad524e9d77f066d871",
"class_ogre_1_1_vct_voxelizer_source_base.html#af8b649bc09c0bfb2bc200bba692f0f89",
"class_ogre_1_1_vector_iterator_wrapper.html#aaf01f897bea391797dc2bb9fb8374a5f",
"class_ogre_1_1_volume_1_1_c_s_g_negate_source.html#a6c7d66b981f8390cf697250c378f9564",
"class_ogre_1_1_volume_1_1_chunk.html#a8245f38abd50264c00473d4c54a8d56b",
"class_ogre_1_1_volume_1_1_mesh_builder.html#adce32528577d71b228692df906ecd17c",
"class_ogre_1_1_voxel_visualizer.html#a2f92a5741b1c1123f7f76ce2a551c9c8",
"class_ogre_1_1_voxel_visualizer.html#aff35a0dcf855331bdd0fe72fe0f66824",
"class_ogre_1_1_vulkan_async_texture_ticket.html#ab422c67a2c8844f410fe822a357cba3b",
"class_ogre_1_1_vulkan_delayed__vk_destroy_framebuffer.html#a4a28f7bc1381c7ed4b85690b1bc8c656",
"class_ogre_1_1_vulkan_gpu_program_manager.html#a2208200adc00affea9fee67fec2f393e",
"class_ogre_1_1_vulkan_plugin.html#aed1464ac3de21ff20db8f9f1f8608dc7",
"class_ogre_1_1_vulkan_program.html#ae86e7c238ce5730eb88347e932024b10",
"class_ogre_1_1_vulkan_render_pass_descriptor.html#a595ea4c05da8aa987d3800e65d23355d",
"class_ogre_1_1_vulkan_render_system.html#a7dc960ae4b821007ebd62b3557e60ec3",
"class_ogre_1_1_vulkan_render_system.html#af6e6be5710a412edd5d35b967d2aa7fe",
"class_ogre_1_1_vulkan_tex_buffer_packed.html#a35b465c05a47ee960720d91c3271ecb8",
"class_ogre_1_1_vulkan_texture_gpu_manager.html#a7dc898578da3113affb78ed60f209b71",
"class_ogre_1_1_vulkan_texture_gpu_window.html#a335f8053b320bab94073cd0359da9f15",
"class_ogre_1_1_vulkan_uav_buffer_packed.html#a4f4a89f5f9d89f1dbb5b605dbc1cbddb",
"class_ogre_1_1_vulkan_vao_manager.html#afafd75ba72857e13a55e540a2d0ed414",
"class_ogre_1_1_vulkan_window.html#a8a464e98db9c09042b866bdb95b210f4",
"class_ogre_1_1_vulkan_window_swap_chain_based.html#a85f87e6c41a86bde631a893d0f1c0b26",
"class_ogre_1_1_vulkan_xcb_window.html#acd46202d3fd921f029d029fa2f5ed59b",
"class_ogre_1_1_win32_e_g_l_window.html#a3d389b0aae18bb6dcb82af84c93b77de",
"class_ogre_1_1_win32_g_l_support.html#a99adef70272ec72c1d44943c43a27ab3",
"class_ogre_1_1_wire_aabb.html#a2108dfc322953a7bd429be8b62811e56",
"class_ogre_1_1_wire_aabb.html#aef2a2634077942a2939514a6c1114d32",
"class_ogre_1_1_x11_e_g_l_window.html#a0fcddbd42767a6f35d3660e3bd5f02be",
"class_ogre_1_1_x11_e_g_l_window.html#adce32528577d71b228692df906ecd17c",
"class_ogre_1_1v1_1_1_animation.html#ae16a78d96e33c4c3eeb6eb91cf4fd78a",
"class_ogre_1_1v1_1_1_billboard_chain.html#a6496cb6bcaffcbb03e25e56f4b88bf7f",
"class_ogre_1_1v1_1_1_billboard_set.html#a28b12f8d0fd7c9da7fcd1e9806dd8064",
"class_ogre_1_1v1_1_1_border_panel_overlay_element.html#a407b6feed54a0dd33281e1006baa34d7",
"class_ogre_1_1v1_1_1_d3_d11_depth_pixel_buffer.html#a0dcdae5ab2e85ed66e33c4df3e2c956f",
"class_ogre_1_1v1_1_1_d3_d11_hardware_buffer_manager.html#ab3fc128d148ce3954e184a505199e0d2",
"class_ogre_1_1v1_1_1_d3_d11_hardware_pixel_buffer.html#a6ed986689e41c247108c1c4e8cca354a",
"class_ogre_1_1v1_1_1_d3_d11_hardware_vertex_buffer.html#aed1464ac3de21ff20db8f9f1f8608dc7",
"class_ogre_1_1v1_1_1_default_hardware_counter_buffer.html#a9e52ce4b806532c790d1c30be69f2bfc",
"class_ogre_1_1v1_1_1_entity.html#a35b519fd7cbbee4b8dc8ef7c1e526ba3",
"class_ogre_1_1v1_1_1_entity.html#af5e87f0d34dd3df4b5d26128bee66624",
"class_ogre_1_1v1_1_1_g_l3_plus_default_hardware_counter_buffer.html#ac0c56e93ce6f29bf39fb48c3d5dc64cf",
"class_ogre_1_1v1_1_1_g_l3_plus_default_hardware_vertex_buffer.html#a6776e40af767f8db7d428f35d9b3055c",
"class_ogre_1_1v1_1_1_g_l3_plus_hardware_counter_buffer.html#a16e0f91e0bec314b6ad38c4f7b8216bc",
"class_ogre_1_1v1_1_1_g_l3_plus_hardware_pixel_buffer.html#a93e6a86dde5483c053ca0f2a85bbfd6c",
"class_ogre_1_1v1_1_1_g_l3_plus_hardware_vertex_buffer.html#a5caebd4b5db7696029eb412351d7767f",
"class_ogre_1_1v1_1_1_g_l3_plus_texture_buffer.html#a54dcf44f73f3e73e188e299345b56644",
"class_ogre_1_1v1_1_1_g_l_e_s2_default_hardware_buffer_manager_base.html#af2d6066698e4940c7a9fd3c52d8c5531",
"class_ogre_1_1v1_1_1_g_l_e_s2_default_hardware_vertex_buffer.html#ac0c56e93ce6f29bf39fb48c3d5dc64cfaacdcbae3ae1ce82b2f4411df53a545cb",
"class_ogre_1_1v1_1_1_g_l_e_s2_hardware_pixel_buffer.html#a8357fe4fb4849772b94baa4bf47c7ded",
"class_ogre_1_1v1_1_1_g_l_e_s2_render_buffer.html#ac0c56e93ce6f29bf39fb48c3d5dc64cf",
"class_ogre_1_1v1_1_1_hardware_buffer_manager.html#a15077ee295a2fa1e0673b55b1ad7f944",
"class_ogre_1_1v1_1_1_hardware_pixel_buffer.html#ac55c8bdcbbf33732841dad7a062c5cd1",
"class_ogre_1_1v1_1_1_manual_object.html#a40ed698792ecc5d35c743f699e7887ea",
"class_ogre_1_1v1_1_1_manual_object_1_1_manual_object_section.html#a3d5e8933145d36977b8c2b64e307bc59",
"class_ogre_1_1v1_1_1_mesh.html#a6a6322f8cb8120d9d9b30931d06d7257",
"class_ogre_1_1v1_1_1_mesh_serializer_impl__v1__10.html#abb4cbd6ef3f27e221cdc3454b8da2ae6",
"class_ogre_1_1v1_1_1_metal_hardware_buffer_manager_base.html#a79513a524782fcac13a6d91e68013ad7",
"class_ogre_1_1v1_1_1_metal_hardware_pixel_buffer.html#af83d101662208e14abe0c24fe99b5915",
"class_ogre_1_1v1_1_1_metal_texture_buffer.html#a6ed986689e41c247108c1c4e8cca354a",
"class_ogre_1_1v1_1_1_numeric_animation_track.html#a63fc6bdc2eb6aeac24898a77ec5e2023",
"class_ogre_1_1v1_1_1_old_node.html#ab422c67a2c8844f410fe822a357cba3b",
"class_ogre_1_1v1_1_1_old_skeleton_instance.html#a893c7a150edb48a25e5df700cfc194eb",
"class_ogre_1_1v1_1_1_overlay.html#ac4b8f3f72f7bf7a6bc20dd0677e125c1",
"class_ogre_1_1v1_1_1_overlay_element.html#a638d280d0fab8c1b6d07c52ba9b1378e",
"class_ogre_1_1v1_1_1_panel_overlay_element.html#a2108dfc322953a7bd429be8b62811e56",
"class_ogre_1_1v1_1_1_patch_mesh.html#a6166c02a1910f1b0247aacdf9829e2d3",
"class_ogre_1_1v1_1_1_rectangle2_d.html#a4c2ae8ae38d7910d9730c025999f6b83",
"class_ogre_1_1v1_1_1_rectangle2_d_factory.html#abd16dae5dd18b58f57d2e0d8bdbb26e0",
"class_ogre_1_1v1_1_1_ribbon_trail_factory.html#a93e6a86dde5483c053ca0f2a85bbfd6c",
"class_ogre_1_1v1_1_1_simple_renderable.html#ac4b8f3f72f7bf7a6bc20dd0677e125c1",
"class_ogre_1_1v1_1_1_static_geometry.html#aac0ecb9e456d3d972e8024beaaf41515",
"class_ogre_1_1v1_1_1_static_geometry_1_1_material_bucket.html",
"class_ogre_1_1v1_1_1_static_geometry_1_1_region.html#acbfc4840224e8b6ed6e27849d3341675",
"class_ogre_1_1v1_1_1_sub_mesh.html#a6b8f6cb72d7605303d804dd70bf44fce",
"class_ogre_1_1v1_1_1_text_area_overlay_element.html#a787297eceab290ccfebd9d90e38dd205",
"class_ogre_1_1v1_1_1_vertex_data.html#a4db82cfa2d11d2f6049a1c05c0566e9e",
"class_ogre_1_1v1_1_1_vulkan_hardware_buffer_manager.html#afae0e3c4fb95f96b60147cde62b0bacb",
"class_ogre_1_1v1_1_1_vulkan_hardware_vertex_buffer.html#ac1181285d98c30d2dbfd4e341e07a686",
"class_ogre_1_1v1_1_1_wire_bounding_box.html#ab86b755f38ec01b52ed6a512d9d31ef9",
"dir_a17e71eb01adefa8837d0a747f56758c.html",
"globals_z.html",
"group___general.html#gga124456c1616299612ac9f46e7d69268da370f32b6cd8e47d4f41d645224700097",
"group___general.html#gga30d5439896c2a2362024ec689b1e181caa580e3f6f4345147e128fc07119d54d2",
"group___general.html#ggafef752c0acb956e22a95c41e667480aba28c5d661274c02f913e9114e8dfedab9",
"group___image.html#gga71f09fe41a1db41186262f1aa5814a18ac3621ecf1c858eb4cc140b47543ed41e",
"group___materials.html#gga41c76d419d6c9c205a6c1d3b42872213a93b05f61a5076cf0f649ac5d656970fe",
"group___overlays.html#ga70549c3123e67cd2ef5196a54e51dbfa",
"group___render_system.html#gga3d2965b7f378ebdcfe8a4a6cf74c3de7a13bfd58f4ab147007a566e7fc7a45cd3",
"group___resources.html#ggaf140ec886884a864abc74a7556f8bf67ae1661d9846a9b4e83c2e4cd99fc6ad9d",
"namespace_ogre.html#a0c6264d875a99e59c748064cee2e1fc4a9bdebebf1f253ac1d0f131018d717d2c",
"namespace_ogre.html#aab2b912370b681335fc1d156739c94fe",
"namespace_ogre_1_1_pixel_format_data_types.html#a320bd6a6b273a3abe76add6b64ff8540acd7ddc0ba749aedac2cc5094d3fdd798",
"namespacestd.html#ac0f5c834836c0f5a4602cff74511d272",
"struct_ogre_1_1_cb_draw_strip.html#af9a68f10d9f0a2b46fa8d64b95f48d29",
"struct_ogre_1_1_d3_d11_hlms_pso.html#a907b7214ec6353891d6977d712c9307f",
"struct_ogre_1_1_egl_p_buffer_support_1_1_device_data.html#a7497646dec4102c42d84c137e7778c62",
"struct_ogre_1_1_g_l_e_s2_vao_manager_1_1_stride_changer.html#a4ac2c2d43247ca7702f5b54069e73907",
"struct_ogre_1_1_hlms_base_prop.html#aa441a74c2ece4c5a0ef5add55037d83b",
"struct_ogre_1_1_hlms_texture_pack_1_1_texture_entry.html#a9d0050c27470bec21b0a960151a4bfd9",
"struct_ogre_1_1_lod_data_1_1_index_buffer_info.html#aef789e3ea55d0d890f1de9434d36a449",
"struct_ogre_1_1_metal_discard_buffer_manager_1_1_unsafe_block.html#a648e8ae541d77f60907e09d11093ed77",
"struct_ogre_1_1_pbs_mobile_shader_creation_data.html#a68ebbf71e39fcab6d73550c40e8bd8ce",
"struct_ogre_1_1_raster_params.html#abb3063ac46798d8104a2b148fef9f9c8",
"struct_ogre_1_1_script_compiler_1_1_error.html#adce32528577d71b228692df906ecd17c",
"struct_ogre_1_1_terrain_group_1_1_terrain_slot_definition.html#a2e4c34e42faae3ec1d745e5cae8fb200",
"struct_ogre_1_1_unlit_mobile_prop.html#a852c27571369dabf68525702015a32ff",
"struct_ogre_1_1_vao_manager_1_1_memory_stats_entry.html#af4463a05a73fd5f9d096d85c69c085d3",
"struct_ogre_1_1_vertex_array_object.html#aeedbc5dadc06e31d8adc2e2784055e1b",
"struct_ogre_1_1_vulkan_descriptor_set_sampler.html",
"struct_ogre_1_1_vulkan_raw_buffer.html#adc7a6651dedffaff88877201b195538d",
"struct_ogre_1_1v1_1_1_cb_draw_call_strip.html#a1b56c03e7afca205eddf3f9ee408fed1"
];

var SYNCONMSG = 'click to disable panel synchronisation';
var SYNCOFFMSG = 'click to enable panel synchronisation';