/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.DefaultExecutor;
import kotlinx.coroutines.Delay;
import kotlinx.coroutines.DisposableFutureHandle;
import kotlinx.coroutines.DisposableHandle;
import kotlinx.coroutines.ExecutorCoroutineDispatcher;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.ResumeUndispatchedRunnable;
import kotlinx.coroutines.TimeSource;
import kotlinx.coroutines.TimeSourceKt;
import kotlinx.coroutines.internal.ConcurrentKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b \u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u001c\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\r\u0010\u0013\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u0014J\u001c\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J*\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001a2\n\u0010\u000b\u001a\u00060\fj\u0002`\r2\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001e\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070 H\u0016J\b\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lkotlinx/coroutines/ExecutorCoroutineDispatcherBase;", "Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "Lkotlinx/coroutines/Delay;", "()V", "removesFutureOnCancellation", "", "close", "", "dispatch", "context", "Lkotlin/coroutines/CoroutineContext;", "block", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "equals", "other", "", "hashCode", "", "initFutureCancellation", "initFutureCancellation$kotlinx_coroutines_core", "invokeOnTimeout", "Lkotlinx/coroutines/DisposableHandle;", "timeMillis", "", "scheduleBlock", "Ljava/util/concurrent/ScheduledFuture;", "time", "unit", "Ljava/util/concurrent/TimeUnit;", "scheduleResumeAfterDelay", "continuation", "Lkotlinx/coroutines/CancellableContinuation;", "toString", "", "kotlinx-coroutines-core"})
public abstract class ExecutorCoroutineDispatcherBase
extends ExecutorCoroutineDispatcher
implements Delay {
    private boolean removesFutureOnCancellation;

    public final void initFutureCancellation$kotlinx_coroutines_core() {
        this.removesFutureOnCancellation = ConcurrentKt.removeFutureOnCancel(this.getExecutor());
    }

    @Override
    public void dispatch(@NotNull CoroutineContext context, @NotNull Runnable block) {
        try {
            Executor executor2 = this.getExecutor();
            boolean bl = false;
            Object object = TimeSourceKt.getTimeSource();
            if (object == null || (object = object.wrapTask(block)) == null) {
                object = block;
            }
            executor2.execute((Runnable)object);
        }
        catch (RejectedExecutionException e) {
            boolean bl = false;
            TimeSource timeSource = TimeSourceKt.getTimeSource();
            if (timeSource != null) {
                timeSource.unTrackTask();
            }
            DefaultExecutor.INSTANCE.enqueue(block);
        }
    }

    @Override
    public void scheduleResumeAfterDelay(long timeMillis, @NotNull CancellableContinuation<? super Unit> continuation) {
        ScheduledFuture<?> future;
        ScheduledFuture<?> scheduledFuture = future = this.removesFutureOnCancellation ? this.scheduleBlock(new ResumeUndispatchedRunnable(this, continuation), timeMillis, TimeUnit.MILLISECONDS) : null;
        if (future != null) {
            JobKt.cancelFutureOnCancellation(continuation, (Future)future);
            return;
        }
        DefaultExecutor.INSTANCE.scheduleResumeAfterDelay(timeMillis, continuation);
    }

    @Override
    @NotNull
    public DisposableHandle invokeOnTimeout(long timeMillis, @NotNull Runnable block) {
        ScheduledFuture<?> future = this.removesFutureOnCancellation ? this.scheduleBlock(block, timeMillis, TimeUnit.MILLISECONDS) : null;
        return future != null ? (DisposableHandle)new DisposableFutureHandle((Future)future) : DefaultExecutor.INSTANCE.invokeOnTimeout(timeMillis, block);
    }

    private final ScheduledFuture<?> scheduleBlock(Runnable block, long time, TimeUnit unit) {
        ScheduledFuture<?> scheduledFuture;
        try {
            Executor executor2 = this.getExecutor();
            if (!(executor2 instanceof ScheduledExecutorService)) {
                executor2 = null;
            }
            ScheduledExecutorService scheduledExecutorService = (ScheduledExecutorService)executor2;
            scheduledFuture = scheduledExecutorService != null ? scheduledExecutorService.schedule(block, time, unit) : null;
        }
        catch (RejectedExecutionException e) {
            scheduledFuture = null;
        }
        return scheduledFuture;
    }

    @Override
    public void close() {
        block1: {
            Executor executor2 = this.getExecutor();
            if (!(executor2 instanceof ExecutorService)) {
                executor2 = null;
            }
            ExecutorService executorService = (ExecutorService)executor2;
            if (executorService == null) break block1;
            executorService.shutdown();
        }
    }

    @Override
    @NotNull
    public String toString() {
        return this.getExecutor().toString();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ExecutorCoroutineDispatcherBase && ((ExecutorCoroutineDispatcherBase)other).getExecutor() == this.getExecutor();
    }

    public int hashCode() {
        return System.identityHashCode(this.getExecutor());
    }

    @Override
    @Nullable
    public Object delay(long time, @NotNull Continuation<? super Unit> continuation) {
        return Delay.DefaultImpls.delay(this, time, continuation);
    }
}

