/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.indexmanagement.indexstatemanagement.ISMActionsParser;
import org.opensearch.indexmanagement.indexstatemanagement.IndexMetadataProvider;
import org.opensearch.indexmanagement.indexstatemanagement.action.TransitionsAction;
import org.opensearch.indexmanagement.indexstatemanagement.model.Transition;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Action;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Step;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepMetaData;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 ,2\u00020\u00012\u00020\u0002:\u0001,B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B)\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\tH\u00c6\u0003J3\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\u0018\u0010\u001b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0007H\u00d6\u0001J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006-"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/model/State;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "Lorg/opensearch/core/common/io/stream/Writeable;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "name", "", "actions", "", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Action;", "transitions", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/Transition;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getActions", "()Ljava/util/List;", "getName", "()Ljava/lang/String;", "getTransitions", "component1", "component2", "component3", "copy", "equals", "", "other", "", "getActionToExecute", "managedIndexMetaData", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;", "indexMetadataProvider", "Lorg/opensearch/indexmanagement/indexstatemanagement/IndexMetadataProvider;", "hashCode", "", "toString", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 State.kt\norg/opensearch/indexmanagement/indexstatemanagement/model/State\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,148:1\n1#2:149\n1855#3,2:150\n1855#3,2:152\n777#3:156\n788#3:157\n1864#3,2:158\n789#3,2:160\n1866#3:162\n791#3:163\n37#4,2:154\n*S KotlinDebug\n*F\n+ 1 State.kt\norg/opensearch/indexmanagement/indexstatemanagement/model/State\n*L\n35#1:150,2\n50#1:152,2\n86#1:156\n86#1:157\n86#1:158,2\n86#1:160,2\n86#1:162\n86#1:163\n52#1:154,2\n*E\n"})
public final class State
implements ToXContentObject,
Writeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final List<Action> actions;
    @NotNull
    private final List<Transition> transitions;
    @NotNull
    public static final String NAME_FIELD = "name";
    @NotNull
    public static final String ACTIONS_FIELD = "actions";
    @NotNull
    public static final String TRANSITIONS_FIELD = "transitions";

    public State(@NotNull String name, @NotNull List<? extends Action> actions, @NotNull List<Transition> transitions) {
        Intrinsics.checkNotNullParameter((Object)name, (String)NAME_FIELD);
        Intrinsics.checkNotNullParameter(actions, (String)ACTIONS_FIELD);
        Intrinsics.checkNotNullParameter(transitions, (String)TRANSITIONS_FIELD);
        this.name = name;
        this.actions = actions;
        this.transitions = transitions;
        if (!(!StringsKt.isBlank((CharSequence)this.name))) {
            boolean $i$a$-require-State$22 = false;
            String $i$a$-require-State$22 = "State must contain a valid name";
            throw new IllegalArgumentException($i$a$-require-State$22.toString());
        }
        boolean hasDelete = false;
        Iterable $this$forEach$iv = this.actions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Action action = (Action)element$iv;
            boolean bl = false;
            if (!(!hasDelete)) {
                boolean bl2 = false;
                String string = "State=" + this.name + " must not contain an action after a delete action";
                throw new IllegalArgumentException(string.toString());
            }
            hasDelete = Intrinsics.areEqual((Object)action.getType(), (Object)"delete") || action.deleteIndexMetadataAfterFinish();
        }
        if (hasDelete && !this.transitions.isEmpty()) {
            boolean bl = false;
            String string = "State=" + this.name + " cannot contain transitions if using delete action";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<Action> getActions() {
        return this.actions;
    }

    @NotNull
    public final List<Transition> getTransitions() {
        return this.transitions;
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        XContentBuilder xContentBuilder;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        XContentBuilder it = xContentBuilder = builder.startObject().field(NAME_FIELD, this.name).startArray(ACTIONS_FIELD);
        boolean bl = false;
        Iterable $this$forEach$iv = this.actions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Action action = (Action)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            action.toXContent(it, params);
        }
        Collection $this$toTypedArray$iv = this.transitions;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        xContentBuilder.endArray().field(TRANSITIONS_FIELD, (Object)thisCollection$iv.toArray(new Transition[0])).endObject();
        return builder;
    }

    public State(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sin.readString()");
        List list = sin.readList(State::_init_$lambda$6);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"sin.readList { ISMAction\u2026nce.fromStreamInput(it) }");
        List list2 = sin.readList(Transition::new);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"sin.readList(::Transition)");
        this(string, list, list2);
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.name);
        out.writeList(this.actions);
        out.writeList(this.transitions);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Action getActionToExecute(@NotNull ManagedIndexMetaData managedIndexMetaData, @NotNull IndexMetadataProvider indexMetadataProvider) {
        Intrinsics.checkNotNullParameter((Object)managedIndexMetaData, (String)"managedIndexMetaData");
        Intrinsics.checkNotNullParameter((Object)indexMetadataProvider, (String)"indexMetadataProvider");
        Action actionConfig = null;
        ActionMetaData actionMetaData = managedIndexMetaData.getActionMetaData();
        if (managedIndexMetaData.getTransitionTo() != null || actionMetaData == null) {
            Action action = (Action)CollectionsKt.firstOrNull(this.actions);
            if (action == null) {
                action = new TransitionsAction(this.transitions, indexMetadataProvider);
            }
            actionConfig = action;
        } else if (Intrinsics.areEqual((Object)actionMetaData.getName(), (Object)"transition")) {
            actionConfig = new TransitionsAction(this.transitions, indexMetadataProvider);
        } else {
            Action action;
            void $this$filterIndexedTo$iv$iv;
            Iterable $this$filterIndexed$iv = this.actions;
            boolean $i$f$filterIndexed = false;
            Iterable iterable = $this$filterIndexed$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIndexedTo = false;
            void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv$iv = 0;
            for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                void config;
                void element$iv$iv;
                int n;
                if ((n = index$iv$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv$iv$iv;
                int index$iv$iv = n;
                boolean bl = false;
                Action action2 = (Action)element$iv$iv;
                int index2 = index$iv$iv;
                boolean bl2 = false;
                if (!(index2 == actionMetaData.getIndex() && Intrinsics.areEqual((Object)config.getType(), (Object)actionMetaData.getName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            actionConfig = (Action)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (actionConfig == null) {
                return null;
            }
            StepMetaData stepMetaData = managedIndexMetaData.getStepMetaData();
            if (stepMetaData != null && stepMetaData.getStepStatus() == Step.StepStatus.COMPLETED && (action = actionConfig).isLastStep(stepMetaData.getName())) {
                Action action3 = (Action)CollectionsKt.getOrNull(this.actions, (int)(actionMetaData.getIndex() + 1));
                if (action3 == null) {
                    action3 = new TransitionsAction(this.transitions, indexMetadataProvider);
                }
                actionConfig = action3;
            }
        }
        return actionConfig;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final List<Action> component2() {
        return this.actions;
    }

    @NotNull
    public final List<Transition> component3() {
        return this.transitions;
    }

    @NotNull
    public final State copy(@NotNull String name, @NotNull List<? extends Action> actions, @NotNull List<Transition> transitions) {
        Intrinsics.checkNotNullParameter((Object)name, (String)NAME_FIELD);
        Intrinsics.checkNotNullParameter(actions, (String)ACTIONS_FIELD);
        Intrinsics.checkNotNullParameter(transitions, (String)TRANSITIONS_FIELD);
        return new State(name, actions, transitions);
    }

    public static /* synthetic */ State copy$default(State state, String string, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            string = state.name;
        }
        if ((n & 2) != 0) {
            list = state.actions;
        }
        if ((n & 4) != 0) {
            list2 = state.transitions;
        }
        return state.copy(string, list, list2);
    }

    @NotNull
    public String toString() {
        return "State(name=" + this.name + ", actions=" + this.actions + ", transitions=" + this.transitions + ")";
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + ((Object)this.actions).hashCode();
        result2 = result2 * 31 + ((Object)this.transitions).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof State)) {
            return false;
        }
        State state = (State)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)state.name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.actions, state.actions)) {
            return false;
        }
        return Intrinsics.areEqual(this.transitions, state.transitions);
    }

    private static final Action _init_$lambda$6(StreamInput it) {
        ISMActionsParser iSMActionsParser = ISMActionsParser.Companion.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return iSMActionsParser.fromStreamInput(it);
    }

    @JvmStatic
    @NotNull
    public static final State parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/model/State$Companion;", "", "()V", "ACTIONS_FIELD", "", "NAME_FIELD", "TRANSITIONS_FIELD", "parse", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/State;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "opensearch-index-management"})
    @SourceDebugExtension(value={"SMAP\nState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 State.kt\norg/opensearch/indexmanagement/indexstatemanagement/model/State$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n1#2:149\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final State parse(@NotNull XContentParser xcp) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            String name = null;
            List actions = new ArrayList();
            List transitions = new ArrayList();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            block10: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName;
                block17: {
                    fieldName = xcp.currentName();
                    xcp.nextToken();
                    String string = fieldName;
                    if (string == null) break block17;
                    int n = -1;
                    switch (string.hashCode()) {
                        case 3373707: {
                            if (string.equals(State.NAME_FIELD)) {
                                n = 1;
                            }
                            break;
                        }
                        case -1909310018: {
                            if (string.equals(State.TRANSITIONS_FIELD)) {
                                n = 2;
                            }
                            break;
                        }
                        case -1161803523: {
                            if (string.equals(State.ACTIONS_FIELD)) {
                                n = 3;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 1: {
                            name = xcp.text();
                            continue block10;
                        }
                        case 3: {
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                            while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                                actions.add(ISMActionsParser.Companion.getInstance().parse(xcp, actions.size()));
                            }
                            continue block10;
                        }
                        case 2: {
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                            while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                                transitions.add(Transition.Companion.parse(xcp));
                            }
                            continue block10;
                        }
                    }
                }
                throw new IllegalArgumentException("Invalid field: [" + fieldName + "] found in State.");
            }
            String string = name;
            if (string == null) {
                boolean bl = false;
                String string2 = "State name is null";
                throw new IllegalArgumentException(string2.toString());
            }
            List list = CollectionsKt.toList((Iterable)transitions);
            List list2 = CollectionsKt.toList((Iterable)actions);
            String string3 = string;
            return new State(string3, list2, list);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

