## Copyright 2009 Intel Corporation
## SPDX-License-Identifier: Apache-2.0


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was rkcommonConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib/cmake/rkcommon-1.11.0" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

include("${CMAKE_CURRENT_LIST_DIR}/rkcommon_Exports.cmake")
include("${CMAKE_CURRENT_LIST_DIR}/rkcommon_macros.cmake")

check_required_components("rkcommon")

## Stash incoming CMAKE_MODULE_PATH ##

set(RKCOMMON_CALLERS_CMAKE_MODULE_PATH ${CMAKE_MODULE_PATH})
set(CMAKE_MODULE_PATH ${CMAKE_MODULE_PATH} ${CMAKE_CURRENT_LIST_DIR})

## Create rkcommon tasking target ##

set(RKCOMMON_TASKING_SYSTEM      TBB)

set(RKCOMMON_TASKING_TBB         TRUE)
set(RKCOMMON_TASKING_OPENMP      FALSE)
set(RKCOMMON_TASKING_INTERNAL    FALSE)
set(RKCOMMON_TASKING_DEBUG       FALSE)

rkcommon_create_tasking_target(TRUE)

## Restore CMAKE_MODULE_PATH ##

set(CMAKE_MODULE_PATH ${RKCOMMON_CALLERS_CMAKE_MODULE_PATH})

## Standard signal that the package was found ##

set(RKCOMMON_FOUND TRUE)
