/*
 * Decompiled with CFR 0.152.
 */
package com.concurrent_ruby.ext;

import java.io.IOException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaSemaphoreLibrary {
    private static final ObjectAllocator JRUBYREFERENCE_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new JavaSemaphore(ruby, rubyClass);
        }
    };

    public void load(Ruby ruby, boolean bl) throws IOException {
        RubyModule rubyModule = ruby.defineModule("Concurrent");
        RubyClass rubyClass = rubyModule.defineClassUnder("JavaSemaphore", ruby.getObject(), JRUBYREFERENCE_ALLOCATOR);
        rubyClass.defineAnnotatedMethods(JavaSemaphore.class);
    }

    @JRubyClass(name={"JavaSemaphore"}, parent="Object")
    public static class JavaSemaphore
    extends RubyObject {
        private JRubySemaphore semaphore;

        public JavaSemaphore(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
        }

        @JRubyMethod
        public IRubyObject initialize(ThreadContext threadContext, IRubyObject iRubyObject) {
            this.semaphore = new JRubySemaphore(this.rubyFixnumInt(iRubyObject, "count"));
            return threadContext.nil;
        }

        @JRubyMethod
        public IRubyObject acquire(ThreadContext threadContext, Block block) throws InterruptedException {
            return this.acquire(threadContext, 1, block);
        }

        @JRubyMethod
        public IRubyObject acquire(ThreadContext threadContext, IRubyObject iRubyObject, Block block) throws InterruptedException {
            return this.acquire(threadContext, this.rubyFixnumToPositiveInt(iRubyObject, "permits"), block);
        }

        @JRubyMethod(name={"available_permits"})
        public IRubyObject availablePermits(ThreadContext threadContext) {
            return this.getRuntime().newFixnum(this.semaphore.availablePermits());
        }

        @JRubyMethod(name={"drain_permits"})
        public IRubyObject drainPermits(ThreadContext threadContext) {
            return this.getRuntime().newFixnum(this.semaphore.drainPermits());
        }

        @JRubyMethod(name={"try_acquire"})
        public IRubyObject tryAcquire(ThreadContext threadContext, Block block) throws InterruptedException {
            int n = 1;
            boolean bl = this.semaphore.tryAcquire(n);
            return this.triedAcquire(threadContext, n, bl, block);
        }

        @JRubyMethod(name={"try_acquire"})
        public IRubyObject tryAcquire(ThreadContext threadContext, IRubyObject iRubyObject, Block block) throws InterruptedException {
            int n = this.rubyFixnumToPositiveInt(iRubyObject, "permits");
            boolean bl = this.semaphore.tryAcquire(n);
            return this.triedAcquire(threadContext, n, bl, block);
        }

        @JRubyMethod(name={"try_acquire"})
        public IRubyObject tryAcquire(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) throws InterruptedException {
            int n = this.rubyFixnumToPositiveInt(iRubyObject, "permits");
            boolean bl = this.semaphore.tryAcquire(n, this.rubyNumericToLong(iRubyObject2, "timeout"), TimeUnit.SECONDS);
            return this.triedAcquire(threadContext, n, bl, block);
        }

        @JRubyMethod
        public IRubyObject release(ThreadContext threadContext) {
            this.semaphore.release(1);
            return this.getRuntime().newBoolean(true);
        }

        @JRubyMethod
        public IRubyObject release(ThreadContext threadContext, IRubyObject iRubyObject) {
            this.semaphore.release(this.rubyFixnumToPositiveInt(iRubyObject, "permits"));
            return this.getRuntime().newBoolean(true);
        }

        @JRubyMethod(name={"reduce_permits"})
        public IRubyObject reducePermits(ThreadContext threadContext, IRubyObject iRubyObject) throws InterruptedException {
            this.semaphore.publicReducePermits(this.rubyFixnumToNonNegativeInt(iRubyObject, "reduction"));
            return threadContext.nil;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IRubyObject acquire(ThreadContext threadContext, int n, Block block) throws InterruptedException {
            this.semaphore.acquire(n);
            if (!block.isGiven()) {
                return threadContext.nil;
            }
            try {
                IRubyObject iRubyObject = block.yieldSpecific(threadContext);
                return iRubyObject;
            }
            finally {
                this.semaphore.release(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IRubyObject triedAcquire(ThreadContext threadContext, int n, boolean bl, Block block) {
            if (!block.isGiven()) {
                return this.getRuntime().newBoolean(bl);
            }
            if (!bl) {
                return threadContext.nil;
            }
            try {
                IRubyObject iRubyObject = block.yieldSpecific(threadContext);
                return iRubyObject;
            }
            finally {
                this.semaphore.release(n);
            }
        }

        private int rubyFixnumInt(IRubyObject iRubyObject, String string) {
            if (iRubyObject instanceof RubyFixnum) {
                RubyFixnum rubyFixnum = (RubyFixnum)iRubyObject;
                return (int)rubyFixnum.getLongValue();
            }
            throw this.getRuntime().newArgumentError(string + " must be integer");
        }

        private int rubyFixnumToNonNegativeInt(IRubyObject iRubyObject, String string) {
            if (iRubyObject instanceof RubyFixnum && ((RubyFixnum)iRubyObject).getLongValue() >= 0L) {
                RubyFixnum rubyFixnum = (RubyFixnum)iRubyObject;
                return (int)rubyFixnum.getLongValue();
            }
            throw this.getRuntime().newArgumentError(string + " must be a non-negative integer");
        }

        private int rubyFixnumToPositiveInt(IRubyObject iRubyObject, String string) {
            if (iRubyObject instanceof RubyFixnum && ((RubyFixnum)iRubyObject).getLongValue() > 0L) {
                RubyFixnum rubyFixnum = (RubyFixnum)iRubyObject;
                return (int)rubyFixnum.getLongValue();
            }
            throw this.getRuntime().newArgumentError(string + " must be an integer greater than zero");
        }

        private long rubyNumericToLong(IRubyObject iRubyObject, String string) {
            if (iRubyObject instanceof RubyNumeric && ((RubyNumeric)iRubyObject).getDoubleValue() > 0.0) {
                RubyNumeric rubyNumeric = (RubyNumeric)iRubyObject;
                return rubyNumeric.getLongValue();
            }
            throw this.getRuntime().newArgumentError(string + " must be a float greater than zero");
        }

        class JRubySemaphore
        extends Semaphore {
            public JRubySemaphore(int n) {
                super(n);
            }

            public JRubySemaphore(int n, boolean bl) {
                super(n, bl);
            }

            public void publicReducePermits(int n) {
                this.reducePermits(n);
            }
        }
    }
}

