/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerConnectionPoolDataSource;
import com.microsoft.sqlserver.jdbc.SQLServerXAConnection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Reference;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public final class SQLServerXADataSource
extends SQLServerConnectionPoolDataSource
implements XADataSource {
    static Logger xaLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.XA");

    @Override
    public XAConnection getXAConnection(String string, String string2) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getXAConnection", new Object[]{string, "Password not traced"});
        }
        SQLServerXAConnection sQLServerXAConnection = new SQLServerXAConnection(this, string, string2);
        if (xaLogger.isLoggable(Level.FINER)) {
            xaLogger.finer(this.toString() + " user:" + string + sQLServerXAConnection.toString());
        }
        if (xaLogger.isLoggable(Level.FINER)) {
            xaLogger.finer(this.toString() + " Start get physical connection.");
        }
        SQLServerConnection sQLServerConnection = (SQLServerConnection)sQLServerXAConnection.getPhysicalConnection();
        if (xaLogger.isLoggable(Level.FINE)) {
            xaLogger.fine(this.toString() + " End get physical connection, " + sQLServerConnection.toString());
        }
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.exiting(this.getClassNameLogging(), "getXAConnection", sQLServerXAConnection);
        }
        return sQLServerXAConnection;
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getXAConnection");
        }
        return this.getXAConnection(this.getUser(), this.getPassword());
    }

    @Override
    public Reference getReference() {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getReference");
        }
        Reference reference = this.getReferenceInternal("com.microsoft.sqlserver.jdbc.SQLServerXADataSource");
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.exiting(this.getClassNameLogging(), "getReference", reference);
        }
        return reference;
    }
}

