/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import net.sf.freecol.common.util.Utils;

public class DesktopEntry {
    private static final File SOURCE_DIRECTORY = new File("data", "strings");
    private static final String GENERIC_NAME = "freecol.desktopEntry.GenericName";
    private static final String COMMENT = "freecol.desktopEntry.Comment";

    public static void main(String[] args) throws IOException {
        try (Writer result = Utils.getFileUTF8Writer(new File(args[0]));){
            result.append("[Desktop Entry]\n");
            result.append("Version=1.0\n");
            result.append("Type=Application\n");
            result.append("Name=FreeCol\n");
            result.append("Exec=freecol\n");
            result.append("Icon=data/freecol.png\n");
            result.append("Categories=Game;StrategyGame;\n");
            String[] sourceFiles = SOURCE_DIRECTORY.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("FreeColMessages") && name.endsWith(".properties");
                }
            });
            if (sourceFiles == null) {
                System.err.println("No messages files found in " + SOURCE_DIRECTORY);
                System.exit(1);
            }
            block13: for (String name : sourceFiles) {
                System.out.println("Processing source file: " + name);
                String languageCode = null;
                if (name.startsWith("FreeColMessages_")) {
                    int index = name.indexOf(46, 16);
                    languageCode = name.substring(16, index).replace('-', '@');
                }
                boolean foundGenericName = false;
                boolean foundComment = false;
                File sourceFile = new File(SOURCE_DIRECTORY, name);
                Reader reader = Utils.getFileUTF8Reader(sourceFile);
                BufferedReader bufferedReader = new BufferedReader(reader);
                String line = bufferedReader.readLine();
                block14: while (line != null) {
                    int index = line.indexOf(61);
                    if (index >= 0) {
                        String key;
                        switch (key = line.substring(0, index).trim()) {
                            case "freecol.desktopEntry.GenericName": {
                                result.append("GenericName");
                                foundGenericName = true;
                                break;
                            }
                            case "freecol.desktopEntry.Comment": {
                                result.append("Comment");
                                foundComment = true;
                                break;
                            }
                            default: {
                                line = bufferedReader.readLine();
                                continue block14;
                            }
                        }
                        if (languageCode != null) {
                            result.append("[" + languageCode + "]");
                        }
                        result.append('=');
                        result.append(line.substring(index + 1).trim());
                        result.append("\n");
                        if (foundGenericName && foundComment) continue block13;
                    }
                    line = bufferedReader.readLine();
                }
            }
            result.flush();
        }
    }
}

