/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.results;

import java.io.Serializable;
import java.util.List;
import org.gradle.api.internal.tasks.testing.results.TestState;
import org.gradle.api.tasks.testing.TestFailure;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.InternalTransformer;
import org.gradle.util.internal.CollectionUtils;

public class DefaultTestResult
implements TestResult,
Serializable {
    private final List<TestFailure> failures;
    private final TestResult.ResultType resultType;
    private final long startTime;
    private final long endTime;
    private final long testCount;
    private final long successfulCount;
    private final long failedCount;

    public DefaultTestResult(TestState state) {
        this(state.resultType, state.getStartTime(), state.getEndTime(), state.testCount, state.successfulCount, state.failedCount, state.failures);
    }

    public DefaultTestResult(TestResult.ResultType resultType, long startTime, long endTime, long testCount, long successfulCount, long failedCount, List<TestFailure> failures) {
        this.resultType = resultType;
        this.startTime = startTime;
        this.endTime = endTime;
        this.testCount = testCount;
        this.successfulCount = successfulCount;
        this.failedCount = failedCount;
        this.failures = failures;
    }

    @Override
    public TestResult.ResultType getResultType() {
        return this.resultType;
    }

    @Override
    public Throwable getException() {
        return this.failures.isEmpty() ? null : this.failures.get(0).getRawFailure();
    }

    @Override
    public List<Throwable> getExceptions() {
        return CollectionUtils.collect(this.failures, (InternalTransformer)new InternalTransformer<Throwable, TestFailure>(){

            public Throwable transform(TestFailure testFailure) {
                return testFailure.getRawFailure();
            }
        });
    }

    @Override
    public List<TestFailure> getFailures() {
        return this.failures;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public long getTestCount() {
        return this.testCount;
    }

    @Override
    public long getSuccessfulTestCount() {
        return this.successfulCount;
    }

    @Override
    public long getSkippedTestCount() {
        return this.testCount - this.successfulCount - this.failedCount;
    }

    @Override
    public long getFailedTestCount() {
        return this.failedCount;
    }

    public String toString() {
        return this.resultType.toString();
    }
}

