/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDescriptorPoolSize
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int DESCRIPTORCOUNT;

    public VkDescriptorPoolSize(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDescriptorPoolSize.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDescriptorType")
    public int type() {
        return VkDescriptorPoolSize.ntype(this.address());
    }

    @NativeType(value="uint32_t")
    public int descriptorCount() {
        return VkDescriptorPoolSize.ndescriptorCount(this.address());
    }

    public VkDescriptorPoolSize type(@NativeType(value="VkDescriptorType") int value) {
        VkDescriptorPoolSize.ntype(this.address(), value);
        return this;
    }

    public VkDescriptorPoolSize descriptorCount(@NativeType(value="uint32_t") int value) {
        VkDescriptorPoolSize.ndescriptorCount(this.address(), value);
        return this;
    }

    public VkDescriptorPoolSize set(int type, int descriptorCount) {
        this.type(type);
        this.descriptorCount(descriptorCount);
        return this;
    }

    public VkDescriptorPoolSize set(VkDescriptorPoolSize src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDescriptorPoolSize malloc() {
        return (VkDescriptorPoolSize)VkDescriptorPoolSize.wrap(VkDescriptorPoolSize.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkDescriptorPoolSize calloc() {
        return (VkDescriptorPoolSize)VkDescriptorPoolSize.wrap(VkDescriptorPoolSize.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkDescriptorPoolSize create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkDescriptorPoolSize)VkDescriptorPoolSize.wrap(VkDescriptorPoolSize.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkDescriptorPoolSize create(long address) {
        return (VkDescriptorPoolSize)VkDescriptorPoolSize.wrap(VkDescriptorPoolSize.class, (long)address);
    }

    @Nullable
    public static VkDescriptorPoolSize createSafe(long address) {
        return address == 0L ? null : (VkDescriptorPoolSize)VkDescriptorPoolSize.wrap(VkDescriptorPoolSize.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkDescriptorPoolSize.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkDescriptorPoolSize.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkDescriptorPoolSize.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDescriptorPoolSize.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkDescriptorPoolSize.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkDescriptorPoolSize.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkDescriptorPoolSize.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VkDescriptorPoolSize mallocStack() {
        return VkDescriptorPoolSize.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDescriptorPoolSize callocStack() {
        return VkDescriptorPoolSize.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDescriptorPoolSize mallocStack(MemoryStack stack) {
        return VkDescriptorPoolSize.malloc(stack);
    }

    @Deprecated
    public static VkDescriptorPoolSize callocStack(MemoryStack stack) {
        return VkDescriptorPoolSize.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDescriptorPoolSize.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDescriptorPoolSize.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDescriptorPoolSize.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDescriptorPoolSize.calloc(capacity, stack);
    }

    public static VkDescriptorPoolSize malloc(MemoryStack stack) {
        return (VkDescriptorPoolSize)VkDescriptorPoolSize.wrap(VkDescriptorPoolSize.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDescriptorPoolSize calloc(MemoryStack stack) {
        return (VkDescriptorPoolSize)VkDescriptorPoolSize.wrap(VkDescriptorPoolSize.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkDescriptorPoolSize.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkDescriptorPoolSize.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static int ndescriptorCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)DESCRIPTORCOUNT);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void ndescriptorCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DESCRIPTORCOUNT, value);
    }

    static {
        Struct.Layout layout = VkDescriptorPoolSize.__struct((Struct.Member[])new Struct.Member[]{VkDescriptorPoolSize.__member((int)4), VkDescriptorPoolSize.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        DESCRIPTORCOUNT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkDescriptorPoolSize, Buffer>
    implements NativeResource {
        private static final VkDescriptorPoolSize ELEMENT_FACTORY = VkDescriptorPoolSize.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkDescriptorPoolSize getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDescriptorType")
        public int type() {
            return VkDescriptorPoolSize.ntype(this.address());
        }

        @NativeType(value="uint32_t")
        public int descriptorCount() {
            return VkDescriptorPoolSize.ndescriptorCount(this.address());
        }

        public Buffer type(@NativeType(value="VkDescriptorType") int value) {
            VkDescriptorPoolSize.ntype(this.address(), value);
            return this;
        }

        public Buffer descriptorCount(@NativeType(value="uint32_t") int value) {
            VkDescriptorPoolSize.ndescriptorCount(this.address(), value);
            return this;
        }
    }
}

