# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("wsdapi.dll")
prototypes = \
    {
        #
        'WSDXMLGetNameFromBuiltinNamespace': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Space": SimTypePointer(SimStruct({"Uri": SimTypeBottom(label="PWSTR"), "PreferredPrefix": SimTypeBottom(label="PWSTR"), "Names": SimTypePointer(SimTypeBottom(label="WSDXML_NAME"), offset=0), "NamesCount": SimTypeShort(signed=False, label="UInt16"), "Encoding": SimTypeShort(signed=False, label="UInt16")}, name="WSDXML_NAMESPACE", pack=False, align=None), offset=0), "LocalName": SimTypeBottom(label="PWSTR")}, name="WSDXML_NAME", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszNamespace", "pszName", "ppName"]),
        #
        'WSDXMLCreateContext': SimTypeFunction([SimTypePointer(SimTypeBottom(label="IWSDXMLContext"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ppContext"]),
        #
        'WSDCreateUdpMessageParameters': SimTypeFunction([SimTypePointer(SimTypeBottom(label="IWSDUdpMessageParameters"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ppTxParams"]),
        #
        'WSDCreateUdpAddress': SimTypeFunction([SimTypePointer(SimTypeBottom(label="IWSDUdpAddress"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ppAddress"]),
        #
        'WSDCreateHttpMessageParameters': SimTypeFunction([SimTypePointer(SimTypeBottom(label="IWSDHttpMessageParameters"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ppTxParams"]),
        #
        'WSDCreateHttpAddress': SimTypeFunction([SimTypePointer(SimTypeBottom(label="IWSDHttpAddress"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ppAddress"]),
        #
        'WSDSetConfigurationOption': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["dwOption", "pVoid", "cbInBuffer"]),
        #
        'WSDGetConfigurationOption': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["dwOption", "pVoid", "cbOutBuffer"]),
        #
        'WSDAllocateLinkedMemory': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["pParent", "cbSize"]),
        #
        'WSDFreeLinkedMemory': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pVoid"]),
        #
        'WSDAttachLinkedMemory': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pParent", "pChild"]),
        #
        'WSDDetachLinkedMemory': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pVoid"]),
        #
        'WSDXMLBuildAnyForSingleElement': SimTypeFunction([SimTypePointer(SimStruct({"Space": SimTypePointer(SimStruct({"Uri": SimTypeBottom(label="PWSTR"), "PreferredPrefix": SimTypeBottom(label="PWSTR"), "Names": SimTypePointer(SimTypeBottom(label="WSDXML_NAME"), offset=0), "NamesCount": SimTypeShort(signed=False, label="UInt16"), "Encoding": SimTypeShort(signed=False, label="UInt16")}, name="WSDXML_NAMESPACE", pack=False, align=None), offset=0), "LocalName": SimTypeBottom(label="PWSTR")}, name="WSDXML_NAME", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Node": SimStruct({"Type": SimTypeInt(signed=True, label="Int32"), "Parent": SimTypePointer(SimTypeBottom(label="WSDXML_ELEMENT"), offset=0), "Next": SimTypePointer(SimTypeBottom(label="WSDXML_NODE"), offset=0)}, name="WSDXML_NODE", pack=False, align=None), "Name": SimTypePointer(SimStruct({"Space": SimTypePointer(SimStruct({"Uri": SimTypeBottom(label="PWSTR"), "PreferredPrefix": SimTypeBottom(label="PWSTR"), "Names": SimTypePointer(SimTypeBottom(label="WSDXML_NAME"), offset=0), "NamesCount": SimTypeShort(signed=False, label="UInt16"), "Encoding": SimTypeShort(signed=False, label="UInt16")}, name="WSDXML_NAMESPACE", pack=False, align=None), offset=0), "LocalName": SimTypeBottom(label="PWSTR")}, name="WSDXML_NAME", pack=False, align=None), offset=0), "FirstAttribute": SimTypePointer(SimStruct({"Element": SimTypePointer(SimTypeBottom(label="WSDXML_ELEMENT"), offset=0), "Next": SimTypePointer(SimTypeBottom(label="WSDXML_ATTRIBUTE"), offset=0), "Name": SimTypePointer(SimStruct({"Space": SimTypePointer(SimStruct({"Uri": SimTypeBottom(label="PWSTR"), "PreferredPrefix": SimTypeBottom(label="PWSTR"), "Names": SimTypePointer(SimTypeBottom(label="WSDXML_NAME"), offset=0), "NamesCount": SimTypeShort(signed=False, label="UInt16"), "Encoding": SimTypeShort(signed=False, label="UInt16")}, name="WSDXML_NAMESPACE", pack=False, align=None), offset=0), "LocalName": SimTypeBottom(label="PWSTR")}, name="WSDXML_NAME", pack=False, align=None), offset=0), "Value": SimTypeBottom(label="PWSTR")}, name="WSDXML_ATTRIBUTE", pack=False, align=None), offset=0), "FirstChild": SimTypePointer(SimStruct({"Type": SimTypeInt(signed=True, label="Int32"), "Parent": SimTypePointer(SimTypeBottom(label="WSDXML_ELEMENT"), offset=0), "Next": SimTypePointer(SimTypeBottom(label="WSDXML_NODE"), offset=0)}, name="WSDXML_NODE", pack=False, align=None), offset=0), "PrefixMappings": SimTypePointer(SimStruct({"Refs": SimTypeInt(signed=False, label="UInt32"), "Next": SimTypePointer(SimTypeBottom(label="WSDXML_PREFIX_MAPPING"), offset=0), "Space": SimTypePointer(SimStruct({"Uri": SimTypeBottom(label="PWSTR"), "PreferredPrefix": SimTypeBottom(label="PWSTR"), "Names": SimTypePointer(SimTypeBottom(label="WSDXML_NAME"), offset=0), "NamesCount": SimTypeShort(signed=False, label="UInt16"), "Encoding": SimTypeShort(signed=False, label="UInt16")}, name="WSDXML_NAMESPACE", pack=False, align=None), offset=0), "Prefix": SimTypeBottom(label="PWSTR")}, name="WSDXML_PREFIX_MAPPING", pack=False, align=None), offset=0)}, name="WSDXML_ELEMENT", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pElementName", "pszText", "ppAny"]),
        #
        'WSDXMLGetValueFromAny': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"Node": SimStruct({"Type": SimTypeInt(signed=True, label="Int32"), "Parent": SimTypePointer(SimTypeBottom(label="WSDXML_ELEMENT"), offset=0), "Next": SimTypePointer(SimTypeBottom(label="WSDXML_NODE"), offset=0)}, name="WSDXML_NODE", pack=False, align=None), "Name": SimTypePointer(SimStruct({"Space": SimTypePointer(SimStruct({"Uri": SimTypeBottom(label="PWSTR"), "PreferredPrefix": SimTypeBottom(label="PWSTR"), "Names": SimTypePointer(SimTypeBottom(label="WSDXML_NAME"), offset=0), "NamesCount": SimTypeShort(signed=False, label="UInt16"), "Encoding": SimTypeShort(signed=False, label="UInt16")}, name="WSDXML_NAMESPACE", pack=False, align=None), offset=0), "LocalName": SimTypeBottom(label="PWSTR")}, name="WSDXML_NAME", pack=False, align=None), offset=0), "FirstAttribute": SimTypePointer(SimStruct({"Element": SimTypePointer(SimTypeBottom(label="WSDXML_ELEMENT"), offset=0), "Next": SimTypePointer(SimTypeBottom(label="WSDXML_ATTRIBUTE"), offset=0), "Name": SimTypePointer(SimStruct({"Space": SimTypePointer(SimStruct({"Uri": SimTypeBottom(label="PWSTR"), "PreferredPrefix": SimTypeBottom(label="PWSTR"), "Names": SimTypePointer(SimTypeBottom(label="WSDXML_NAME"), offset=0), "NamesCount": SimTypeShort(signed=False, label="UInt16"), "Encoding": SimTypeShort(signed=False, label="UInt16")}, name="WSDXML_NAMESPACE", pack=False, align=None), offset=0), "LocalName": SimTypeBottom(label="PWSTR")}, name="WSDXML_NAME", pack=False, align=None), offset=0), "Value": SimTypeBottom(label="PWSTR")}, name="WSDXML_ATTRIBUTE", pack=False, align=None), offset=0), "FirstChild": SimTypePointer(SimStruct({"Type": SimTypeInt(signed=True, label="Int32"), "Parent": SimTypePointer(SimTypeBottom(label="WSDXML_ELEMENT"), offset=0), "Next": SimTypePointer(SimTypeBottom(label="WSDXML_NODE"), offset=0)}, name="WSDXML_NODE", pack=False, align=None), offset=0), "PrefixMappings": SimTypePointer(SimStruct({"Refs": SimTypeInt(signed=False, label="UInt32"), "Next": SimTypePointer(SimTypeBottom(label="WSDXML_PREFIX_MAPPING"), offset=0), "Space": SimTypePointer(SimStruct({"Uri": SimTypeBottom(label="PWSTR"), "PreferredPrefix": SimTypeBottom(label="PWSTR"), "Names": SimTypePointer(SimTypeBottom(label="WSDXML_NAME"), offset=0), "NamesCount": SimTypeShort(signed=False, label="UInt16"), "Encoding": SimTypeShort(signed=False, label="UInt16")}, name="WSDXML_NAMESPACE", pack=False, align=None), offset=0), "Prefix": SimTypeBottom(label="PWSTR")}, name="WSDXML_PREFIX_MAPPING", pack=False, align=None), offset=0)}, name="WSDXML_ELEMENT", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszNamespace", "pszName", "pAny", "ppszValue"]),
        #
        'WSDXMLAddSibling': SimTypeFunction([SimTypePointer(SimStruct({"Node": SimStruct({"Type": SimTypeInt(signed=True, label="Int32"), "Parent": SimTypePointer(SimTypeBottom(label="WSDXML_ELEMENT"), offset=0), "Next": SimTypePointer(SimTypeBottom(label="WSDXML_NODE"), offset=0)}, name="WSDXML_NODE", pack=False, align=None), "Name": SimTypePointer(SimStruct({"Space": SimTypePointer(SimStruct({"Uri": SimTypeBottom(label="PWSTR"), "PreferredPrefix": SimTypeBottom(label="PWSTR"), "Names": SimTypePointer(SimTypeBottom(label="WSDXML_NAME"), offset=0), "NamesCount": SimTypeShort(signed=False, label="UInt16"), "Encoding": SimTypeShort(signed=False, label="UInt16")}, name="WSDXML_NAMESPACE", pack=False, align=None), offset=0), "LocalName": SimTypeBottom(label="PWSTR")}, name="WSDXML_NAME", pack=False, align=None), offset=0), "FirstAttribute": SimTypePointer(SimStruct({"Element": SimTypePointer(SimTypeBottom(label="WSDXML_ELEMENT"), offset=0), "Next": SimTypePointer(SimTypeBottom(label="WSDXML_ATTRIBUTE"), offset=0), "Name": SimTypePointer(SimStruct({"Space": SimTypePointer(SimStruct({"Uri": SimTypeBottom(label="PWSTR"), "PreferredPrefix": SimTypeBottom(label="PWSTR"), "Names": SimTypePointer(SimTypeBottom(label="WSDXML_NAME"), offset=0), "NamesCount": SimTypeShort(signed=False, label="UInt16"), "Encoding": SimTypeShort(signed=False, label="UInt16")}, name="WSDXML_NAMESPACE", pack=False, align=None), offset=0), "LocalName": SimTypeBottom(label="PWSTR")}, name="WSDXML_NAME", pack=False, align=None), offset=0), "Value": SimTypeBottom(label="PWSTR")}, name="WSDXML_ATTRIBUTE", pack=False, align=None), offset=0), "FirstChild": SimTypePointer(SimStruct({"Type": SimTypeInt(signed=True, label="Int32"), "Parent": SimTypePointer(SimTypeBottom(label="WSDXML_ELEMENT"), offset=0), "Next": SimTypePointer(SimTypeBottom(label="WSDXML_NODE"), offset=0)}, name="WSDXML_NODE", pack=False, align=None), offset=0), "PrefixMappings": SimTypePointer(SimStruct({"Refs": SimTypeInt(signed=False, label="UInt32"), "Next": SimTypePointer(SimTypeBottom(label="WSDXML_PREFIX_MAPPING"), offset=0), "Space": SimTypePointer(SimStruct({"Uri": SimTypeBottom(label="PWSTR"), "PreferredPrefix": SimTypeBottom(label="PWSTR"), "Names": SimTypePointer(SimTypeBottom(label="WSDXML_NAME"), offset=0), "NamesCount": SimTypeShort(signed=False, label="UInt16"), "Encoding": SimTypeShort(signed=False, label="UInt16")}, name="WSDXML_NAMESPACE", pack=False, align=None), offset=0), "Prefix": SimTypeBottom(label="PWSTR")}, name="WSDXML_PREFIX_MAPPING", pack=False, align=None), offset=0)}, name="WSDXML_ELEMENT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Node": SimStruct({"Type": SimTypeInt(signed=True, label="Int32"), "Parent": SimTypePointer(SimTypeBottom(label="WSDXML_ELEMENT"), offset=0), "Next": SimTypePointer(SimTypeBottom(label="WSDXML_NODE"), offset=0)}, name="WSDXML_NODE", pack=False, align=None), "Name": SimTypePointer(SimStruct({"Space": SimTypePointer(SimStruct({"Uri": SimTypeBottom(label="PWSTR"), "PreferredPrefix": SimTypeBottom(label="PWSTR"), "Names": SimTypePointer(SimTypeBottom(label="WSDXML_NAME"), offset=0), "NamesCount": SimTypeShort(signed=False, label="UInt16"), "Encoding": SimTypeShort(signed=False, label="UInt16")}, name="WSDXML_NAMESPACE", pack=False, align=None), offset=0), "LocalName": SimTypeBottom(label="PWSTR")}, name="WSDXML_NAME", pack=False, align=None), offset=0), "FirstAttribute": SimTypePointer(SimStruct({"Element": SimTypePointer(SimTypeBottom(label="WSDXML_ELEMENT"), offset=0), "Next": SimTypePointer(SimTypeBottom(label="WSDXML_ATTRIBUTE"), offset=0), "Name": SimTypePointer(SimStruct({"Space": SimTypePointer(SimStruct({"Uri": SimTypeBottom(label="PWSTR"), "PreferredPrefix": SimTypeBottom(label="PWSTR"), "Names": SimTypePointer(SimTypeBottom(label="WSDXML_NAME"), offset=0), "NamesCount": SimTypeShort(signed=False, label="UInt16"), "Encoding": SimTypeShort(signed=False, label="UInt16")}, name="WSDXML_NAMESPACE", pack=False, align=None), offset=0), "LocalName": SimTypeBottom(label="PWSTR")}, name="WSDXML_NAME", pack=False, align=None), offset=0), "Value": SimTypeBottom(label="PWSTR")}, name="WSDXML_ATTRIBUTE", pack=False, align=None), offset=0), "FirstChild": SimTypePointer(SimStruct({"Type": SimTypeInt(signed=True, label="Int32"), "Parent": SimTypePointer(SimTypeBottom(label="WSDXML_ELEMENT"), offset=0), "Next": SimTypePointer(SimTypeBottom(label="WSDXML_NODE"), offset=0)}, name="WSDXML_NODE", pack=False, align=None), offset=0), "PrefixMappings": SimTypePointer(SimStruct({"Refs": SimTypeInt(signed=False, label="UInt32"), "Next": SimTypePointer(SimTypeBottom(label="WSDXML_PREFIX_MAPPING"), offset=0), "Space": SimTypePointer(SimStruct({"Uri": SimTypeBottom(label="PWSTR"), "PreferredPrefix": SimTypeBottom(label="PWSTR"), "Names": SimTypePointer(SimTypeBottom(label="WSDXML_NAME"), offset=0), "NamesCount": SimTypeShort(signed=False, label="UInt16"), "Encoding": SimTypeShort(signed=False, label="UInt16")}, name="WSDXML_NAMESPACE", pack=False, align=None), offset=0), "Prefix": SimTypeBottom(label="PWSTR")}, name="WSDXML_PREFIX_MAPPING", pack=False, align=None), offset=0)}, name="WSDXML_ELEMENT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pFirst", "pSecond"]),
        #
        'WSDXMLAddChild': SimTypeFunction([SimTypePointer(SimStruct({"Node": SimStruct({"Type": SimTypeInt(signed=True, label="Int32"), "Parent": SimTypePointer(SimTypeBottom(label="WSDXML_ELEMENT"), offset=0), "Next": SimTypePointer(SimTypeBottom(label="WSDXML_NODE"), offset=0)}, name="WSDXML_NODE", pack=False, align=None), "Name": SimTypePointer(SimStruct({"Space": SimTypePointer(SimStruct({"Uri": SimTypeBottom(label="PWSTR"), "PreferredPrefix": SimTypeBottom(label="PWSTR"), "Names": SimTypePointer(SimTypeBottom(label="WSDXML_NAME"), offset=0), "NamesCount": SimTypeShort(signed=False, label="UInt16"), "Encoding": SimTypeShort(signed=False, label="UInt16")}, name="WSDXML_NAMESPACE", pack=False, align=None), offset=0), "LocalName": SimTypeBottom(label="PWSTR")}, name="WSDXML_NAME", pack=False, align=None), offset=0), "FirstAttribute": SimTypePointer(SimStruct({"Element": SimTypePointer(SimTypeBottom(label="WSDXML_ELEMENT"), offset=0), "Next": SimTypePointer(SimTypeBottom(label="WSDXML_ATTRIBUTE"), offset=0), "Name": SimTypePointer(SimStruct({"Space": SimTypePointer(SimStruct({"Uri": SimTypeBottom(label="PWSTR"), "PreferredPrefix": SimTypeBottom(label="PWSTR"), "Names": SimTypePointer(SimTypeBottom(label="WSDXML_NAME"), offset=0), "NamesCount": SimTypeShort(signed=False, label="UInt16"), "Encoding": SimTypeShort(signed=False, label="UInt16")}, name="WSDXML_NAMESPACE", pack=False, align=None), offset=0), "LocalName": SimTypeBottom(label="PWSTR")}, name="WSDXML_NAME", pack=False, align=None), offset=0), "Value": SimTypeBottom(label="PWSTR")}, name="WSDXML_ATTRIBUTE", pack=False, align=None), offset=0), "FirstChild": SimTypePointer(SimStruct({"Type": SimTypeInt(signed=True, label="Int32"), "Parent": SimTypePointer(SimTypeBottom(label="WSDXML_ELEMENT"), offset=0), "Next": SimTypePointer(SimTypeBottom(label="WSDXML_NODE"), offset=0)}, name="WSDXML_NODE", pack=False, align=None), offset=0), "PrefixMappings": SimTypePointer(SimStruct({"Refs": SimTypeInt(signed=False, label="UInt32"), "Next": SimTypePointer(SimTypeBottom(label="WSDXML_PREFIX_MAPPING"), offset=0), "Space": SimTypePointer(SimStruct({"Uri": SimTypeBottom(label="PWSTR"), "PreferredPrefix": SimTypeBottom(label="PWSTR"), "Names": SimTypePointer(SimTypeBottom(label="WSDXML_NAME"), offset=0), "NamesCount": SimTypeShort(signed=False, label="UInt16"), "Encoding": SimTypeShort(signed=False, label="UInt16")}, name="WSDXML_NAMESPACE", pack=False, align=None), offset=0), "Prefix": SimTypeBottom(label="PWSTR")}, name="WSDXML_PREFIX_MAPPING", pack=False, align=None), offset=0)}, name="WSDXML_ELEMENT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Node": SimStruct({"Type": SimTypeInt(signed=True, label="Int32"), "Parent": SimTypePointer(SimTypeBottom(label="WSDXML_ELEMENT"), offset=0), "Next": SimTypePointer(SimTypeBottom(label="WSDXML_NODE"), offset=0)}, name="WSDXML_NODE", pack=False, align=None), "Name": SimTypePointer(SimStruct({"Space": SimTypePointer(SimStruct({"Uri": SimTypeBottom(label="PWSTR"), "PreferredPrefix": SimTypeBottom(label="PWSTR"), "Names": SimTypePointer(SimTypeBottom(label="WSDXML_NAME"), offset=0), "NamesCount": SimTypeShort(signed=False, label="UInt16"), "Encoding": SimTypeShort(signed=False, label="UInt16")}, name="WSDXML_NAMESPACE", pack=False, align=None), offset=0), "LocalName": SimTypeBottom(label="PWSTR")}, name="WSDXML_NAME", pack=False, align=None), offset=0), "FirstAttribute": SimTypePointer(SimStruct({"Element": SimTypePointer(SimTypeBottom(label="WSDXML_ELEMENT"), offset=0), "Next": SimTypePointer(SimTypeBottom(label="WSDXML_ATTRIBUTE"), offset=0), "Name": SimTypePointer(SimStruct({"Space": SimTypePointer(SimStruct({"Uri": SimTypeBottom(label="PWSTR"), "PreferredPrefix": SimTypeBottom(label="PWSTR"), "Names": SimTypePointer(SimTypeBottom(label="WSDXML_NAME"), offset=0), "NamesCount": SimTypeShort(signed=False, label="UInt16"), "Encoding": SimTypeShort(signed=False, label="UInt16")}, name="WSDXML_NAMESPACE", pack=False, align=None), offset=0), "LocalName": SimTypeBottom(label="PWSTR")}, name="WSDXML_NAME", pack=False, align=None), offset=0), "Value": SimTypeBottom(label="PWSTR")}, name="WSDXML_ATTRIBUTE", pack=False, align=None), offset=0), "FirstChild": SimTypePointer(SimStruct({"Type": SimTypeInt(signed=True, label="Int32"), "Parent": SimTypePointer(SimTypeBottom(label="WSDXML_ELEMENT"), offset=0), "Next": SimTypePointer(SimTypeBottom(label="WSDXML_NODE"), offset=0)}, name="WSDXML_NODE", pack=False, align=None), offset=0), "PrefixMappings": SimTypePointer(SimStruct({"Refs": SimTypeInt(signed=False, label="UInt32"), "Next": SimTypePointer(SimTypeBottom(label="WSDXML_PREFIX_MAPPING"), offset=0), "Space": SimTypePointer(SimStruct({"Uri": SimTypeBottom(label="PWSTR"), "PreferredPrefix": SimTypeBottom(label="PWSTR"), "Names": SimTypePointer(SimTypeBottom(label="WSDXML_NAME"), offset=0), "NamesCount": SimTypeShort(signed=False, label="UInt16"), "Encoding": SimTypeShort(signed=False, label="UInt16")}, name="WSDXML_NAMESPACE", pack=False, align=None), offset=0), "Prefix": SimTypeBottom(label="PWSTR")}, name="WSDXML_PREFIX_MAPPING", pack=False, align=None), offset=0)}, name="WSDXML_ELEMENT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pParent", "pChild"]),
        #
        'WSDXMLCleanupElement': SimTypeFunction([SimTypePointer(SimStruct({"Node": SimStruct({"Type": SimTypeInt(signed=True, label="Int32"), "Parent": SimTypePointer(SimTypeBottom(label="WSDXML_ELEMENT"), offset=0), "Next": SimTypePointer(SimTypeBottom(label="WSDXML_NODE"), offset=0)}, name="WSDXML_NODE", pack=False, align=None), "Name": SimTypePointer(SimStruct({"Space": SimTypePointer(SimStruct({"Uri": SimTypeBottom(label="PWSTR"), "PreferredPrefix": SimTypeBottom(label="PWSTR"), "Names": SimTypePointer(SimTypeBottom(label="WSDXML_NAME"), offset=0), "NamesCount": SimTypeShort(signed=False, label="UInt16"), "Encoding": SimTypeShort(signed=False, label="UInt16")}, name="WSDXML_NAMESPACE", pack=False, align=None), offset=0), "LocalName": SimTypeBottom(label="PWSTR")}, name="WSDXML_NAME", pack=False, align=None), offset=0), "FirstAttribute": SimTypePointer(SimStruct({"Element": SimTypePointer(SimTypeBottom(label="WSDXML_ELEMENT"), offset=0), "Next": SimTypePointer(SimTypeBottom(label="WSDXML_ATTRIBUTE"), offset=0), "Name": SimTypePointer(SimStruct({"Space": SimTypePointer(SimStruct({"Uri": SimTypeBottom(label="PWSTR"), "PreferredPrefix": SimTypeBottom(label="PWSTR"), "Names": SimTypePointer(SimTypeBottom(label="WSDXML_NAME"), offset=0), "NamesCount": SimTypeShort(signed=False, label="UInt16"), "Encoding": SimTypeShort(signed=False, label="UInt16")}, name="WSDXML_NAMESPACE", pack=False, align=None), offset=0), "LocalName": SimTypeBottom(label="PWSTR")}, name="WSDXML_NAME", pack=False, align=None), offset=0), "Value": SimTypeBottom(label="PWSTR")}, name="WSDXML_ATTRIBUTE", pack=False, align=None), offset=0), "FirstChild": SimTypePointer(SimStruct({"Type": SimTypeInt(signed=True, label="Int32"), "Parent": SimTypePointer(SimTypeBottom(label="WSDXML_ELEMENT"), offset=0), "Next": SimTypePointer(SimTypeBottom(label="WSDXML_NODE"), offset=0)}, name="WSDXML_NODE", pack=False, align=None), offset=0), "PrefixMappings": SimTypePointer(SimStruct({"Refs": SimTypeInt(signed=False, label="UInt32"), "Next": SimTypePointer(SimTypeBottom(label="WSDXML_PREFIX_MAPPING"), offset=0), "Space": SimTypePointer(SimStruct({"Uri": SimTypeBottom(label="PWSTR"), "PreferredPrefix": SimTypeBottom(label="PWSTR"), "Names": SimTypePointer(SimTypeBottom(label="WSDXML_NAME"), offset=0), "NamesCount": SimTypeShort(signed=False, label="UInt16"), "Encoding": SimTypeShort(signed=False, label="UInt16")}, name="WSDXML_NAMESPACE", pack=False, align=None), offset=0), "Prefix": SimTypeBottom(label="PWSTR")}, name="WSDXML_PREFIX_MAPPING", pack=False, align=None), offset=0)}, name="WSDXML_ELEMENT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pAny"]),
        #
        'WSDGenerateFault': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeBottom(label="IWSDXMLContext"), SimTypePointer(SimTypePointer(SimStruct({"Code": SimTypePointer(SimStruct({"Value": SimTypePointer(SimTypeBottom(label="WSDXML_NAME"), offset=0), "Subcode": SimTypePointer(SimStruct({"Value": SimTypePointer(SimTypeBottom(label="WSDXML_NAME"), offset=0), "Subcode": SimTypePointer(SimTypeBottom(label="WSD_SOAP_FAULT_SUBCODE"), offset=0)}, name="WSD_SOAP_FAULT_SUBCODE", pack=False, align=None), offset=0)}, name="WSD_SOAP_FAULT_CODE", pack=False, align=None), offset=0), "Reason": SimTypePointer(SimStruct({"Text": SimTypePointer(SimStruct({"Next": SimTypePointer(SimTypeBottom(label="WSD_LOCALIZED_STRING_LIST"), offset=0), "Element": SimTypePointer(SimTypeBottom(label="WSD_LOCALIZED_STRING"), offset=0)}, name="WSD_LOCALIZED_STRING_LIST", pack=False, align=None), offset=0)}, name="WSD_SOAP_FAULT_REASON", pack=False, align=None), offset=0), "Node": SimTypeBottom(label="PWSTR"), "Role": SimTypeBottom(label="PWSTR"), "Detail": SimTypePointer(SimTypeBottom(label="WSDXML_ELEMENT"), offset=0)}, name="WSD_SOAP_FAULT", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszCode", "pszSubCode", "pszReason", "pszDetail", "pContext", "ppFault"]),
        #
        'WSDGenerateFaultEx': SimTypeFunction([SimTypePointer(SimStruct({"Space": SimTypePointer(SimStruct({"Uri": SimTypeBottom(label="PWSTR"), "PreferredPrefix": SimTypeBottom(label="PWSTR"), "Names": SimTypePointer(SimTypeBottom(label="WSDXML_NAME"), offset=0), "NamesCount": SimTypeShort(signed=False, label="UInt16"), "Encoding": SimTypeShort(signed=False, label="UInt16")}, name="WSDXML_NAMESPACE", pack=False, align=None), offset=0), "LocalName": SimTypeBottom(label="PWSTR")}, name="WSDXML_NAME", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Space": SimTypePointer(SimStruct({"Uri": SimTypeBottom(label="PWSTR"), "PreferredPrefix": SimTypeBottom(label="PWSTR"), "Names": SimTypePointer(SimTypeBottom(label="WSDXML_NAME"), offset=0), "NamesCount": SimTypeShort(signed=False, label="UInt16"), "Encoding": SimTypeShort(signed=False, label="UInt16")}, name="WSDXML_NAMESPACE", pack=False, align=None), offset=0), "LocalName": SimTypeBottom(label="PWSTR")}, name="WSDXML_NAME", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Next": SimTypePointer(SimTypeBottom(label="WSD_LOCALIZED_STRING_LIST"), offset=0), "Element": SimTypePointer(SimTypeBottom(label="WSD_LOCALIZED_STRING"), offset=0)}, name="WSD_LOCALIZED_STRING_LIST", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Code": SimTypePointer(SimStruct({"Value": SimTypePointer(SimTypeBottom(label="WSDXML_NAME"), offset=0), "Subcode": SimTypePointer(SimStruct({"Value": SimTypePointer(SimTypeBottom(label="WSDXML_NAME"), offset=0), "Subcode": SimTypePointer(SimTypeBottom(label="WSD_SOAP_FAULT_SUBCODE"), offset=0)}, name="WSD_SOAP_FAULT_SUBCODE", pack=False, align=None), offset=0)}, name="WSD_SOAP_FAULT_CODE", pack=False, align=None), offset=0), "Reason": SimTypePointer(SimStruct({"Text": SimTypePointer(SimStruct({"Next": SimTypePointer(SimTypeBottom(label="WSD_LOCALIZED_STRING_LIST"), offset=0), "Element": SimTypePointer(SimTypeBottom(label="WSD_LOCALIZED_STRING"), offset=0)}, name="WSD_LOCALIZED_STRING_LIST", pack=False, align=None), offset=0)}, name="WSD_SOAP_FAULT_REASON", pack=False, align=None), offset=0), "Node": SimTypeBottom(label="PWSTR"), "Role": SimTypeBottom(label="PWSTR"), "Detail": SimTypePointer(SimTypeBottom(label="WSDXML_ELEMENT"), offset=0)}, name="WSD_SOAP_FAULT", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCode", "pSubCode", "pReasons", "pszDetail", "ppFault"]),
        #
        'WSDUriEncode': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["source", "cchSource", "destOut", "cchDestOut"]),
        #
        'WSDUriDecode': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["source", "cchSource", "destOut", "cchDestOut"]),
        #
        'WSDCreateDeviceHost': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeBottom(label="IWSDXMLContext"), SimTypePointer(SimTypeBottom(label="IWSDDeviceHost"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszLocalId", "pContext", "ppDeviceHost"]),
        #
        'WSDCreateDeviceHostAdvanced': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeBottom(label="IWSDXMLContext"), SimTypePointer(SimTypeBottom(label="IWSDAddress"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="IWSDDeviceHost"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszLocalId", "pContext", "ppHostAddresses", "dwHostAddressCount", "ppDeviceHost"]),
        #
        'WSDCreateDeviceHost2': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeBottom(label="IWSDXMLContext"), SimTypePointer(SimStruct({"configParamType": SimTypeInt(signed=False, label="WSD_CONFIG_PARAM_TYPE"), "pConfigData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwConfigDataSize": SimTypeInt(signed=False, label="UInt32")}, name="WSD_CONFIG_PARAM", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="IWSDDeviceHost"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszLocalId", "pContext", "pConfigParams", "dwConfigParamCount", "ppDeviceHost"]),
        #
        'WSDCreateDeviceProxy': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeBottom(label="IWSDXMLContext"), SimTypePointer(SimTypeBottom(label="IWSDDeviceProxy"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszDeviceId", "pszLocalId", "pContext", "ppDeviceProxy"]),
        #
        'WSDCreateDeviceProxyAdvanced': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeBottom(label="IWSDAddress"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeBottom(label="IWSDXMLContext"), SimTypePointer(SimTypeBottom(label="IWSDDeviceProxy"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszDeviceId", "pDeviceAddress", "pszLocalId", "pContext", "ppDeviceProxy"]),
        #
        'WSDCreateDeviceProxy2': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeBottom(label="IWSDXMLContext"), SimTypePointer(SimStruct({"configParamType": SimTypeInt(signed=False, label="WSD_CONFIG_PARAM_TYPE"), "pConfigData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwConfigDataSize": SimTypeInt(signed=False, label="UInt32")}, name="WSD_CONFIG_PARAM", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="IWSDDeviceProxy"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszDeviceId", "pszLocalId", "pContext", "pConfigParams", "dwConfigParamCount", "ppDeviceProxy"]),
        #
        'WSDCreateDiscoveryProvider': SimTypeFunction([SimTypeBottom(label="IWSDXMLContext"), SimTypePointer(SimTypeBottom(label="IWSDiscoveryProvider"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pContext", "ppProvider"]),
        #
        'WSDCreateDiscoveryProvider2': SimTypeFunction([SimTypeBottom(label="IWSDXMLContext"), SimTypePointer(SimStruct({"configParamType": SimTypeInt(signed=False, label="WSD_CONFIG_PARAM_TYPE"), "pConfigData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwConfigDataSize": SimTypeInt(signed=False, label="UInt32")}, name="WSD_CONFIG_PARAM", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="IWSDiscoveryProvider"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pContext", "pConfigParams", "dwConfigParamCount", "ppProvider"]),
        #
        'WSDCreateDiscoveryPublisher': SimTypeFunction([SimTypeBottom(label="IWSDXMLContext"), SimTypePointer(SimTypeBottom(label="IWSDiscoveryPublisher"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pContext", "ppPublisher"]),
        #
        'WSDCreateDiscoveryPublisher2': SimTypeFunction([SimTypeBottom(label="IWSDXMLContext"), SimTypePointer(SimStruct({"configParamType": SimTypeInt(signed=False, label="WSD_CONFIG_PARAM_TYPE"), "pConfigData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwConfigDataSize": SimTypeInt(signed=False, label="UInt32")}, name="WSD_CONFIG_PARAM", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="IWSDiscoveryPublisher"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pContext", "pConfigParams", "dwConfigParamCount", "ppPublisher"]),
        #
        'WSDCreateOutboundAttachment': SimTypeFunction([SimTypePointer(SimTypeBottom(label="IWSDOutboundAttachment"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ppAttachment"]),
    }

lib.set_prototypes(prototypes)
