/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.TemporaryDirectoryKt;
import com.intellij.testFramework.common.RunAllKt;
import com.intellij.util.SmartList;
import com.intellij.util.io.Sanitize_nameKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0016\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\bH\u0004J\u0018\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0006H\u0007J\b\u0010\u001d\u001a\u00020\u0011H\u0002J\b\u0010\u001e\u001a\u00020\u0019H\u0014J\u001e\u0010\u001f\u001a\u00020\u00062\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010!\u001a\u00020\"H\u0007J \u0010#\u001a\u00020\u00112\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\bH\u0007J\u0014\u0010%\u001a\u00020\u00112\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\bH\u0007J\u0006\u0010'\u001a\u00020\u0006J\u0010\u0010(\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\u0006H\u0007J\u0012\u0010*\u001a\u00020\u00062\b\u0010+\u001a\u0004\u0018\u00010\bH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/testFramework/TemporaryDirectory;", "Lorg/junit/rules/ExternalResource;", "<init>", "()V", "paths", "Lcom/intellij/util/SmartList;", "Ljava/nio/file/Path;", "<set-?>", "", "sanitizedName", "getSanitizedName", "()Ljava/lang/String;", "setSanitizedName", "(Ljava/lang/String;)V", "sanitizedName$delegate", "Lkotlin/properties/ReadWriteProperty;", "virtualFileRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "root", "apply", "Lorg/junit/runners/model/Statement;", "base", "description", "Lorg/junit/runner/Description;", "before", "", "testName", "init", "commonPrefix", "getVirtualRoot", "after", "newPath", "fileName", "refreshVfs", "", "createVirtualFile", "data", "createVirtualDir", "dirName", "createDir", "scheduleDelete", "path", "generatePath", "suffix", "Companion", "intellij.platform.testFramework"})
@SourceDebugExtension(value={"SMAP\nTemporaryDirectory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TemporaryDirectory.kt\ncom/intellij/testFramework/TemporaryDirectory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,225:1\n1#2:226\n*E\n"})
public class TemporaryDirectory
extends ExternalResource {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final SmartList<Path> paths = new SmartList();
    @NotNull
    private final ReadWriteProperty sanitizedName$delegate = Delegates.INSTANCE.notNull();
    @Nullable
    private VirtualFile virtualFileRoot;
    @Nullable
    private Path root;

    private final String getSanitizedName() {
        return (String)this.sanitizedName$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setSanitizedName(String string) {
        this.sanitizedName$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)string);
    }

    @NotNull
    public Statement apply(@NotNull Statement base, @NotNull Description description) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        String string = description.getMethodName();
        if (string == null) {
            string = description.getClassName();
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        this.before(string2);
        Statement statement2 = super.apply(base, description);
        Intrinsics.checkNotNullExpressionValue((Object)statement2, (String)"apply(...)");
        return statement2;
    }

    protected final void before(@NotNull String testName) {
        Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
        this.setSanitizedName(Companion.testNameToFileName(testName));
        this.root = Paths.get(FileUtilRt.getTempDirectory(), new String[0]);
    }

    @ApiStatus.Internal
    public final void init(@NotNull String commonPrefix, @NotNull Path root) {
        Intrinsics.checkNotNullParameter((Object)commonPrefix, (String)"commonPrefix");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        if (this.root != null) {
            throw new IllegalStateException("Already initialized (root=" + this.root + ")");
        }
        this.setSanitizedName(commonPrefix);
        this.root = root;
    }

    private final VirtualFile getVirtualRoot() {
        VirtualFile result = this.virtualFileRoot;
        if (result == null) {
            Path path = this.root;
            Intrinsics.checkNotNull((Object)path);
            Path nioRoot = path;
            Files.createDirectories(nioRoot, new FileAttribute[0]);
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(nioRoot);
            if (virtualFile == null) {
                throw new IllegalStateException("Cannot find virtual file by " + nioRoot);
            }
            this.virtualFileRoot = result = virtualFile;
        }
        return result;
    }

    protected void after() {
        this.virtualFileRoot = null;
        this.root = null;
        if (this.paths.isEmpty()) {
            return;
        }
        Throwable error = RunAllKt.runAllCatching(CollectionsKt.asReversedMutable((List)((List)this.paths)), TemporaryDirectory::after$lambda$0);
        this.paths.clear();
        if (error != null) {
            Throwable it = error;
            boolean bl = false;
            throw it;
        }
    }

    @JvmOverloads
    @NotNull
    public final Path newPath(@Nullable String fileName, boolean refreshVfs) {
        Path path = this.generatePath(fileName);
        if (refreshVfs) {
            TemporaryDirectoryKt.refreshVfs(path);
        }
        return path;
    }

    public static /* synthetic */ Path newPath$default(TemporaryDirectory temporaryDirectory, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: newPath");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return temporaryDirectory.newPath(string, bl);
    }

    @JvmOverloads
    @NotNull
    public final VirtualFile createVirtualFile(@Nullable String fileName, @Nullable String data) {
        VirtualFile virtualFile = this.getVirtualRoot();
        String string = fileName;
        if (string == null) {
            string = "";
        }
        VirtualFile result = Companion.createVirtualFile(virtualFile, TemporaryDirectoryKt.access$generateName(string), data);
        this.paths.add((Object)result.toNioPath());
        return result;
    }

    public static /* synthetic */ VirtualFile createVirtualFile$default(TemporaryDirectory temporaryDirectory, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createVirtualFile");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return temporaryDirectory.createVirtualFile(string, string2);
    }

    @JvmOverloads
    @NotNull
    public final VirtualFile createVirtualDir(@Nullable String dirName) {
        VirtualFile virtualFileRoot = this.getVirtualRoot();
        Object object = WriteAction.computeAndWait(() -> TemporaryDirectory.createVirtualDir$lambda$2(dirName, virtualFileRoot, this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"computeAndWait(...)");
        return (VirtualFile)object;
    }

    public static /* synthetic */ VirtualFile createVirtualDir$default(TemporaryDirectory temporaryDirectory, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createVirtualDir");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        return temporaryDirectory.createVirtualDir(string);
    }

    @NotNull
    public final Path createDir() {
        Path file2 = TemporaryDirectory.newPath$default(this, null, false, 3, null);
        Files.createDirectories(file2, new FileAttribute[0]);
        return file2;
    }

    @Deprecated(message="Do not use, only for backward compatibility only.")
    public final void scheduleDelete(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.paths.add((Object)path);
    }

    private final Path generatePath(String suffix) {
        String fileName = this.getSanitizedName();
        if (suffix != null) {
            fileName = ((CharSequence)fileName).length() == 0 ? suffix : fileName + "_" + suffix;
        }
        Path path = this.root;
        if (path == null) {
            throw new IllegalStateException("not initialized yet");
        }
        Path path2 = Companion.generateTemporaryPath(fileName, path);
        this.paths.add((Object)path2);
        return path2;
    }

    @JvmOverloads
    @NotNull
    public final Path newPath(@Nullable String fileName) {
        return TemporaryDirectory.newPath$default(this, fileName, false, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final Path newPath() {
        return TemporaryDirectory.newPath$default(this, null, false, 3, null);
    }

    @JvmOverloads
    @NotNull
    public final VirtualFile createVirtualFile(@Nullable String fileName) {
        return TemporaryDirectory.createVirtualFile$default(this, fileName, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final VirtualFile createVirtualFile() {
        return TemporaryDirectory.createVirtualFile$default(this, null, null, 3, null);
    }

    @JvmOverloads
    @NotNull
    public final VirtualFile createVirtualDir() {
        return TemporaryDirectory.createVirtualDir$default(this, null, 1, null);
    }

    private static final Unit after$lambda$0(Path it) {
        NioFiles.deleteRecursively((Path)it);
        return Unit.INSTANCE;
    }

    private static final VirtualFile createVirtualDir$lambda$2(String $dirName, VirtualFile $virtualFileRoot, TemporaryDirectory this$0) {
        String string = $dirName;
        if (string == null) {
            string = "";
        }
        String name = TemporaryDirectoryKt.access$generateName(string);
        VirtualFile virtualFile = $virtualFileRoot.createChildDirectory(TemporaryDirectory.class, name);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"createChildDirectory(...)");
        VirtualFile result = virtualFile;
        this$0.paths.add((Object)result.toNioPath());
        return result;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Path generateTemporaryPath(@NotNull String fileName, @NotNull Path root) {
        return Companion.generateTemporaryPath(fileName, root);
    }

    @JvmStatic
    @NotNull
    public static final String testNameToFileName(@NotNull String name) {
        return Companion.testNameToFileName(name);
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final VirtualFile createVirtualFile(@NotNull VirtualFile parent, @NotNull String exactFileName, @Nullable String data) {
        return Companion.createVirtualFile(parent, exactFileName, data);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Path generateTemporaryPath(@NotNull String fileName) {
        return Companion.generateTemporaryPath(fileName);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(TemporaryDirectory.class, "sanitizedName", "getSanitizedName()Ljava/lang/String;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0005H\u0007J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0007J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007H\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/testFramework/TemporaryDirectory$Companion;", "", "<init>", "()V", "generateTemporaryPath", "Ljava/nio/file/Path;", "fileName", "", "root", "testNameToFileName", "name", "createVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "parent", "exactFileName", "data", "intellij.platform.testFramework"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Path generateTemporaryPath(@NotNull String fileName, @NotNull Path root) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Path path = root.resolve(TemporaryDirectoryKt.access$generateName(fileName));
            Intrinsics.checkNotNull((Object)path);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                throw new IllegalStateException("Path " + path + " must be unique but already exists");
            }
            return path;
        }

        public static /* synthetic */ Path generateTemporaryPath$default(Companion companion, String string, Path path, int n, Object object) {
            if ((n & 2) != 0) {
                path = Paths.get(FileUtilRt.getTempDirectory(), new String[0]);
            }
            return companion.generateTemporaryPath(string, path);
        }

        @JvmStatic
        @NotNull
        public final String testNameToFileName(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return Sanitize_nameKt.sanitizeFileName$default((String)((Object)StringsKt.trimStart((CharSequence)StringsKt.removePrefix((String)name, (CharSequence)"test"))).toString(), null, (boolean)false, Companion::testNameToFileName$lambda$0, (int)6, null);
        }

        @JvmStatic
        @ApiStatus.Internal
        @NotNull
        public final VirtualFile createVirtualFile(@NotNull VirtualFile parent, @NotNull String exactFileName, @Nullable String data) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)exactFileName, (String)"exactFileName");
            Object object = WriteAction.computeAndWait(() -> Companion.createVirtualFile$lambda$1(parent, exactFileName, data));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"computeAndWait(...)");
            return (VirtualFile)object;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Path generateTemporaryPath(@NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            return com.intellij.testFramework.TemporaryDirectory$Companion.generateTemporaryPath$default(this, fileName, null, 2, null);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final boolean testNameToFileName$lambda$0(Character it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            char c = ' ';
            if (it.charValue() == c) return true;
            c = '\'';
            if (it.charValue() != c) return false;
            return true;
        }

        private static final VirtualFile createVirtualFile$lambda$1(VirtualFile $parent, String $exactFileName, String $data) {
            VirtualFile virtualFile = $parent.createChildData(TemporaryDirectory.class, $exactFileName);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"createChildData(...)");
            VirtualFile result = virtualFile;
            CharSequence charSequence = $data;
            if (!(charSequence == null || charSequence.length() == 0)) {
                byte[] byArray = $data.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                result.setBinaryContent(byArray);
            }
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

