/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ%\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/vcsUtil/VcsUIUtil;", "", "<init>", "()V", "showPopupAbove", "", "popup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "component", "Ljava/awt/Component;", "minHeight", "", "(Lcom/intellij/openapi/ui/popup/JBPopup;Ljava/awt/Component;Ljava/lang/Integer;)V", "intellij.platform.vcs"})
public final class VcsUIUtil {
    @NotNull
    public static final VcsUIUtil INSTANCE = new VcsUIUtil();

    private VcsUIUtil() {
    }

    public final void showPopupAbove(@NotNull JBPopup popup, @NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)popup, (String)"popup");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.showPopupAbove(popup, component, null);
    }

    public final void showPopupAbove(@NotNull JBPopup popup, @NotNull Component component, @Nullable Integer minHeight) {
        Intrinsics.checkNotNullParameter((Object)popup, (String)"popup");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        RelativePoint northWest = new RelativePoint(component, new Point());
        popup.addListener(new JBPopupListener(northWest, popup, minHeight){
            final /* synthetic */ RelativePoint $northWest;
            final /* synthetic */ JBPopup $popup;
            final /* synthetic */ Integer $minHeight;
            {
                this.$northWest = $northWest;
                this.$popup = $popup;
                this.$minHeight = $minHeight;
            }

            public void beforeShown(LightweightWindowEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                int gap = JBUI.scale((int)4);
                int anchorY = this.$northWest.getScreenPoint().y;
                Point point = this.$popup.getLocationOnScreen();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocationOnScreen(...)");
                Point popupLocation = point;
                Dimension popupSize = this.$popup.getSize();
                popupLocation.y = anchorY - this.$popup.getSize().height;
                if (anchorY >= this.$popup.getSize().height + gap) {
                    popupLocation.y = anchorY - this.$popup.getSize().height;
                    this.$popup.setLocation(popupLocation);
                } else if (this.$minHeight != null && anchorY > this.$minHeight) {
                    popupLocation.y = gap;
                    popupSize.height = anchorY - gap;
                    this.$popup.setSize(popupLocation, popupSize);
                }
                this.$popup.removeListener((JBPopupListener)this);
            }
        });
        popup.show(northWest);
    }
}

