/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.util.core;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import org.editorconfig.language.psi.EditorConfigElementTypes;
import org.editorconfig.language.psi.EditorConfigHeader;
import org.editorconfig.language.psi.EditorConfigPsiFile;
import org.editorconfig.language.psi.EditorConfigSection;
import org.editorconfig.language.util.EditorConfigGlobUtilsKt;
import org.editorconfig.language.util.EditorConfigPsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0006J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ2\u0010\u000f\u001a\u0004\u0018\u0001H\u0010\"\b\b\u0000\u0010\u0010*\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u0001H\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0014H\u0086\u0010\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/editorconfig/language/util/core/EditorConfigPsiTreeUtilCore;", "", "<init>", "()V", "findMatchingSections", "", "Lorg/editorconfig/language/psi/EditorConfigSection;", "section", "findMatchingParentSections", "findMatchingChildSections", "findRemovableRangeBackward", "Lkotlin/ranges/IntRange;", "pattern", "Lcom/intellij/psi/PsiElement;", "findRemovableRangeForward", "getOriginalFile", "T", "Lcom/intellij/psi/PsiFile;", "file", "cls", "Lkotlin/reflect/KClass;", "(Lcom/intellij/psi/PsiFile;Lkotlin/reflect/KClass;)Lcom/intellij/psi/PsiFile;", "intellij.editorconfig"})
@SourceDebugExtension(value={"SMAP\nEditorConfigPsiTreeUtilCore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigPsiTreeUtilCore.kt\norg/editorconfig/language/util/core/EditorConfigPsiTreeUtilCore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1368#2:76\n1454#2,5:77\n774#2:82\n865#2,2:83\n1368#2:85\n1454#2,5:86\n774#2:91\n865#2,2:92\n*S KotlinDebug\n*F\n+ 1 EditorConfigPsiTreeUtilCore.kt\norg/editorconfig/language/util/core/EditorConfigPsiTreeUtilCore\n*L\n22#1:76\n22#1:77,5\n23#1:82\n23#1:83,2\n29#1:85\n29#1:86,5\n30#1:91\n30#1:92,2\n*E\n"})
public final class EditorConfigPsiTreeUtilCore {
    @NotNull
    public static final EditorConfigPsiTreeUtilCore INSTANCE = new EditorConfigPsiTreeUtilCore();

    private EditorConfigPsiTreeUtilCore() {
    }

    @NotNull
    public final List<EditorConfigSection> findMatchingSections(@NotNull EditorConfigSection section) {
        Intrinsics.checkNotNullParameter((Object)section, (String)"section");
        return CollectionsKt.plus((Collection)this.findMatchingParentSections(section), (Iterable)this.findMatchingChildSections(section));
    }

    /*
     * WARNING - void declaration
     */
    private final List<EditorConfigSection> findMatchingParentSections(EditorConfigSection section) {
        void $this$filterTo$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        PsiFile psiFile = section.getContainingFile();
        EditorConfigPsiFile editorConfigPsiFile = psiFile instanceof EditorConfigPsiFile ? (EditorConfigPsiFile)psiFile : null;
        if (editorConfigPsiFile == null) {
            return CollectionsKt.emptyList();
        }
        EditorConfigPsiFile psiFile2 = editorConfigPsiFile;
        Iterable $this$flatMap$iv = EditorConfigPsiTreeUtil.INSTANCE.findAllParentsFiles((PsiFile)psiFile2);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            EditorConfigPsiFile p0 = (EditorConfigPsiFile)((Object)element$iv$iv);
            boolean $i$f$findMatchingParentSections$stub_for_inlining = false;
            boolean bl = false;
            Iterable list$iv$iv = p0.getSections();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            EditorConfigSection it = (EditorConfigSection)element$iv$iv;
            boolean bl = false;
            EditorConfigHeader editorConfigHeader = section.getHeader();
            Intrinsics.checkNotNullExpressionValue((Object)editorConfigHeader, (String)"getHeader(...)");
            EditorConfigHeader editorConfigHeader2 = it.getHeader();
            Intrinsics.checkNotNullExpressionValue((Object)editorConfigHeader2, (String)"getHeader(...)");
            if (!EditorConfigGlobUtilsKt.isSubcaseOf(editorConfigHeader, editorConfigHeader2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<EditorConfigSection> findMatchingChildSections(EditorConfigSection section) {
        void $this$filterTo$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        PsiFile psiFile = section.getContainingFile();
        EditorConfigPsiFile editorConfigPsiFile = psiFile instanceof EditorConfigPsiFile ? (EditorConfigPsiFile)psiFile : null;
        if (editorConfigPsiFile == null) {
            return CollectionsKt.emptyList();
        }
        EditorConfigPsiFile psiFile2 = editorConfigPsiFile;
        Iterable $this$flatMap$iv = EditorConfigPsiTreeUtil.findAllChildrenFiles$default(EditorConfigPsiTreeUtil.INSTANCE, psiFile2, false, 2, null);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            EditorConfigPsiFile p0 = (EditorConfigPsiFile)((Object)element$iv$iv);
            boolean $i$f$findMatchingChildSections$stub_for_inlining$1 = false;
            boolean bl = false;
            Iterable list$iv$iv = p0.getSections();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            EditorConfigSection it = (EditorConfigSection)element$iv$iv;
            boolean bl = false;
            EditorConfigHeader editorConfigHeader = it.getHeader();
            Intrinsics.checkNotNullExpressionValue((Object)editorConfigHeader, (String)"getHeader(...)");
            EditorConfigHeader editorConfigHeader2 = section.getHeader();
            Intrinsics.checkNotNullExpressionValue((Object)editorConfigHeader2, (String)"getHeader(...)");
            if (!EditorConfigGlobUtilsKt.isSubcaseOf(editorConfigHeader, editorConfigHeader2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final IntRange findRemovableRangeBackward(@NotNull PsiElement pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        PsiElement psiElement = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)pattern);
        if (psiElement == null) {
            return null;
        }
        PsiElement prevElement = psiElement;
        if (!Intrinsics.areEqual((Object)prevElement.getNode().getElementType(), (Object)EditorConfigElementTypes.COMMA)) {
            return null;
        }
        PsiElement prevPrevElement = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)prevElement);
        if (prevPrevElement == null) {
            int start = prevElement.getTextRange().getStartOffset();
            int end = pattern.getTextRange().getEndOffset();
            return RangesKt.until((int)start, (int)end);
        }
        int start = prevPrevElement.getTextRange().getEndOffset();
        int end = pattern.getTextRange().getEndOffset();
        return RangesKt.until((int)start, (int)end);
    }

    @Nullable
    public final IntRange findRemovableRangeForward(@NotNull PsiElement pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        PsiElement psiElement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)pattern);
        if (psiElement == null) {
            return null;
        }
        PsiElement nextElement = psiElement;
        ASTNode aSTNode = nextElement.getNode();
        if (!Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)EditorConfigElementTypes.COMMA)) {
            return null;
        }
        PsiElement nextNextElement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)nextElement);
        if (nextNextElement == null) {
            int start = pattern.getTextRange().getStartOffset();
            int end = nextElement.getTextRange().getEndOffset();
            return RangesKt.until((int)start, (int)end);
        }
        int start = pattern.getTextRange().getStartOffset();
        int end = nextNextElement.getTextRange().getStartOffset();
        return RangesKt.until((int)start, (int)end);
    }

    @Nullable
    public final <T extends PsiFile> T getOriginalFile(@Nullable T file, @NotNull KClass<T> cls) {
        Intrinsics.checkNotNullParameter(cls, (String)"cls");
        EditorConfigPsiTreeUtilCore editorConfigPsiTreeUtilCore = this;
        while (true) {
            T t = file;
            PsiFile originalFile = (PsiFile)KClasses.safeCast(cls, (Object)(t != null ? t.getOriginalFile() : null));
            if (Intrinsics.areEqual(file, (Object)originalFile)) {
                return file;
            }
            EditorConfigPsiTreeUtilCore editorConfigPsiTreeUtilCore2 = editorConfigPsiTreeUtilCore;
            KClass<T> kClass = cls;
            editorConfigPsiTreeUtilCore = editorConfigPsiTreeUtilCore2;
            file = originalFile;
            cls = kClass;
        }
    }
}

