/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.model;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtilRt;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.meta.model.CompletionContext;
import org.jetbrains.yaml.meta.model.YamlScalarType;
import org.jetbrains.yaml.psi.YAMLScalar;

@ApiStatus.Internal
public class YamlEnumType
extends YamlScalarType {
    private String[] myLiterals;
    private String[] myHiddenLiterals;
    private String[] myDeprecatedLiterals;

    public YamlEnumType(@NotNull String typeName) {
        if (typeName == null) {
            YamlEnumType.$$$reportNull$$$0(0);
        }
        super(typeName);
        this.myLiterals = ArrayUtilRt.EMPTY_STRING_ARRAY;
        this.myHiddenLiterals = ArrayUtilRt.EMPTY_STRING_ARRAY;
        this.myDeprecatedLiterals = ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public YamlEnumType(@NotNull String typeName, @NotNull String displayName) {
        if (typeName == null) {
            YamlEnumType.$$$reportNull$$$0(1);
        }
        if (displayName == null) {
            YamlEnumType.$$$reportNull$$$0(2);
        }
        super(typeName, displayName);
        this.myLiterals = ArrayUtilRt.EMPTY_STRING_ARRAY;
        this.myHiddenLiterals = ArrayUtilRt.EMPTY_STRING_ARRAY;
        this.myDeprecatedLiterals = ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    @NotNull
    public YamlEnumType withLiterals(String ... literals) {
        this.myLiterals = YamlEnumType.cloneArray(literals);
        YamlEnumType yamlEnumType = this;
        if (yamlEnumType == null) {
            YamlEnumType.$$$reportNull$$$0(3);
        }
        return yamlEnumType;
    }

    @NotNull
    public YamlEnumType withHiddenLiterals(String ... hiddenLiterals) {
        this.myHiddenLiterals = (String[])hiddenLiterals.clone();
        YamlEnumType yamlEnumType = this;
        if (yamlEnumType == null) {
            YamlEnumType.$$$reportNull$$$0(4);
        }
        return yamlEnumType;
    }

    @NotNull
    public YamlEnumType withDeprecatedLiterals(String ... deprecatedLiterals) {
        this.myDeprecatedLiterals = (String[])deprecatedLiterals.clone();
        YamlEnumType yamlEnumType = this;
        if (yamlEnumType == null) {
            YamlEnumType.$$$reportNull$$$0(5);
        }
        return yamlEnumType;
    }

    @NotNull
    protected final Stream<String> getLiteralsStream() {
        Stream<String> stream = Stream.concat(Arrays.stream(this.myLiterals), Arrays.stream(this.myDeprecatedLiterals));
        if (stream == null) {
            YamlEnumType.$$$reportNull$$$0(6);
        }
        return stream;
    }

    @Override
    protected void validateScalarValue(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
        if (scalarValue == null) {
            YamlEnumType.$$$reportNull$$$0(7);
        }
        if (holder == null) {
            YamlEnumType.$$$reportNull$$$0(8);
        }
        super.validateScalarValue(scalarValue, holder);
        String text = scalarValue.getTextValue();
        if (text.isEmpty()) {
            return;
        }
        if (Arrays.asList(this.myDeprecatedLiterals).contains(text)) {
            holder.registerProblem((PsiElement)scalarValue, YAMLBundle.message((String)"YamlEnumType.validation.warning.value.deprecated", (Object[])new Object[]{text}), ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
        } else if (Stream.concat(Arrays.stream(this.myHiddenLiterals), this.getLiteralsStream()).noneMatch(text::equals)) {
            holder.registerProblem((PsiElement)scalarValue, YAMLBundle.message((String)"YamlEnumType.validation.error.value.unknown", (Object[])new Object[]{text}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    @NotNull
    public List<LookupElement> getValueLookups(@NotNull YAMLScalar insertedScalar, @Nullable CompletionContext completionContext) {
        if (insertedScalar == null) {
            YamlEnumType.$$$reportNull$$$0(9);
        }
        List<LookupElement> list = Stream.concat(Arrays.stream(this.myLiterals).map(literal -> this.createValueLookup((String)literal, false)), Arrays.stream(this.myDeprecatedLiterals).map(literal -> this.createValueLookup((String)literal, true))).filter(Objects::nonNull).collect(Collectors.toList());
        if (list == null) {
            YamlEnumType.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Nullable
    protected LookupElement createValueLookup(@NotNull String literal, boolean deprecated) {
        if (literal == null) {
            YamlEnumType.$$$reportNull$$$0(11);
        }
        return LookupElementBuilder.create((String)literal).withStrikeoutness(deprecated);
    }

    private static String @NotNull [] cloneArray(String @NotNull [] array) {
        if (array == null) {
            YamlEnumType.$$$reportNull$$$0(12);
        }
        String[] stringArray = array.length == 0 ? ArrayUtilRt.EMPTY_STRING_ARRAY : (String[])array.clone();
        if (stringArray == null) {
            YamlEnumType.$$$reportNull$$$0(13);
        }
        return stringArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 10, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/meta/model/YamlEnumType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scalarValue";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertedScalar";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/meta/model/YamlEnumType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "withLiterals";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withHiddenLiterals";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withDeprecatedLiterals";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteralsStream";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueLookups";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 13: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "validateScalarValue";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getValueLookups";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createValueLookup";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "cloneArray";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 10, 13 -> new IllegalStateException(string);
        };
    }
}

