/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing.pytest;

import com.intellij.openapi.util.Pair;
import org.jetbrains.annotations.NotNull;

final class PyFilesStateMachine {
    private final boolean myQuoteMode;
    private boolean myLookingForFile = true;
    private boolean myInProgress;
    private boolean myWaitingForCharAfterSemicolon;
    private int myStart;
    private final StringBuilder myFileName = new StringBuilder();
    private final StringBuilder myLineNumber = new StringBuilder();

    PyFilesStateMachine(boolean quoteMode) {
        this.myQuoteMode = quoteMode;
        if (!this.myQuoteMode) {
            this.myInProgress = true;
        }
    }

    boolean addChar(char charToCheck, int charNumber) {
        if (!this.myInProgress) {
            if (charToCheck == '\"' && this.myQuoteMode) {
                this.myInProgress = true;
                this.myStart = charNumber;
            }
            return false;
        }
        if (this.myWaitingForCharAfterSemicolon) {
            if (charToCheck == '/' || charToCheck == '\\') {
                this.myFileName.append(':');
                this.myFileName.append(charToCheck);
                this.myWaitingForCharAfterSemicolon = false;
                return false;
            }
            if (Character.isDigit(charToCheck)) {
                this.myLookingForFile = false;
                this.myLineNumber.append(charToCheck);
                this.myWaitingForCharAfterSemicolon = false;
                return false;
            }
            this.resetState();
            return false;
        }
        if (charToCheck == '\"') {
            if (this.myQuoteMode && this.myFileName.length() > 0 && this.myLineNumber.length() > 0) {
                return true;
            }
            this.resetState();
            if (this.myQuoteMode) {
                this.myInProgress = true;
                this.myStart = charNumber;
            }
            return false;
        }
        if (charToCheck == ' ') {
            if (this.myQuoteMode && this.myLookingForFile) {
                this.myFileName.append(' ');
                return false;
            }
            if (!this.myQuoteMode && this.myFileName.length() > 0 && this.myLineNumber.length() > 0) {
                return true;
            }
            this.resetState();
            if (!this.myQuoteMode) {
                this.myInProgress = true;
                this.myStart = charNumber + 1;
            }
            return false;
        }
        if ((Character.isLetter(charToCheck) || charToCheck == '/' || charToCheck == '\\' || charToCheck == '.' || charToCheck == '_' || charToCheck == '-') && this.myLookingForFile) {
            this.myFileName.append(charToCheck);
            return false;
        }
        if (charToCheck == ':' && this.myLookingForFile) {
            this.myWaitingForCharAfterSemicolon = true;
            return false;
        }
        if (Character.isDigit(charToCheck)) {
            if (!this.myLookingForFile) {
                this.myLineNumber.append(charToCheck);
                return false;
            }
            if (this.myFileName.length() == 0) {
                this.resetState();
                return false;
            }
            this.myFileName.append(charToCheck);
            return false;
        }
        if (this.myFileName.length() > 0 && this.myLineNumber.length() > 0) {
            return true;
        }
        this.resetState();
        return false;
    }

    private void resetState() {
        this.myInProgress = false;
        this.myLookingForFile = true;
        this.myLineNumber.setLength(0);
        this.myFileName.setLength(0);
    }

    @NotNull
    Pair<String, String> getFileAndLine() {
        Pair pair = Pair.create((Object)this.myFileName.toString(), (Object)this.myLineNumber.toString());
        if (pair == null) {
            PyFilesStateMachine.$$$reportNull$$$0(0);
        }
        return pair;
    }

    int getStart() {
        return this.myStart;
    }

    boolean endLine() {
        if (this.myQuoteMode) {
            return false;
        }
        return this.myFileName.length() > 0 && this.myLineNumber.length() > 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/testing/pytest/PyFilesStateMachine", "getFileAndLine"));
    }
}

