/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.vcs.changes.savedPatches.SavedPatchesProvider;
import com.intellij.openapi.vcs.changes.savedPatches.SavedPatchesUi;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.index.GitStageContentProviderKt;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.stash.GitStashTracker;
import git4idea.stash.GitStashTrackerKt;
import git4idea.stash.ui.GitStashProvider;
import git4idea.stash.ui.GitStashSettingsListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0000\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0000\u001a\u001c\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0001\u001a\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a8\u0006\u000f"}, d2={"stashToolWindowRegistryOption", "Lcom/intellij/openapi/util/registry/RegistryValue;", "isStashTabAvailable", "", "isStashTabVisible", "project", "Lcom/intellij/openapi/project/Project;", "isStashesAndShelvesTabEnabled", "setStashesAndShelvesTabEnabled", "", "enabled", "showStashes", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "isStashTabVertical", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitStashContentProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitStashContentProvider.kt\ngit4idea/stash/ui/GitStashContentProviderKt\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,217:1\n31#2,2:218\n1#3:220\n808#4,11:221\n*S KotlinDebug\n*F\n+ 1 GitStashContentProvider.kt\ngit4idea/stash/ui/GitStashContentProviderKt\n*L\n185#1:218,2\n206#1:221,11\n*E\n"})
public final class GitStashContentProviderKt {
    @NotNull
    public static final RegistryValue stashToolWindowRegistryOption() {
        return Registry.Companion.get("git.enable.stash.toolwindow");
    }

    public static final boolean isStashTabAvailable() {
        return GitStashContentProviderKt.stashToolWindowRegistryOption().asBoolean();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isStashTabVisible(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!GitStashContentProviderKt.isStashTabAvailable()) {
            return false;
        }
        if (GitStashContentProviderKt.isStashesAndShelvesTabEnabled(project)) return true;
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<GitStashTracker> serviceClass$iv = GitStashTracker.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        if (!GitStashTrackerKt.isNotEmpty((GitStashTracker)object)) return false;
        return true;
    }

    public static final boolean isStashesAndShelvesTabEnabled(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ShelvedChangesViewManager.hideDefaultShelfTab((Project)project);
    }

    public static final void setStashesAndShelvesTabEnabled(boolean enabled) {
        GitVcsApplicationSettings applicationSettings = GitVcsApplicationSettings.getInstance();
        if (enabled == applicationSettings.isCombinedStashesAndShelvesTabEnabled()) {
            return;
        }
        applicationSettings.setCombinedStashesAndShelvesTabEnabled(enabled);
        ((GitStashSettingsListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(GitStashSettingsListener.Companion.getTOPIC())).onCombineStashAndShelveSettingChanged();
    }

    @JvmOverloads
    public static final void showStashes(@NotNull Project project, @Nullable VirtualFile root) {
        GitRepository gitRepository;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile virtualFile = root;
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            gitRepository = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForRootQuick(root);
        } else {
            gitRepository = null;
        }
        GitRepository repository = gitRepository;
        GitStageContentProviderKt.showToolWindowTab(project, "Stash", (Function1<? super JComponent, Unit>)((Function1)arg_0 -> GitStashContentProviderKt.showStashes$lambda$1(repository, arg_0)));
    }

    public static /* synthetic */ void showStashes$default(Project project, VirtualFile virtualFile, int n, Object object) {
        if ((n & 2) != 0) {
            virtualFile = null;
        }
        GitStashContentProviderKt.showStashes(project, virtualFile);
    }

    public static final boolean isStashTabVertical(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ChangesViewContentManager.Companion.isToolWindowTabVertical(project, "Stash");
    }

    @JvmOverloads
    public static final void showStashes(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GitStashContentProviderKt.showStashes$default(project, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit showStashes$lambda$1(GitRepository $repository, JComponent component2) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        SavedPatchesUi savedPatchesUi = component2 instanceof SavedPatchesUi ? (SavedPatchesUi)component2 : null;
        if (savedPatchesUi == null) {
            return Unit.INSTANCE;
        }
        SavedPatchesUi savedPatchesUi2 = savedPatchesUi;
        Iterable $this$filterIsInstance$iv = savedPatchesUi2.getProviders();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GitStashProvider)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        GitStashProvider gitStashProvider = (GitStashProvider)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        if (gitStashProvider == null) {
            return Unit.INSTANCE;
        }
        GitStashProvider provider = gitStashProvider;
        if ($repository == null) {
            savedPatchesUi2.showFirstUnderProvider((SavedPatchesProvider)provider);
        } else {
            savedPatchesUi2.showFirstUnderObject((SavedPatchesProvider)provider, (Object)$repository);
        }
        return Unit.INSTANCE;
    }
}

