/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.config.OpenSSHClientConfig;
import com.intellij.ssh.config.OpenSSHConfig;
import com.intellij.util.SmartList;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Deprecated(message="Replaced with SshConnectionConfigService")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u0004\u0018\u00010\bJ\b\u0010\f\u001a\u00020\rH\u0002J\u0015\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fH\u0002\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0012\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fH\u0002\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0013\u001a\u00020\bH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u000fH\u0002R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ssh/config/OpenSSHConfigService;", "", "<init>", "()V", "lastTimeLoadedNanos", "", "Ljava/lang/Long;", "config", "Lcom/intellij/ssh/config/OpenSSHClientConfig;", "lock", "Ljava/lang/Object;", "getConfig", "isReloadRequired", "", "getUnixSystemConfigPath", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "()Ljava/nio/file/Path;", "getUserConfigPath", "loadConfig", "tryParse", "Lcom/intellij/ssh/config/OpenSSHConfig;", "path", "Companion", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nOpenSSHConfigService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenSSHConfigService.kt\ncom/intellij/ssh/config/OpenSSHConfigService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 util.kt\ncom/intellij/util/containers/UtilKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1#2:84\n1#2:88\n285#3,3:85\n290#3:89\n1619#4:90\n1863#4,2:91\n1620#4:93\n*S KotlinDebug\n*F\n+ 1 OpenSSHConfigService.kt\ncom/intellij/ssh/config/OpenSSHConfigService\n*L\n58#1:88\n58#1:85,3\n58#1:89\n58#1:90\n58#1:91,2\n58#1:93\n*E\n"})
public final class OpenSSHConfigService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Long lastTimeLoadedNanos;
    @Nullable
    private OpenSSHClientConfig config;
    @NotNull
    private Object lock = new Object();
    @NotNull
    private static final Logger LOG;
    private static final long CACHE_PERIOD_NANOS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final OpenSSHClientConfig getConfig() {
        OpenSSHClientConfig result = null;
        if (Registry.Companion.is("ssh.use.openssh.config")) {
            Object object = this.lock;
            synchronized (object) {
                boolean bl = false;
                result = this.config;
                if (this.isReloadRequired()) {
                    this.config = result = this.loadConfig();
                    this.lastTimeLoadedNanos = System.nanoTime();
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        return result;
    }

    private final boolean isReloadRequired() {
        Long it = this.lastTimeLoadedNanos;
        boolean bl = false;
        return it == null || System.nanoTime() - it > CACHE_PERIOD_NANOS;
    }

    private final Path getUnixSystemConfigPath() {
        return Paths.get("/etc/ssh/ssh_config", new String[0]);
    }

    private final Path getUserConfigPath() {
        return Ssh.getHomeSshDirectory().resolve("config");
    }

    /*
     * WARNING - void declaration
     */
    private final OpenSSHClientConfig loadConfig() {
        Object object;
        ArrayList<Path> paths = new ArrayList<Path>();
        paths.add(this.getUserConfigPath());
        if (SystemInfo.isUnix) {
            paths.add(this.getUnixSystemConfigPath());
        }
        Collection $this$mapSmartNotNull$iv = paths;
        boolean $i$f$mapSmartNotNull = false;
        int size$iv = $this$mapSmartNotNull$iv.size();
        if (size$iv == 1) {
            Path it = (Path)CollectionsKt.first((Iterable)$this$mapSmartNotNull$iv);
            boolean bl = false;
            OpenSSHConfig openSSHConfig = this.tryParse(it);
            if (openSSHConfig != null) {
                OpenSSHConfig it$iv = openSSHConfig;
                boolean bl2 = false;
                object = new SmartList((Object)it$iv);
            } else {
                object = new SmartList();
            }
        } else {
            void $this$mapNotNullTo$iv$iv;
            Iterable iterable = $this$mapSmartNotNull$iv;
            Collection destination$iv$iv = new ArrayList(size$iv);
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                OpenSSHConfig it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Path it = (Path)element$iv$iv;
                boolean bl3 = false;
                if (this.tryParse(it) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            object = destination$iv$iv;
        }
        List list = (List)object;
        return new OpenSSHClientConfig(list);
    }

    private final OpenSSHConfig tryParse(Path path) {
        OpenSSHConfig openSSHConfig;
        try {
            openSSHConfig = OpenSSHConfig.parseFile(((Object)path).toString());
        }
        catch (IOException e) {
            LOG.debug("Failed to parse OpenSSH configuration file: " + path, (Throwable)e);
            openSSHConfig = null;
        }
        return openSSHConfig;
    }

    @NotNull
    public static final OpenSSHConfigService getInstance() {
        return Companion.getInstance();
    }

    static {
        Logger logger = Logger.getInstance(OpenSSHConfigService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        CACHE_PERIOD_NANOS = TimeUnit.SECONDS.toNanos(10L);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u00058FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ssh/config/OpenSSHConfigService$Companion;", "", "<init>", "()V", "instance", "Lcom/intellij/ssh/config/OpenSSHConfigService;", "getInstance$annotations", "getInstance", "()Lcom/intellij/ssh/config/OpenSSHConfigService;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "CACHE_PERIOD_NANOS", "", "intellij.platform.ssh"})
    @SourceDebugExtension(value={"SMAP\nOpenSSHConfigService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenSSHConfigService.kt\ncom/intellij/ssh/config/OpenSSHConfigService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,83:1\n40#2,3:84\n*S KotlinDebug\n*F\n+ 1 OpenSSHConfigService.kt\ncom/intellij/ssh/config/OpenSSHConfigService$Companion\n*L\n74#1:84,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OpenSSHConfigService getInstance() {
            boolean $i$f$service = false;
            Class<OpenSSHConfigService> serviceClass$iv = OpenSSHConfigService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (OpenSSHConfigService)object;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

