/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.authentication.ui;

import com.intellij.codeWithMe.ClientId;
import com.intellij.collaboration.auth.ui.login.LoginException;
import com.intellij.collaboration.auth.ui.login.LoginPanelModelBase;
import com.intellij.collaboration.auth.ui.login.LoginTokenGenerator;
import com.intellij.collaboration.util.URIUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManagerEx;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.GitLabServersManager;
import org.jetbrains.plugins.gitlab.api.GitLabApi;
import org.jetbrains.plugins.gitlab.api.GitLabApiKt;
import org.jetbrains.plugins.gitlab.api.GitLabApiManager;
import org.jetbrains.plugins.gitlab.api.GitLabServerMetadata;
import org.jetbrains.plugins.gitlab.api.GitLabServerPath;
import org.jetbrains.plugins.gitlab.api.GitLabVersion;
import org.jetbrains.plugins.gitlab.api.dto.GitLabUserDetailedDTO;
import org.jetbrains.plugins.gitlab.api.request.GitLabUsersApiKt;
import org.jetbrains.plugins.gitlab.authentication.GitLabSecurityUtil;
import org.jetbrains.plugins.gitlab.authentication.ui.GitLabTokenLoginPanelModel;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u001a\u001a\u00020\u0004H\u0096@\u00a2\u0006\u0002\u0010\u001bJ\u0006\u0010\u001c\u001a\u00020\u0007J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u0004H\u0016J\u0010\u0010!\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u0004H\u0016J\u000e\u0010\"\u001a\u00020\u0015H\u0086@\u00a2\u0006\u0002\u0010\u001bR\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR,\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006#"}, d2={"Lorg/jetbrains/plugins/gitlab/authentication/ui/GitLabTokenLoginPanelModel;", "Lcom/intellij/collaboration/auth/ui/login/LoginPanelModelBase;", "Lcom/intellij/collaboration/auth/ui/login/LoginTokenGenerator;", "requiredUsername", "", "uniqueAccountPredicate", "Lkotlin/Function2;", "Lorg/jetbrains/plugins/gitlab/api/GitLabServerPath;", "", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function2;)V", "getRequiredUsername", "()Ljava/lang/String;", "setRequiredUsername", "(Ljava/lang/String;)V", "getUniqueAccountPredicate", "()Lkotlin/jvm/functions/Function2;", "setUniqueAccountPredicate", "(Lkotlin/jvm/functions/Function2;)V", "_tryGitAuthorizationSignal", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "tryGitAuthorizationSignal", "Lkotlinx/coroutines/flow/Flow;", "getTryGitAuthorizationSignal", "()Lkotlinx/coroutines/flow/Flow;", "checkToken", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getServerPath", "createServerPath", "uri", "canGenerateToken", "serverUri", "generateToken", "tryGitAuthorization", "intellij.vcs.gitlab"})
@SourceDebugExtension(value={"SMAP\nGitLabTokenLoginPanelModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabTokenLoginPanelModel.kt\norg/jetbrains/plugins/gitlab/authentication/ui/GitLabTokenLoginPanelModel\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,78:1\n40#2,3:79\n78#3:82\n*S KotlinDebug\n*F\n+ 1 GitLabTokenLoginPanelModel.kt\norg/jetbrains/plugins/gitlab/authentication/ui/GitLabTokenLoginPanelModel\n*L\n32#1:79,3\n34#1:82\n*E\n"})
public final class GitLabTokenLoginPanelModel
extends LoginPanelModelBase
implements LoginTokenGenerator {
    @Nullable
    private String requiredUsername;
    @NotNull
    private Function2<? super GitLabServerPath, ? super String, Boolean> uniqueAccountPredicate;
    @NotNull
    private final MutableSharedFlow<Unit> _tryGitAuthorizationSignal;
    @NotNull
    private final Flow<Unit> tryGitAuthorizationSignal;

    public GitLabTokenLoginPanelModel(@Nullable String requiredUsername, @NotNull Function2<? super GitLabServerPath, ? super String, Boolean> uniqueAccountPredicate) {
        Intrinsics.checkNotNullParameter(uniqueAccountPredicate, (String)"uniqueAccountPredicate");
        this.requiredUsername = requiredUsername;
        this.uniqueAccountPredicate = uniqueAccountPredicate;
        this._tryGitAuthorizationSignal = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, null, (int)6, null);
        this.tryGitAuthorizationSignal = (Flow)FlowKt.asSharedFlow(this._tryGitAuthorizationSignal);
    }

    public /* synthetic */ GitLabTokenLoginPanelModel(String string, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string, (Function2<? super GitLabServerPath, ? super String, Boolean>)function2);
    }

    @Nullable
    public final String getRequiredUsername() {
        return this.requiredUsername;
    }

    public final void setRequiredUsername(@Nullable String string) {
        this.requiredUsername = string;
    }

    @NotNull
    public final Function2<GitLabServerPath, String, Boolean> getUniqueAccountPredicate() {
        return this.uniqueAccountPredicate;
    }

    public final void setUniqueAccountPredicate(@NotNull Function2<? super GitLabServerPath, ? super String, Boolean> function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
        this.uniqueAccountPredicate = function2;
    }

    @NotNull
    public final Flow<Unit> getTryGitAuthorizationSignal() {
        return this.tryGitAuthorizationSignal;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object checkToken(@NotNull Continuation<? super String> $completion) {
        if (!($completion instanceof checkToken.1)) ** GOTO lbl-1000
        var10_2 = $completion;
        if ((var10_2.label & -2147483648) != 0) {
            var10_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ GitLabTokenLoginPanelModel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.checkToken((Continuation<? super String>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                server = this.createServerPath(this.getServerUri());
                $i$f$service = false;
                serviceClass$iv = GitLabApiManager.class;
                v0 = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (v0 == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                api = ((GitLabApiManager)v0).getClient(server, this.getToken());
                $continuation.L$0 = this;
                $continuation.L$1 = server;
                $continuation.L$2 = api;
                $continuation.label = 1;
                v1 = GitLabApiKt.getMetadataOrNull(api, (Continuation<? super GitLabServerMetadata>)$continuation);
                if (v1 == var11_4) {
                    return var11_4;
                }
                ** GOTO lbl33
            }
            case 1: {
                api = (GitLabApi)$continuation.L$2;
                server = (GitLabServerPath)$continuation.L$1;
                this = (GitLabTokenLoginPanelModel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl33:
                // 2 sources

                v2 = (GitLabServerMetadata)v1;
                version = v2 != null ? v2.getVersion() : null;
                $i$f$serviceAsync = false;
                v3 = ApplicationManager.getApplication();
                Intrinsics.checkNotNull((Object)v3, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
                $continuation.L$0 = this;
                $continuation.L$1 = server;
                $continuation.L$2 = api;
                $continuation.L$3 = version;
                $continuation.label = 2;
                v4 = ((ComponentManagerEx)v3).getServiceAsync(GitLabServersManager.class, (Continuation)$continuation);
                if (v4 == var11_4) {
                    return var11_4;
                }
                ** GOTO lbl56
            }
            case 2: {
                $i$f$serviceAsync = false;
                version = (GitLabVersion)$continuation.L$3;
                api = (GitLabApi)$continuation.L$2;
                server = (GitLabServerPath)$continuation.L$1;
                this = (GitLabTokenLoginPanelModel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl56:
                // 2 sources

                earliestSupportedVersion = ((GitLabServersManager)v4).getEarliestSupportedVersion();
                if (version == null) {
                    throw new LoginException.InvalidTokenOrUnsupportedServerVersion(earliestSupportedVersion.toString());
                }
                if (version.compareTo(earliestSupportedVersion) < 0) {
                    throw new LoginException.UnsupportedServerVersion(earliestSupportedVersion.toString());
                }
                $continuation.L$0 = this;
                $continuation.L$1 = server;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.label = 3;
                v5 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super GitLabUserDetailedDTO>, Object>(api, null){
                    int label;
                    final /* synthetic */ GitLabApi $api;
                    {
                        this.$api = $api;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = GitLabUsersApiKt.getCurrentUser(this.$api.getGraphQL(), (Continuation<? super GitLabUserDetailedDTO>)((Continuation)this));
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super GitLabUserDetailedDTO> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v5 == var11_4) {
                    return var11_4;
                }
                ** GOTO lbl75
            }
            case 3: {
                server = (GitLabServerPath)$continuation.L$1;
                this = (GitLabTokenLoginPanelModel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl75:
                // 2 sources

                user = (GitLabUserDetailedDTO)v5;
                username = user.getUsername();
                _requiredUsername = this.requiredUsername;
                if (_requiredUsername != null && !Intrinsics.areEqual((Object)username, (Object)_requiredUsername)) {
                    throw new LoginException.AccountUsernameMismatch(_requiredUsername, username);
                }
                if (!((Boolean)this.uniqueAccountPredicate.invoke((Object)server, (Object)username)).booleanValue()) {
                    throw new LoginException.AccountAlreadyExists(username);
                }
                return username;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public final GitLabServerPath getServerPath() {
        return this.createServerPath(this.getServerUri());
    }

    private final GitLabServerPath createServerPath(String uri) {
        String normalized = URIUtil.INSTANCE.normalizeAndValidateHttpUri(uri);
        return new GitLabServerPath(normalized);
    }

    public boolean canGenerateToken(@NotNull String serverUri) {
        Intrinsics.checkNotNullParameter((Object)serverUri, (String)"serverUri");
        return URIUtil.INSTANCE.isValidHttpUri(serverUri);
    }

    public void generateToken(@NotNull String serverUri) {
        Intrinsics.checkNotNullParameter((Object)serverUri, (String)"serverUri");
        String string = GitLabSecurityUtil.INSTANCE.buildNewTokenUrl$intellij_vcs_gitlab(serverUri);
        if (string == null) {
            return;
        }
        String newTokenUrl = string;
        BrowserUtil.browse((String)newTokenUrl);
    }

    @Nullable
    public final Object tryGitAuthorization(@NotNull Continuation<? super Unit> $completion) {
        Object object = this._tryGitAuthorizationSignal.emit((Object)Unit.INSTANCE, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }
}

