/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.state;

import java.awt.Composite;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.PDLineDashPattern;
import org.apache.pdfbox.pdmodel.graphics.blend.BlendComposite;
import org.apache.pdfbox.pdmodel.graphics.blend.BlendMode;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.state.PDSoftMask;
import org.apache.pdfbox.pdmodel.graphics.state.PDTextState;
import org.apache.pdfbox.pdmodel.graphics.state.RenderingIntent;
import org.apache.pdfbox.util.Matrix;

public class PDGraphicsState
implements Cloneable {
    private boolean isClippingPathDirty;
    private Area clippingPath;
    private Matrix currentTransformationMatrix = new Matrix();
    private PDColor strokingColor = PDDeviceGray.INSTANCE.getInitialColor();
    private PDColor nonStrokingColor = PDDeviceGray.INSTANCE.getInitialColor();
    private PDColorSpace strokingColorSpace = PDDeviceGray.INSTANCE;
    private PDColorSpace nonStrokingColorSpace = PDDeviceGray.INSTANCE;
    private PDTextState textState = new PDTextState();
    private float lineWidth = 1.0f;
    private int lineCap = 0;
    private int lineJoin = 0;
    private float miterLimit = 10.0f;
    private PDLineDashPattern lineDashPattern = new PDLineDashPattern();
    private RenderingIntent renderingIntent;
    private boolean strokeAdjustment = false;
    private BlendMode blendMode = BlendMode.COMPATIBLE;
    private PDSoftMask softMask;
    private double alphaConstant = 1.0;
    private double nonStrokingAlphaConstant = 1.0;
    private boolean alphaSource = false;
    private boolean overprint = false;
    private boolean nonStrokingOverprint = false;
    private double overprintMode = 0.0;
    private COSBase transfer = null;
    private double flatness = 1.0;
    private double smoothness = 0.0;

    public PDGraphicsState(PDRectangle page) {
        this.clippingPath = new Area(page.toGeneralPath());
    }

    public Matrix getCurrentTransformationMatrix() {
        return this.currentTransformationMatrix;
    }

    public void setCurrentTransformationMatrix(Matrix value2) {
        this.currentTransformationMatrix = value2;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float value2) {
        this.lineWidth = value2;
    }

    public int getLineCap() {
        return this.lineCap;
    }

    public void setLineCap(int value2) {
        this.lineCap = value2;
    }

    public int getLineJoin() {
        return this.lineJoin;
    }

    public void setLineJoin(int value2) {
        this.lineJoin = value2;
    }

    public float getMiterLimit() {
        return this.miterLimit;
    }

    public void setMiterLimit(float value2) {
        this.miterLimit = value2;
    }

    public boolean isStrokeAdjustment() {
        return this.strokeAdjustment;
    }

    public void setStrokeAdjustment(boolean value2) {
        this.strokeAdjustment = value2;
    }

    public double getAlphaConstant() {
        return this.alphaConstant;
    }

    public void setAlphaConstant(double value2) {
        this.alphaConstant = value2;
    }

    @Deprecated
    public double getNonStrokeAlphaConstants() {
        return this.nonStrokingAlphaConstant;
    }

    @Deprecated
    public void setNonStrokeAlphaConstants(double value2) {
        this.nonStrokingAlphaConstant = value2;
    }

    public double getNonStrokeAlphaConstant() {
        return this.nonStrokingAlphaConstant;
    }

    public void setNonStrokeAlphaConstant(double value2) {
        this.nonStrokingAlphaConstant = value2;
    }

    public boolean isAlphaSource() {
        return this.alphaSource;
    }

    public void setAlphaSource(boolean value2) {
        this.alphaSource = value2;
    }

    public PDSoftMask getSoftMask() {
        return this.softMask;
    }

    public void setSoftMask(PDSoftMask softMask) {
        this.softMask = softMask;
    }

    public BlendMode getBlendMode() {
        return this.blendMode;
    }

    public void setBlendMode(BlendMode blendMode) {
        this.blendMode = blendMode;
    }

    public boolean isOverprint() {
        return this.overprint;
    }

    public void setOverprint(boolean value2) {
        this.overprint = value2;
    }

    public boolean isNonStrokingOverprint() {
        return this.nonStrokingOverprint;
    }

    public void setNonStrokingOverprint(boolean value2) {
        this.nonStrokingOverprint = value2;
    }

    public double getOverprintMode() {
        return this.overprintMode;
    }

    public void setOverprintMode(double value2) {
        this.overprintMode = value2;
    }

    public double getFlatness() {
        return this.flatness;
    }

    public void setFlatness(double value2) {
        this.flatness = value2;
    }

    public double getSmoothness() {
        return this.smoothness;
    }

    public void setSmoothness(double value2) {
        this.smoothness = value2;
    }

    public PDTextState getTextState() {
        return this.textState;
    }

    public void setTextState(PDTextState value2) {
        this.textState = value2;
    }

    public PDLineDashPattern getLineDashPattern() {
        return this.lineDashPattern;
    }

    public void setLineDashPattern(PDLineDashPattern value2) {
        this.lineDashPattern = value2;
    }

    public RenderingIntent getRenderingIntent() {
        return this.renderingIntent;
    }

    public void setRenderingIntent(RenderingIntent value2) {
        this.renderingIntent = value2;
    }

    public PDGraphicsState clone() {
        try {
            PDGraphicsState clone = (PDGraphicsState)super.clone();
            clone.textState = this.textState.clone();
            clone.currentTransformationMatrix = this.currentTransformationMatrix.clone();
            clone.strokingColor = this.strokingColor;
            clone.nonStrokingColor = this.nonStrokingColor;
            clone.lineDashPattern = this.lineDashPattern;
            clone.clippingPath = this.clippingPath;
            clone.isClippingPathDirty = false;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public PDColor getStrokingColor() {
        return this.strokingColor;
    }

    public void setStrokingColor(PDColor color) {
        this.strokingColor = color;
    }

    public PDColor getNonStrokingColor() {
        return this.nonStrokingColor;
    }

    public void setNonStrokingColor(PDColor color) {
        this.nonStrokingColor = color;
    }

    public PDColorSpace getStrokingColorSpace() {
        return this.strokingColorSpace;
    }

    public void setStrokingColorSpace(PDColorSpace colorSpace) {
        this.strokingColorSpace = colorSpace;
    }

    public PDColorSpace getNonStrokingColorSpace() {
        return this.nonStrokingColorSpace;
    }

    public void setNonStrokingColorSpace(PDColorSpace colorSpace) {
        this.nonStrokingColorSpace = colorSpace;
    }

    public void intersectClippingPath(GeneralPath path) {
        this.intersectClippingPath(new Area(path));
    }

    public void intersectClippingPath(Area area) {
        if (!this.isClippingPathDirty) {
            Area cloned = new Area();
            cloned.add(this.clippingPath);
            this.clippingPath = cloned;
            this.isClippingPathDirty = true;
        }
        this.clippingPath.intersect(area);
    }

    public Area getCurrentClippingPath() {
        return this.clippingPath;
    }

    public Composite getStrokingJavaComposite() {
        return BlendComposite.getInstance(this.blendMode, (float)this.alphaConstant);
    }

    public Composite getNonStrokingJavaComposite() {
        return BlendComposite.getInstance(this.blendMode, (float)this.nonStrokingAlphaConstant);
    }

    public COSBase getTransfer() {
        return this.transfer;
    }

    public void setTransfer(COSBase transfer) {
        this.transfer = transfer;
    }
}

