/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.runner;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaException;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0003H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"QODANA_OUTPUT_LOG_LEVEL", "", "customConfigPath", "Ljava/nio/file/Path;", "configOption", "projectPath", "intellij.qodana"})
public final class QodanaInspectionApplicationFactoryKt {
    @NotNull
    private static final String QODANA_OUTPUT_LOG_LEVEL = "QODANA_OUTPUT_LOG_LEVEL";

    private static final Path customConfigPath(String configOption, Path projectPath) {
        Path optionPath = Paths.get(configOption, new String[0]);
        Path configPath = optionPath.isAbsolute() ? optionPath : projectPath.resolve(optionPath);
        Intrinsics.checkNotNull((Object)configPath);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(configPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new QodanaException("Configuration file '" + configPath + "' doesn't exist");
        }
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.isRegularFile(configPath, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            throw new QodanaException("Configuration file '" + configPath + "' should be regular file");
        }
        if (!Files.isReadable(configPath)) {
            throw new QodanaException("Qodana doesn't have enough privileges to read configuration file '" + configPath + "'");
        }
        return configPath;
    }

    public static final /* synthetic */ Path access$customConfigPath(String configOption, Path projectPath) {
        return QodanaInspectionApplicationFactoryKt.customConfigPath(configOption, projectPath);
    }
}

