/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.tree;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.SchemaResolveState;
import com.jetbrains.jsonSchema.impl.light.legacy.JsonSchemaObjectMergerKt;
import com.jetbrains.jsonSchema.impl.tree.JsonSchemaNodeExpansionRequest;
import com.jetbrains.jsonSchema.impl.tree.Operation;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProcessDefinitionsOperation
extends Operation {
    private final JsonSchemaService myService;

    public ProcessDefinitionsOperation(@NotNull JsonSchemaObject sourceNode, @NotNull JsonSchemaService service, @Nullable JsonSchemaNodeExpansionRequest expansionRequest) {
        if (sourceNode == null) {
            ProcessDefinitionsOperation.$$$reportNull$$$0(0);
        }
        if (service == null) {
            ProcessDefinitionsOperation.$$$reportNull$$$0(1);
        }
        super(sourceNode, expansionRequest);
        this.myService = service;
    }

    @Override
    public void map(@NotNull Set<JsonSchemaObject> visited) {
        Operation expandOperation;
        if (visited == null) {
            ProcessDefinitionsOperation.$$$reportNull$$$0(2);
        }
        JsonSchemaObject current = this.mySourceNode;
        while (!StringUtil.isEmptyOrSpaces((String)current.getRef())) {
            ProgressManager.checkCanceled();
            JsonSchemaObject definition = current.resolveRefSchema(this.myService);
            if (definition == null) {
                this.myState = SchemaResolveState.brokenDefinition;
                return;
            }
            if (!visited.add(definition)) break;
            current = JsonSchemaObjectMergerKt.getJsonSchemaObjectMerger().mergeObjects(current, definition, current);
        }
        if ((expandOperation = this.createExpandOperation(current, this.myService, this.myExpansionRequest)) != null) {
            this.myChildOperations.add(expandOperation);
        } else {
            this.myAnyOfGroup.add(current);
        }
    }

    @Override
    public void reduce() {
        if (!this.myChildOperations.isEmpty()) {
            assert (this.myChildOperations.size() == 1);
            Operation operation = (Operation)this.myChildOperations.get(0);
            this.myAnyOfGroup.addAll(operation.myAnyOfGroup);
            this.myOneOfGroup.addAll(operation.myOneOfGroup);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/jsonSchema/impl/tree/ProcessDefinitionsOperation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "map";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

