/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.mp4;

import com.drew.imaging.mp4.Mp4Handler;
import com.drew.lang.DateUtil;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Metadata;
import com.drew.metadata.mp4.Mp4Context;
import com.drew.metadata.mp4.media.Mp4MediaDirectory;
import java.io.IOException;

public abstract class Mp4MediaHandler<T extends Mp4MediaDirectory>
extends Mp4Handler<T> {
    public Mp4MediaHandler(Metadata metadata, Mp4Context context) {
        super(metadata);
        if (context.creationTime != null) {
            ((Mp4MediaDirectory)this.directory).setDate(101, DateUtil.get1Jan1904EpochDate(context.creationTime));
        }
        if (context.modificationTime != null) {
            ((Mp4MediaDirectory)this.directory).setDate(102, DateUtil.get1Jan1904EpochDate(context.modificationTime));
        }
        if (context.language != null) {
            ((Mp4MediaDirectory)this.directory).setString(104, context.language);
        }
    }

    @Override
    public boolean shouldAcceptBox(@NotNull String type) {
        return type.equals(this.getMediaInformation()) || type.equals("stsd") || type.equals("stts");
    }

    @Override
    public boolean shouldAcceptContainer(@NotNull String type) {
        return type.equals("stbl") || type.equals("minf");
    }

    @Override
    public Mp4Handler<?> processBox(@NotNull String type, @Nullable byte[] payload, long boxSize, Mp4Context context) throws IOException {
        if (payload != null) {
            SequentialByteArrayReader reader = new SequentialByteArrayReader(payload);
            if (type.equals(this.getMediaInformation())) {
                this.processMediaInformation(reader);
            } else if (type.equals("stsd")) {
                this.processSampleDescription(reader);
            } else if (type.equals("stts")) {
                this.processTimeToSample(reader, context);
            }
        }
        return this;
    }

    protected abstract String getMediaInformation();

    protected abstract void processSampleDescription(@NotNull SequentialReader var1) throws IOException;

    protected abstract void processMediaInformation(@NotNull SequentialReader var1) throws IOException;

    protected abstract void processTimeToSample(@NotNull SequentialReader var1, Mp4Context var2) throws IOException;
}

