/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.notificators;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.mail.MessagingException;
import org.traccar.mail.MailManager;
import org.traccar.model.Event;
import org.traccar.model.Position;
import org.traccar.model.User;
import org.traccar.notification.MessageException;
import org.traccar.notification.NotificationFormatter;
import org.traccar.notification.NotificationMessage;
import org.traccar.notificators.Notificator;

@Singleton
public class NotificatorMail
extends Notificator {
    private final MailManager mailManager;

    @Inject
    public NotificatorMail(MailManager mailManager, NotificationFormatter notificationFormatter) {
        super(notificationFormatter, "full");
        this.mailManager = mailManager;
    }

    @Override
    public void send(User user, NotificationMessage message, Event event, Position position) throws MessageException {
        try {
            this.mailManager.sendMessage(user, false, message.getSubject(), message.getBody());
        }
        catch (MessagingException e) {
            throw new MessageException(e);
        }
    }
}

