/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaAndData;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.repository.Repository;

public class RepositoryUtil {
    public static DatabaseMeta loadDatabaseMeta(Repository rep, long id_database) throws KettleException {
        DatabaseMeta databaseMeta = new DatabaseMeta();
        try {
            RowMetaAndData r = rep.getDatabase(id_database);
            if (r != null) {
                long id_database_type = r.getInteger("ID_DATABASE_TYPE", 0L);
                String dbTypeDesc = rep.getDatabaseTypeCode(id_database_type);
                if (dbTypeDesc != null) {
                    databaseMeta.setDatabaseInterface(DatabaseMeta.getDatabaseInterface((String)dbTypeDesc));
                    databaseMeta.setAttributes(new Properties());
                }
                databaseMeta.setID(id_database);
                databaseMeta.setName(r.getString("NAME", ""));
                long id_database_contype = r.getInteger("ID_DATABASE_CONTYPE", 0L);
                databaseMeta.setAccessType(DatabaseMeta.getAccessType((String)rep.getDatabaseConTypeCode(id_database_contype)));
                databaseMeta.setHostname(r.getString("HOST_NAME", ""));
                databaseMeta.setDBName(r.getString("DATABASE_NAME", ""));
                databaseMeta.setDBPort(r.getString("PORT", ""));
                databaseMeta.setUsername(r.getString("USERNAME", ""));
                databaseMeta.setPassword(Encr.decryptPasswordOptionallyEncrypted((String)r.getString("PASSWORD", "")));
                databaseMeta.setServername(r.getString("SERVERNAME", ""));
                databaseMeta.setDataTablespace(r.getString("DATA_TBS", ""));
                databaseMeta.setIndexTablespace(r.getString("INDEX_TBS", ""));
                Collection<RowMetaAndData> attrs = rep.getDatabaseAttributes(id_database);
                for (RowMetaAndData row : attrs) {
                    String code = row.getString("CODE", "");
                    String attribute = row.getString("VALUE_STR", "");
                    databaseMeta.getAttributes().put(code, Const.NVL((String)attribute, (String)""));
                }
            }
            return databaseMeta;
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Error loading database connection from repository (id_database=" + id_database + ")", (Throwable)dbe);
        }
    }

    public static void saveDatabaseMeta(DatabaseMeta databaseMeta, Repository rep) throws KettleException {
        try {
            if (databaseMeta.getID() <= 0L) {
                databaseMeta.setID(rep.getDatabaseID(databaseMeta.getName()));
            }
            if (databaseMeta.getID() <= 0L) {
                databaseMeta.setID(rep.insertDatabase(databaseMeta.getName(), DatabaseMeta.getDatabaseTypeCode((int)databaseMeta.getDatabaseType()), DatabaseMeta.getAccessTypeDesc((int)databaseMeta.getAccessType()), databaseMeta.getHostname(), databaseMeta.getDatabaseName(), databaseMeta.getDatabasePortNumberString(), databaseMeta.getUsername(), databaseMeta.getPassword(), databaseMeta.getServername(), databaseMeta.getDataTablespace(), databaseMeta.getIndexTablespace()));
            } else {
                rep.updateDatabase(databaseMeta.getID(), databaseMeta.getName(), DatabaseMeta.getDatabaseTypeCode((int)databaseMeta.getDatabaseType()), DatabaseMeta.getAccessTypeDesc((int)databaseMeta.getAccessType()), databaseMeta.getHostname(), databaseMeta.getDatabaseName(), databaseMeta.getDatabasePortNumberString(), databaseMeta.getUsername(), databaseMeta.getPassword(), databaseMeta.getServername(), databaseMeta.getDataTablespace(), databaseMeta.getIndexTablespace());
            }
            rep.delDatabaseAttributes(databaseMeta.getID());
            Properties attributes = databaseMeta.getAttributes();
            Enumeration<Object> keys = databaseMeta.getAttributes().keys();
            while (keys.hasMoreElements()) {
                String code = (String)keys.nextElement();
                String attribute = (String)attributes.get(code);
                rep.insertDatabaseAttribute(databaseMeta.getID(), code, attribute);
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Error saving database connection or one of its attributes to the repository.", (Throwable)dbe);
        }
    }

    public static ValueMetaAndData loadValueMetaAndData(Repository rep, long id_value) throws KettleException {
        ValueMetaAndData valueMetaAndData = new ValueMetaAndData();
        try {
            RowMetaAndData r = rep.getValue(id_value);
            if (r != null) {
                String name = r.getString("NAME", null);
                int valtype = ValueMeta.getType((String)r.getString("VALUE_TYPE", null));
                boolean isNull = r.getBoolean("IS_NULL", false);
                valueMetaAndData.setValueMeta((ValueMetaInterface)new ValueMeta(name, valtype));
                if (isNull) {
                    valueMetaAndData.setValueData(null);
                } else {
                    ValueMeta stringValueMeta = new ValueMeta(name, 2);
                    ValueMetaInterface valueMeta = valueMetaAndData.getValueMeta();
                    stringValueMeta.setConversionMetadata(valueMeta);
                    valueMeta.setDecimalSymbol(".");
                    valueMeta.setGroupingSymbol(",");
                    switch (valueMeta.getType()) {
                        case 1: {
                            valueMeta.setConversionMask("#.#");
                            break;
                        }
                        case 5: {
                            valueMeta.setConversionMask("#");
                            break;
                        }
                    }
                    String string = r.getString("VALUE_STR", null);
                    valueMetaAndData.setValueData(stringValueMeta.convertDataUsingConversionMetaData((Object)string));
                    valueMeta = new ValueMeta(name, valueMeta.getType());
                }
            }
            return valueMetaAndData;
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load Value from repository with id_value=" + id_value, (Throwable)dbe);
        }
    }
}

