/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.object;

import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.SPResolverRegistry;
import ca.sqlpower.object.SPVariableHelper;
import ca.sqlpower.object.SPVariableResolver;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.collections.map.MultiValueMap;

public class SPSimpleVariableResolver
implements SPVariableResolver {
    protected final MultiValueMap variables = new MultiValueMap();
    private String namespace = null;
    private String userFriendlyName;
    private final SPObject owner;

    public SPSimpleVariableResolver(SPObject owner, String namespace, String userFriendlyName) {
        this(owner, namespace, userFriendlyName, true);
    }

    public SPSimpleVariableResolver(SPObject owner, String namespace, String userFriendlyName, boolean register) {
        this.owner = owner;
        this.namespace = namespace;
        this.userFriendlyName = userFriendlyName;
        if (register) {
            SPResolverRegistry.register(owner, this);
        }
    }

    protected void beforeLookups(String key) {
    }

    protected void beforeKeyLookup(String namespace) {
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void clear() {
        this.variables.clear();
    }

    public void cleanup() {
        SPResolverRegistry.deregister(this.owner, this);
        this.clear();
    }

    @Override
    public void store(String key, Object value) {
        if (this.namespace != null && SPVariableHelper.getNamespace(key) != null && !this.namespace.equals(SPVariableHelper.getNamespace(key))) {
            throw new IllegalArgumentException("Cannot store a namespaced variable of a different namespace than this resolver is configured with.");
        }
        this.variables.put((Object)SPVariableHelper.getKey(key), value);
    }

    @Override
    public void update(String key, Object value) {
        if (this.variables.containsKey((Object)SPVariableHelper.getKey(key))) {
            this.variables.remove((Object)SPVariableHelper.getKey(key));
        }
        this.variables.put((Object)SPVariableHelper.getKey(key), value);
    }

    @Override
    public void delete(String key) {
        this.variables.remove((Object)SPVariableHelper.getKey(key));
    }

    @Override
    public Collection<Object> matches(String key, String partialValue) {
        this.beforeLookups(key);
        String namespace = SPVariableHelper.getNamespace(key);
        if (this.resolvesNamespace(namespace)) {
            HashSet<Object> matches = new HashSet<Object>();
            Collection<Object> values = this.resolveCollection(key);
            for (Object obj : values) {
                String stringRep = obj.toString();
                if (!stringRep.startsWith(partialValue)) continue;
                matches.add(obj);
            }
            return matches;
        }
        return Collections.emptySet();
    }

    @Override
    public Object resolve(String key) {
        return this.resolve(key, null);
    }

    @Override
    public Object resolve(String key, Object defaultValue) {
        this.beforeLookups(key);
        String namespace = SPVariableHelper.getNamespace(key);
        if (this.resolvesNamespace(namespace)) {
            Collection value = this.variables.getCollection((Object)SPVariableHelper.getKey(key));
            if (value == null || value.size() == 0) {
                return defaultValue;
            }
            return value.iterator().next();
        }
        return defaultValue;
    }

    @Override
    public Collection<Object> resolveCollection(String key) {
        return this.resolveCollection(key, null);
    }

    @Override
    public Collection<Object> resolveCollection(String key, Object defaultValue) {
        Collection value;
        this.beforeLookups(key);
        String namespace = SPVariableHelper.getNamespace(key);
        if (this.resolvesNamespace(namespace) && (value = this.variables.getCollection((Object)SPVariableHelper.getKey(key))) != null) {
            return value;
        }
        return Collections.singleton(defaultValue);
    }

    @Override
    public boolean resolves(String key) {
        this.beforeLookups(key);
        String namespace = SPVariableHelper.getNamespace(key);
        if (this.resolvesNamespace(namespace)) {
            return this.variables.containsKey((Object)SPVariableHelper.getKey(key));
        }
        return false;
    }

    @Override
    public boolean resolvesNamespace(String namespace) {
        if (namespace == null) {
            return true;
        }
        return namespace.equals(this.namespace);
    }

    @Override
    public Collection<String> keySet(String namespace) {
        this.beforeKeyLookup(namespace);
        if (this.resolvesNamespace(namespace)) {
            if (this.namespace == null) {
                return this.variables.keySet();
            }
            HashSet<String> keys = new HashSet<String>();
            for (Object key : this.variables.keySet()) {
                keys.add(this.namespace.concat("::").concat(key.toString()));
            }
            return keys;
        }
        return Collections.emptySet();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getUserFriendlyName() {
        return this.userFriendlyName;
    }

    public void setUserFriendlyName(String userFriendlyName) {
        this.userFriendlyName = userFriendlyName;
    }
}

