/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.internal.precompiled;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.GroovyBasePlugin;
import org.gradle.api.tasks.GroovySourceDirectorySet;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.resource.TextFileResourceLoader;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;
import org.gradle.plugin.devel.PluginDeclaration;
import org.gradle.plugin.devel.internal.precompiled.CompileGroovyScriptPluginsTask;
import org.gradle.plugin.devel.internal.precompiled.ExtractPluginRequestsTask;
import org.gradle.plugin.devel.internal.precompiled.GeneratePluginAdaptersTask;
import org.gradle.plugin.devel.internal.precompiled.PrecompiledGroovyScript;
import org.gradle.plugin.devel.internal.precompiled.PrecompiledScriptException;
import org.gradle.plugin.devel.plugins.JavaGradlePluginPlugin;

public abstract class PrecompiledGroovyPluginsPlugin
implements Plugin<Project> {
    private static final Documentation PRECOMPILED_SCRIPT_MANUAL = Documentation.userManual((String)"custom_plugins", (String)"sec:precompiled_plugins");

    public void apply(Project project) {
        project.getPluginManager().apply(GroovyBasePlugin.class);
        project.getPluginManager().apply(JavaGradlePluginPlugin.class);
        project.afterEvaluate(this::exposeScriptsAsPlugins);
    }

    @Inject
    protected abstract TextFileResourceLoader getTextFileResourceLoader();

    private void exposeScriptsAsPlugins(Project project) {
        GradlePluginDevelopmentExtension pluginExtension = (GradlePluginDevelopmentExtension)project.getExtensions().getByType(GradlePluginDevelopmentExtension.class);
        SourceSet pluginSourceSet = pluginExtension.getPluginSourceSet();
        FileTree scriptPluginFiles = pluginSourceSet.getAllSource().matching(PrecompiledGroovyScript::filterPluginFiles);
        List<PrecompiledGroovyScript> scriptPlugins = scriptPluginFiles.getFiles().stream().map(file -> new PrecompiledGroovyScript((File)file, this.getTextFileResourceLoader())).peek(scriptPlugin -> this.validateScriptPlugin(project, (PrecompiledGroovyScript)scriptPlugin)).collect(Collectors.toList());
        this.declarePluginMetadata(pluginExtension, scriptPlugins);
        DirectoryProperty buildDir = project.getLayout().getBuildDirectory();
        TaskContainer tasks = project.getTasks();
        TaskProvider extractPluginRequests = tasks.register("extractPluginRequests", ExtractPluginRequestsTask.class, task -> {
            task.getScriptPlugins().convention((Iterable)scriptPlugins);
            task.getScriptFiles().from(new Object[]{scriptPluginFiles.getFiles()});
            task.getExtractedPluginRequestsClassesDirectory().convention(buildDir.dir("groovy-dsl-plugins/output/plugin-requests"));
            task.getExtractedPluginRequestsClassesStagingDirectory().convention(buildDir.dir("groovy-dsl-plugins/output/plugin-requests-staging"));
        });
        TaskProvider generatePluginAdapters = tasks.register("generatePluginAdapters", GeneratePluginAdaptersTask.class, task -> {
            task.getScriptPlugins().convention((Iterable)scriptPlugins);
            task.getExtractedPluginRequestsClassesDirectory().convention(extractPluginRequests.flatMap(ExtractPluginRequestsTask::getExtractedPluginRequestsClassesDirectory));
            task.getPluginAdapterSourcesOutputDirectory().convention(buildDir.dir("groovy-dsl-plugins/output/adapter-src"));
        });
        TaskProvider precompilePlugins = tasks.register("compileGroovyPlugins", CompileGroovyScriptPluginsTask.class, task -> {
            task.getScriptPlugins().convention((Iterable)scriptPlugins);
            task.getScriptFiles().from(new Object[]{scriptPluginFiles.getFiles()});
            task.getPrecompiledGroovyScriptsOutputDirectory().convention(buildDir.dir("groovy-dsl-plugins/output/plugin-classes"));
            SourceDirectorySet javaSource = pluginSourceSet.getJava();
            SourceDirectorySet groovySource = (SourceDirectorySet)pluginSourceSet.getExtensions().getByType(GroovySourceDirectorySet.class);
            task.getClasspath().from(new Object[]{pluginSourceSet.getCompileClasspath(), javaSource.getClassesDirectory(), groovySource.getClassesDirectory()});
        });
        pluginSourceSet.getJava().srcDir((Object)generatePluginAdapters.flatMap(GeneratePluginAdaptersTask::getPluginAdapterSourcesOutputDirectory));
        pluginSourceSet.getOutput().dir((Object)precompilePlugins.flatMap(CompileGroovyScriptPluginsTask::getPrecompiledGroovyScriptsOutputDirectory));
        pluginSourceSet.getOutput().dir((Object)extractPluginRequests.flatMap(ExtractPluginRequestsTask::getExtractedPluginRequestsClassesStagingDirectory));
    }

    private void validateScriptPlugin(Project project, PrecompiledGroovyScript scriptPlugin) {
        if (scriptPlugin.getId().equals("org.gradle") || scriptPlugin.getId().startsWith("org.gradle.")) {
            throw new PrecompiledScriptException(String.format("The precompiled plugin (%s) cannot start with '%s'.", project.relativePath((Object)scriptPlugin.getFileName()), "org.gradle"), PRECOMPILED_SCRIPT_MANUAL.consultDocumentationMessage());
        }
        Plugin existingPlugin = project.getPlugins().findPlugin(scriptPlugin.getId());
        if (existingPlugin != null && existingPlugin.getClass().getPackage().getName().startsWith("org.gradle.")) {
            throw new PrecompiledScriptException(String.format("The precompiled plugin (%s) conflicts with the core plugin '%s'. Rename your plugin.", project.relativePath((Object)scriptPlugin.getFileName()), scriptPlugin.getId()), PRECOMPILED_SCRIPT_MANUAL.consultDocumentationMessage());
        }
    }

    private void declarePluginMetadata(GradlePluginDevelopmentExtension pluginExtension, List<PrecompiledGroovyScript> scriptPlugins) {
        pluginExtension.plugins((Action<? super NamedDomainObjectContainer<PluginDeclaration>>)((Action)pluginDeclarations -> scriptPlugins.forEach(scriptPlugin -> pluginDeclarations.create(scriptPlugin.getId(), scriptPlugin::declarePlugin))));
    }
}

