/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.wrapper;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;
import org.gradle.api.GradleException;
import org.gradle.api.resources.TextResource;
import org.gradle.api.tasks.wrapper.internal.DefaultWrapperVersionsResources;
import org.gradle.util.GradleVersion;

class GradleVersionResolver {
    private TextResource latest;
    private TextResource releaseCandidate;
    private TextResource nightly;
    private TextResource releaseNightly;
    private GradleVersion gradleVersion;
    private String gradleVersionString = GradleVersion.current().getVersion();

    GradleVersionResolver() {
    }

    void setTextResources(TextResource latest, TextResource releaseCandidate, TextResource nightly, TextResource releaseNightly) {
        this.latest = latest;
        this.releaseCandidate = releaseCandidate;
        this.nightly = nightly;
        this.releaseNightly = releaseNightly;
    }

    String resolve(String version) {
        if (version == null) {
            return GradleVersion.current().getVersion();
        }
        switch (version) {
            case "latest": {
                return GradleVersionResolver.getVersion(this.latest.asString(), version);
            }
            case "nightly": {
                return GradleVersionResolver.getVersion(this.nightly.asString(), version);
            }
            case "release-nightly": {
                return GradleVersionResolver.getVersion(this.releaseNightly.asString(), version);
            }
            case "release-candidate": {
                return GradleVersionResolver.getVersion(this.releaseCandidate.asString(), version);
            }
        }
        return version;
    }

    static String getVersion(String json, String placeHolder) {
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        Map map = (Map)new Gson().fromJson(json, type);
        String version = (String)map.get("version");
        if (version == null) {
            throw new GradleException("There is currently no version information available for '" + placeHolder + "'.");
        }
        return version;
    }

    static boolean isPlaceHolder(String version) {
        return DefaultWrapperVersionsResources.PLACE_HOLDERS.contains(version);
    }

    GradleVersion getGradleVersion() {
        if (this.gradleVersion == null) {
            this.gradleVersion = GradleVersion.version((String)this.resolve(this.gradleVersionString));
        }
        return this.gradleVersion;
    }

    void setGradleVersionString(String gradleVersionString) {
        if (!GradleVersionResolver.isPlaceHolder(gradleVersionString)) {
            this.gradleVersion = GradleVersion.version((String)gradleVersionString);
        }
        if (this.gradleVersionString != gradleVersionString) {
            this.gradleVersionString = gradleVersionString;
            this.gradleVersion = null;
        }
    }
}

