/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.compiled;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.BinaryFileDecompiler;
import org.jetbrains.kotlin.com.intellij.openapi.project.DefaultProjectFactory;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.compiled.ClassFileDecompilers;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsDecompilerImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsFileImpl;

public class ClassFileDecompiler
implements BinaryFileDecompiler {
    private static final Logger LOG = Logger.getInstance(ClassFileDecompiler.class);

    @Override
    @NotNull
    public CharSequence decompile(@NotNull VirtualFile file2) {
        ClassFileDecompilers.Decompiler decompiler;
        if (file2 == null) {
            ClassFileDecompiler.$$$reportNull$$$0(0);
        }
        if ((decompiler = ClassFileDecompilers.getInstance().find(file2, ClassFileDecompilers.Decompiler.class)) instanceof ClsDecompilerImpl) {
            CharSequence charSequence2 = ClsFileImpl.decompile(file2);
            if (charSequence2 == null) {
                ClassFileDecompiler.$$$reportNull$$$0(1);
            }
            return charSequence2;
        }
        if (decompiler instanceof ClassFileDecompilers.Full) {
            PsiManager manager = PsiManager.getInstance(DefaultProjectFactory.getInstance().getDefaultProject());
            CharSequence charSequence3 = ((ClassFileDecompilers.Full)decompiler).createFileViewProvider(file2, manager, true).getContents();
            if (charSequence3 == null) {
                ClassFileDecompiler.$$$reportNull$$$0(2);
            }
            return charSequence3;
        }
        if (decompiler instanceof ClassFileDecompilers.Light) {
            CharSequence charSequence4;
            try {
                charSequence4 = ((ClassFileDecompilers.Light)decompiler).getText(file2);
            }
            catch (ClassFileDecompilers.Light.CannotDecompileException e) {
                LOG.warn("decompiler: " + decompiler.getClass(), e);
                CharSequence charSequence5 = ClsFileImpl.decompile(file2);
                if (charSequence5 == null) {
                    ClassFileDecompiler.$$$reportNull$$$0(4);
                }
                return charSequence5;
            }
            if (charSequence4 == null) {
                ClassFileDecompiler.$$$reportNull$$$0(3);
            }
            return charSequence4;
        }
        throw new IllegalStateException(decompiler.getClass().getName() + " should be on of " + ClassFileDecompilers.Full.class.getName() + " or " + ClassFileDecompilers.Light.class.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClassFileDecompiler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClassFileDecompiler";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "decompile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "decompile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

