/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.requestbody;

import com.fasterxml.jackson.databind.JsonNode;
import io.smallrye.openapi.api.models.media.ContentImpl;
import io.smallrye.openapi.api.models.media.MediaTypeImpl;
import io.smallrye.openapi.api.models.parameters.RequestBodyImpl;
import io.smallrye.openapi.runtime.io.ContentDirection;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.content.ContentReader;
import io.smallrye.openapi.runtime.io.extension.ExtensionReader;
import io.smallrye.openapi.runtime.io.requestbody.RequestBodyConstant;
import io.smallrye.openapi.runtime.io.schema.SchemaFactory;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.JandexUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class RequestBodyReader {
    private RequestBodyReader() {
    }

    public static Map<String, RequestBody> readRequestBodies(AnnotationScannerContext context, AnnotationValue annotationValue) {
        AnnotationInstance[] nestedArray;
        if (annotationValue == null) {
            return null;
        }
        IoLogging.logger.annotationsMap("@RequestBody");
        LinkedHashMap<String, RequestBody> requestBodies = new LinkedHashMap<String, RequestBody>();
        for (AnnotationInstance nested : nestedArray = annotationValue.asNestedArray()) {
            String name = (String)context.annotations().value(nested, "name");
            if (name == null && JandexUtil.isRef(nested)) {
                name = JandexUtil.nameFromRef(nested);
            }
            if (name == null) continue;
            requestBodies.put(name, RequestBodyReader.readRequestBody(context, nested));
        }
        return requestBodies;
    }

    public static Map<String, RequestBody> readRequestBodies(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        IoLogging.logger.jsonMap("RequestBody");
        LinkedHashMap<String, RequestBody> requestBodies = new LinkedHashMap<String, RequestBody>();
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode childNode = node.get(fieldName);
            requestBodies.put(fieldName, RequestBodyReader.readRequestBody(childNode));
        }
        return requestBodies;
    }

    public static RequestBody readRequestBody(AnnotationScannerContext context, AnnotationValue annotationValue) {
        if (annotationValue == null) {
            return null;
        }
        return RequestBodyReader.readRequestBody(context, annotationValue.asNested());
    }

    public static RequestBody readRequestBody(AnnotationScannerContext context, AnnotationInstance annotationInstance) {
        if (annotationInstance == null) {
            return null;
        }
        IoLogging.logger.singleAnnotation("@RequestBody");
        RequestBodyImpl requestBody = new RequestBodyImpl();
        requestBody.setDescription((String)context.annotations().value(annotationInstance, "description"));
        requestBody.setContent(ContentReader.readContent(context, annotationInstance.value("content"), ContentDirection.INPUT));
        requestBody.setRequired((Boolean)context.annotations().value(annotationInstance, "required"));
        requestBody.setRef(JandexUtil.refValue(annotationInstance, JandexUtil.RefType.REQUEST_BODY));
        requestBody.setExtensions(ExtensionReader.readExtensions(context, annotationInstance));
        return requestBody;
    }

    public static RequestBody readRequestBodySchema(AnnotationScannerContext context, AnnotationInstance annotation) {
        if (annotation == null || context.getCurrentConsumes() == null) {
            return null;
        }
        IoLogging.logger.singleAnnotation("@RequestBodySchema");
        ContentImpl content = new ContentImpl();
        for (String mediaType : context.getCurrentConsumes()) {
            MediaTypeImpl type = new MediaTypeImpl();
            type.setSchema(SchemaFactory.typeToSchema(context, (Type)context.annotations().value(annotation, "value"), null, context.getExtensions()));
            content.addMediaType(mediaType, type);
        }
        RequestBodyImpl requestBody = new RequestBodyImpl();
        requestBody.setContent(content);
        return requestBody;
    }

    public static RequestBody readRequestBody(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        RequestBodyImpl requestBody = new RequestBodyImpl();
        requestBody.setDescription(JsonUtil.stringProperty(node, "description"));
        requestBody.setContent(ContentReader.readContent(node.get("content")));
        requestBody.setRequired(JsonUtil.booleanProperty(node, "required").orElse(null));
        requestBody.setRef(JsonUtil.stringProperty(node, "$ref"));
        ExtensionReader.readExtensions(node, requestBody);
        return requestBody;
    }

    public static List<AnnotationInstance> getRequestBodyAnnotations(AnnotationScannerContext context, MethodInfo method) {
        return RequestBodyReader.getAnnotations(context, method, RequestBodyConstant.DOTNAME_REQUESTBODY).collect(Collectors.toList());
    }

    public static AnnotationInstance getRequestBodySchemaAnnotation(AnnotationScannerContext context, MethodInfo method) {
        return RequestBodyReader.getAnnotations(context, method, RequestBodyConstant.DOTNAME_REQUEST_BODY_SCHEMA).findFirst().orElse(null);
    }

    static Stream<AnnotationInstance> getAnnotations(AnnotationScannerContext context, MethodInfo method, DotName annotation) {
        Stream<AnnotationInstance> methodAnnos = Stream.of(context.annotations().getAnnotation((AnnotationTarget)method, annotation));
        Stream<AnnotationInstance> paramAnnos = method.parameterTypes().stream().map(p -> context.annotations().getMethodParameterAnnotation(method, (Type)p, annotation));
        return Stream.concat(methodAnnos, paramAnnos).filter(Objects::nonNull);
    }
}

