/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.requiredactions;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriBuilderException;
import jakarta.ws.rs.core.UriInfo;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.authentication.actiontoken.verifyemail.VerifyEmailActionToken;
import org.keycloak.common.util.Time;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailTemplateProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.Urls;
import org.keycloak.services.validation.Validation;
import org.keycloak.sessions.AuthenticationSessionCompoundId;
import org.keycloak.sessions.AuthenticationSessionModel;

public class VerifyEmail
implements RequiredActionProvider,
RequiredActionFactory {
    private static final Logger logger = Logger.getLogger(VerifyEmail.class);

    public void evaluateTriggers(RequiredActionContext context) {
        if (context.getRealm().isVerifyEmail() && !context.getUser().isEmailVerified()) {
            context.getUser().addRequiredAction(UserModel.RequiredAction.VERIFY_EMAIL);
            logger.debug((Object)"User is required to verify email");
        }
    }

    public void requiredActionChallenge(RequiredActionContext context) {
        Response challenge;
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        if (context.getUser().isEmailVerified()) {
            context.success();
            authSession.removeAuthNote("VERIFY_EMAIL_KEY");
            return;
        }
        String email = context.getUser().getEmail();
        if (Validation.isBlank(email)) {
            context.ignore();
            return;
        }
        LoginFormsProvider loginFormsProvider = context.form();
        authSession.setClientNote("APP_INITIATED_FLOW", null);
        if (!Objects.equals(authSession.getAuthNote("VERIFY_EMAIL_KEY"), email)) {
            authSession.setAuthNote("VERIFY_EMAIL_KEY", email);
            EventBuilder event = context.getEvent().clone().event(EventType.SEND_VERIFY_EMAIL).detail("email", email);
            challenge = this.sendVerifyEmail(context.getSession(), loginFormsProvider, context.getUser(), context.getAuthenticationSession(), event);
        } else {
            challenge = loginFormsProvider.createResponse(UserModel.RequiredAction.VERIFY_EMAIL);
        }
        context.challenge(challenge);
    }

    public void processAction(RequiredActionContext context) {
        logger.debugf("Re-sending email requested for user: %s", (Object)context.getUser().getUsername());
        context.getAuthenticationSession().removeAuthNote("VERIFY_EMAIL_KEY");
        this.requiredActionChallenge(context);
    }

    public void close() {
    }

    public RequiredActionProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getDisplayText() {
        return "Verify Email";
    }

    public String getId() {
        return UserModel.RequiredAction.VERIFY_EMAIL.name();
    }

    private Response sendVerifyEmail(KeycloakSession session, LoginFormsProvider forms, UserModel user, AuthenticationSessionModel authSession, EventBuilder event) throws UriBuilderException, IllegalArgumentException {
        RealmModel realm = session.getContext().getRealm();
        KeycloakUriInfo uriInfo = session.getContext().getUri();
        int validityInSecs = realm.getActionTokenGeneratedByUserLifespan("verify-email");
        int absoluteExpirationInSecs = Time.currentTime() + validityInSecs;
        String authSessionEncodedId = AuthenticationSessionCompoundId.fromAuthSession((AuthenticationSessionModel)authSession).getEncodedId();
        VerifyEmailActionToken token = new VerifyEmailActionToken(user.getId(), absoluteExpirationInSecs, authSessionEncodedId, user.getEmail(), authSession.getClient().getClientId());
        UriBuilder builder = Urls.actionTokenBuilder(uriInfo.getBaseUri(), token.serialize(session, realm, (UriInfo)uriInfo), authSession.getClient().getClientId(), authSession.getTabId(), AuthenticationProcessor.getClientData(session, authSession));
        String link = builder.build(new Object[]{realm.getName()}).toString();
        long expirationInMinutes = TimeUnit.SECONDS.toMinutes(validityInSecs);
        try {
            ((EmailTemplateProvider)session.getProvider(EmailTemplateProvider.class)).setAuthenticationSession(authSession).setRealm(realm).setUser(user).sendVerifyEmail(link, expirationInMinutes);
            event.success();
        }
        catch (EmailException e) {
            logger.error((Object)"Failed to send verification email", (Throwable)e);
            event.error("email_send_failed");
        }
        return forms.createResponse(UserModel.RequiredAction.VERIFY_EMAIL);
    }
}

