/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.ConfigValueConfigSource;
import io.smallrye.config.SmallRyeConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;

class SmallRyeConfigSources
implements ConfigSourceInterceptor {
    private static final long serialVersionUID = 7560201715403486552L;
    private final List<ConfigValueConfigSource> configSources;
    private final boolean negative;

    SmallRyeConfigSources(List<SmallRyeConfig.ConfigSourceWithPriority> configSourcesWithPriorities, boolean negative) {
        this.negative = negative;
        ArrayList<ConfigValueConfigSource> configSources = new ArrayList<ConfigValueConfigSource>();
        for (SmallRyeConfig.ConfigSourceWithPriority configSource : configSourcesWithPriorities) {
            if (configSource.priority() < 0 != negative) continue;
            configSources.add(ConfigValueConfigSourceWrapper.wrap(configSource.getSource()));
        }
        this.configSources = configSources;
    }

    @Override
    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        int configSourcesSize = this.configSources.size();
        for (int i = 0; i < configSourcesSize; ++i) {
            ConfigValueConfigSource configSource = this.configSources.get(i);
            ConfigValue configValue = configSource.getConfigValue(name);
            if (configValue == null) continue;
            return configValue.from().withConfigSourcePosition(i).build();
        }
        return context.proceed(name);
    }

    @Override
    public Iterator<String> iterateNames(ConfigSourceInterceptorContext context) {
        HashSet names = new HashSet();
        for (ConfigValueConfigSource configSource : this.configSources) {
            Set propertyNames = configSource.getPropertyNames();
            if (propertyNames == null) continue;
            names.addAll(propertyNames);
        }
        Iterator<String> iter = context.iterateNames();
        iter.forEachRemaining(names::add);
        return names.iterator();
    }

    boolean negative() {
        return this.negative;
    }

    static final class ConfigValueConfigSourceWrapper
    implements ConfigValueConfigSource,
    Serializable {
        private static final long serialVersionUID = -1109094614437147326L;
        private final ConfigSource configSource;

        private ConfigValueConfigSourceWrapper(ConfigSource configSource) {
            this.configSource = configSource;
        }

        @Override
        public ConfigValue getConfigValue(String propertyName) {
            String value = this.configSource.getValue(propertyName);
            if (value != null) {
                return ConfigValue.builder().withName(propertyName).withValue(value).withRawValue(value).withConfigSourceName(this.getName()).withConfigSourceOrdinal(this.getOrdinal()).build();
            }
            return null;
        }

        @Override
        public Map<String, ConfigValue> getConfigValueProperties() {
            return new ConfigValueConfigSource.ConfigValueMapStringView(this.configSource.getProperties(), this.configSource.getName(), this.configSource.getOrdinal());
        }

        @Override
        public Map<String, String> getProperties() {
            return this.configSource.getProperties();
        }

        @Override
        public String getValue(String propertyName) {
            return this.configSource.getValue(propertyName);
        }

        public Set<String> getPropertyNames() {
            return this.configSource.getPropertyNames();
        }

        public String getName() {
            return this.configSource.getName();
        }

        public int getOrdinal() {
            return this.configSource.getOrdinal();
        }

        static ConfigValueConfigSource wrap(ConfigSource configSource) {
            if (configSource instanceof ConfigValueConfigSource) {
                return (ConfigValueConfigSource)configSource;
            }
            return new ConfigValueConfigSourceWrapper(configSource);
        }
    }
}

