/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.jackson;

import com.fasterxml.jackson.core.StreamReadConstraints;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StreamReadConstraintsUtil {
    private final Map<String, String> propertyOverrides;
    private final Logger logger;
    private StreamReadConstraints configuredStreamReadConstraints;
    private static final Map<Override, Integer> JACKSON_DEFAULTS = Map.of(Override.MAX_STRING_LENGTH, 200000000, Override.MAX_NUMBER_LENGTH, 10000, Override.MAX_NESTING_DEPTH, 1000);

    public static StreamReadConstraintsUtil fromSystemProperties() {
        return new StreamReadConstraintsUtil(System.getProperties());
    }

    StreamReadConstraintsUtil(Properties properties) {
        this(properties, (Logger)null);
    }

    StreamReadConstraintsUtil(Properties properties, Logger logger) {
        this(StreamReadConstraintsUtil.extractProperties(properties), logger);
    }

    private static Map<String, String> extractProperties(Properties properties) {
        return properties.stringPropertyNames().stream().filter(propName -> propName.startsWith("logstash.jackson.stream-read-constraints.")).map(propName -> Map.entry(propName, properties.getProperty((String)propName))).filter(entry -> entry.getValue() != null).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private StreamReadConstraintsUtil(Map<String, String> propertyOverrides, Logger logger) {
        this.propertyOverrides = Map.copyOf(propertyOverrides);
        this.logger = Objects.requireNonNullElseGet(logger, () -> LogManager.getLogger(StreamReadConstraintsUtil.class));
    }

    StreamReadConstraints get() {
        if (this.configuredStreamReadConstraints == null) {
            StreamReadConstraints.Builder builder = StreamReadConstraints.defaults().rebuild();
            JACKSON_DEFAULTS.forEach((override, value) -> override.applicator.apply(builder, value));
            this.eachOverride((override, value) -> override.applicator.apply(builder, value));
            this.configuredStreamReadConstraints = builder.build();
        }
        return this.configuredStreamReadConstraints;
    }

    public void applyAsGlobalDefault() {
        StreamReadConstraints.overrideDefaultStreamReadConstraints((StreamReadConstraints)this.get());
    }

    public void validateIsGlobalDefault() {
        this.validate(StreamReadConstraints.defaults());
    }

    private void validate(StreamReadConstraints streamReadConstraints) {
        ArrayList fatalIssues = new ArrayList();
        this.eachOverride((override, specifiedValue) -> {
            Integer effectiveValue = (Integer)override.observer.apply(streamReadConstraints);
            if (Objects.equals(specifiedValue, effectiveValue)) {
                this.logger.info("Jackson default value override `{}` configured to `{}`", (Object)override.propertyName, specifiedValue);
            } else {
                fatalIssues.add(String.format("`%s` (expected: `%s`, actual: `%s`)", override.propertyName, specifiedValue, effectiveValue));
            }
        });
        for (String unsupportedProperty : this.getUnsupportedProperties()) {
            this.logger.warn("Jackson default value override `{}` is unknown and has been ignored", (Object)unsupportedProperty);
        }
        if (!fatalIssues.isEmpty()) {
            throw new IllegalStateException(String.format("Jackson default values not applied: %s", String.join((CharSequence)",", fatalIssues)));
        }
    }

    void eachOverride(BiConsumer<Override, Integer> overrideIntegerBiConsumer) {
        for (Override override : Override.values()) {
            String propValue = this.propertyOverrides.get(override.propertyName);
            if (propValue == null) continue;
            try {
                int intValue = Integer.parseInt(propValue);
                overrideIntegerBiConsumer.accept(override, intValue);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("System property `%s` must be positive integer value. Received: `%s`", override.propertyName, propValue), e);
            }
        }
    }

    Set<String> getUnsupportedProperties() {
        Set supportedProps = Arrays.stream(Override.values()).map(p -> p.propertyName).collect(Collectors.toSet());
        Set<String> providedProps = this.propertyOverrides.keySet();
        return Sets.difference(providedProps, supportedProps);
    }

    static enum Override {
        MAX_STRING_LENGTH(StreamReadConstraints.Builder::maxStringLength, StreamReadConstraints::getMaxStringLength),
        MAX_NUMBER_LENGTH(StreamReadConstraints.Builder::maxNumberLength, StreamReadConstraints::getMaxNumberLength),
        MAX_NESTING_DEPTH(StreamReadConstraints.Builder::maxNestingDepth, StreamReadConstraints::getMaxNestingDepth);

        static final String PROP_PREFIX = "logstash.jackson.stream-read-constraints.";
        final String propertyName = "logstash.jackson.stream-read-constraints." + this.name().toLowerCase().replace('_', '-');
        private final IntValueApplicator applicator;
        private final IntValueObserver observer;

        private Override(IntValueApplicator applicator, IntValueObserver observer) {
            this.applicator = applicator;
            this.observer = observer;
        }

        @FunctionalInterface
        static interface IntValueApplicator
        extends BiFunction<StreamReadConstraints.Builder, Integer, StreamReadConstraints.Builder> {
        }

        @FunctionalInterface
        static interface IntValueObserver
        extends Function<StreamReadConstraints, Integer> {
        }
    }
}

