/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import nokogiri.XmlNode;
import nokogiri.XmlNodeSet;
import nokogiri.XmlSyntaxError;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.NokogiriNamespaceContext;
import nokogiri.internals.NokogiriXPathFunctionResolver;
import nokogiri.internals.NokogiriXPathVariableResolver;
import nokogiri.internals.XalanDTMManagerPatch;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.VariableStack;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.jaxp.JAXPPrefixResolver;
import org.apache.xpath.jaxp.JAXPVariableStack;
import org.apache.xpath.objects.XObject;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.SafePropertyAccessor;
import org.w3c.dom.Node;

@JRubyClass(name={"Nokogiri::XML::XPathContext"})
public class XmlXpathContext
extends RubyObject {
    private static final long serialVersionUID = 1L;
    public static final String XPATH_CONTEXT = "CACHED_XPATH_CONTEXT";
    private XmlNode context;
    private static final String NameStartCharStr = "[_A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd]";
    private static final String NameCharStr = "[-\\.0-9\u00b7\u0300-\u036f\u203f-\u2040]|[_A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd]";
    private static final String NCNameStr = "(?:[_A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd])(?:[-\\.0-9\u00b7\u0300-\u036f\u203f-\u2040]|[_A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd])*";
    private static final String XPathFunctionCaptureStr = "((?:[_A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd])(?:[-\\.0-9\u00b7\u0300-\u036f\u203f-\u2040]|[_A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd])*(?=\\())";
    private static final Pattern XPathFunctionCaptureRE;
    private final NokogiriNamespaceContext nsContext = NokogiriNamespaceContext.create();
    private NokogiriXPathVariableResolver variableResolver;

    public XmlXpathContext(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public XmlXpathContext(Ruby ruby, RubyClass rubyClass, XmlNode xmlNode) {
        this(ruby, rubyClass);
        this.initNode(xmlNode);
    }

    private void initNode(XmlNode xmlNode) {
        this.context = xmlNode;
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static IRubyObject rbNew(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        try {
            return new XmlXpathContext(threadContext.runtime, (RubyClass)iRubyObject, (XmlNode)iRubyObject2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw threadContext.getRuntime().newRuntimeError(illegalArgumentException.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject evaluate(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        String string = iRubyObject.convertToString().asJavaString();
        if (!iRubyObject2.isNil() && !this.isContainsPrefix(string)) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            Set set = iRubyObject2.getMetaClass().getMethods().keySet();
            Matcher matcher = XPathFunctionCaptureRE.matcher(string);
            while (matcher.find()) {
                stringBuilder.append(string.subSequence(n, matcher.start()));
                n = matcher.start();
                if (set.contains(matcher.group())) {
                    stringBuilder.append("nokogiri");
                    stringBuilder.append(":");
                }
                stringBuilder.append(string.subSequence(matcher.start(), matcher.end()));
                n = matcher.end();
            }
            if (n < string.length() - 1) {
                stringBuilder.append(string.subSequence(n, string.length()));
            }
            string = stringBuilder.toString();
        }
        return this.node_set(threadContext, string, iRubyObject2);
    }

    @JRubyMethod
    public IRubyObject evaluate(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.evaluate(threadContext, iRubyObject, threadContext.getRuntime().getNil());
    }

    @JRubyMethod
    public IRubyObject register_ns(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.nsContext.registerNamespace(iRubyObject.asJavaString(), iRubyObject2.asJavaString());
        return this;
    }

    @JRubyMethod
    public IRubyObject register_variable(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        NokogiriXPathVariableResolver nokogiriXPathVariableResolver = this.variableResolver;
        if (nokogiriXPathVariableResolver == null) {
            this.variableResolver = nokogiriXPathVariableResolver = NokogiriXPathVariableResolver.create();
        }
        nokogiriXPathVariableResolver.registerVariable(iRubyObject.asJavaString(), iRubyObject2.asJavaString());
        return this;
    }

    private IRubyObject node_set(ThreadContext threadContext, String string, IRubyObject iRubyObject) {
        NokogiriXPathFunctionResolver nokogiriXPathFunctionResolver = NokogiriXPathFunctionResolver.create(iRubyObject);
        try {
            return this.tryGetNodeSet(threadContext, string, nokogiriXPathFunctionResolver);
        }
        catch (TransformerException transformerException) {
            throw XmlSyntaxError.createXMLXPathSyntaxError(threadContext.runtime, string + ": " + transformerException.toString(), transformerException).toThrowable();
        }
    }

    private IRubyObject tryGetNodeSet(ThreadContext threadContext, String string, NokogiriXPathFunctionResolver nokogiriXPathFunctionResolver) throws TransformerException {
        Node node = this.context.node;
        JAXPPrefixResolver jAXPPrefixResolver = new JAXPPrefixResolver((NamespaceContext)this.nsContext);
        XPath xPath = new XPath(string, null, (PrefixResolver)jAXPPrefixResolver, 0);
        XObject xObject = node == null ? xPath.execute(this.getXPathContext(nokogiriXPathFunctionResolver), -1, (PrefixResolver)jAXPPrefixResolver) : xPath.execute(this.getXPathContext(nokogiriXPathFunctionResolver), node, (PrefixResolver)jAXPPrefixResolver);
        switch (xObject.getType()) {
            case 1: {
                return threadContext.runtime.newBoolean(xObject.bool());
            }
            case 2: {
                return threadContext.runtime.newFloat(xObject.num());
            }
            case 4: {
                IRubyObject[] iRubyObjectArray = NokogiriHelpers.nodeListToRubyArray(threadContext.runtime, xObject.nodelist());
                return XmlNodeSet.newNodeSet(threadContext.runtime, iRubyObjectArray, this.context);
            }
        }
        return threadContext.runtime.newString(xObject.str());
    }

    private XPathContext getXPathContext(NokogiriXPathFunctionResolver nokogiriXPathFunctionResolver) {
        XPathContext xPathContext;
        Node node = this.context.getNode().getOwnerDocument();
        if (node == null) {
            node = this.context.getNode();
        }
        if ((xPathContext = (XPathContext)node.getUserData(XPATH_CONTEXT)) == null) {
            xPathContext = XmlXpathContext.newXPathContext(nokogiriXPathFunctionResolver);
            if (this.variableResolver == null) {
                node.setUserData(XPATH_CONTEXT, xPathContext, null);
            }
        } else {
            Object object = xPathContext.getOwnerObject();
            if ((object == null && nokogiriXPathFunctionResolver == null || object instanceof JAXPExtensionsProvider && ((JAXPExtensionsProvider)((Object)object)).hasSameResolver(nokogiriXPathFunctionResolver)) && this.variableResolver == null) {
                return xPathContext;
            }
            xPathContext = XmlXpathContext.newXPathContext(nokogiriXPathFunctionResolver);
        }
        if (this.variableResolver != null) {
            xPathContext.setVarStack((VariableStack)new JAXPVariableStack((XPathVariableResolver)this.variableResolver));
        }
        return xPathContext;
    }

    private static XPathContext newXPathContext(NokogiriXPathFunctionResolver nokogiriXPathFunctionResolver) {
        if (nokogiriXPathFunctionResolver == null) {
            return new XPathContext(false);
        }
        return new XPathContext((Object)new JAXPExtensionsProvider(nokogiriXPathFunctionResolver), false);
    }

    private boolean isContainsPrefix(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : this.nsContext.getAllPrefixes()) {
            stringBuilder.setLength(0);
            stringBuilder.ensureCapacity(string2.length() + 1);
            stringBuilder.append(string2).append(':');
            if (!string.contains(stringBuilder)) continue;
            return true;
        }
        return false;
    }

    static {
        if (SafePropertyAccessor.getProperty((String)"org.apache.xml.dtm.DTMManager") == null) {
            try {
                System.setProperty("org.apache.xml.dtm.DTMManager", XalanDTMManagerPatch.class.getName());
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        XPathFunctionCaptureRE = Pattern.compile(XPathFunctionCaptureStr);
    }

    private static final class JAXPExtensionsProvider
    extends org.apache.xpath.jaxp.JAXPExtensionsProvider {
        final NokogiriXPathFunctionResolver resolver;

        JAXPExtensionsProvider(NokogiriXPathFunctionResolver nokogiriXPathFunctionResolver) {
            super((XPathFunctionResolver)nokogiriXPathFunctionResolver, false);
            this.resolver = nokogiriXPathFunctionResolver;
        }

        final boolean hasSameResolver(NokogiriXPathFunctionResolver nokogiriXPathFunctionResolver) {
            return nokogiriXPathFunctionResolver == this.resolver || nokogiriXPathFunctionResolver != null && (nokogiriXPathFunctionResolver.getHandler() == null ? this.resolver.getHandler() == null : nokogiriXPathFunctionResolver.getHandler() == this.resolver.getHandler());
        }
    }
}

