/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Vector;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.impl.sql.execute.rts.RealNoPutResultSetStatistics;
import org.apache.derby.shared.common.i18n.MessageService;

public class RealIndexRowToBaseRowStatistics
extends RealNoPutResultSetStatistics {
    public String tableName;
    public ResultSetStatistics childResultSetStatistics;
    public String colsAccessedFromHeap;

    public RealIndexRowToBaseRowStatistics(int numOpens, int rowsSeen, int rowsFiltered, long constructorTime, long openTime, long nextTime, long closeTime, int resultSetNumber, String tableName, FormatableBitSet colsAccessedFromHeap, double optimizerEstimatedRowCount, double optimizerEstimatedCost, ResultSetStatistics childResultSetStatistics) {
        super(numOpens, rowsSeen, rowsFiltered, constructorTime, openTime, nextTime, closeTime, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.tableName = tableName;
        this.colsAccessedFromHeap = colsAccessedFromHeap == null ? "{" + MessageService.getTextMessage((String)"43X59.U", (Object[])new Object[0]) + "}" : colsAccessedFromHeap.toString();
        this.childResultSetStatistics = childResultSetStatistics;
    }

    @Override
    public String getStatementExecutionPlanText(int depth) {
        this.initFormatInfo(depth);
        return this.indent + MessageService.getTextMessage((String)"43X60.U", (Object[])new Object[]{this.tableName}) + ":\n" + this.indent + MessageService.getTextMessage((String)"43X03.U", (Object[])new Object[0]) + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage((String)"43X04.U", (Object[])new Object[0]) + " = " + this.rowsSeen + "\n" + this.indent + MessageService.getTextMessage((String)"43X61.U", (Object[])new Object[0]) + " = " + this.colsAccessedFromHeap + "\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + this.dumpEstimatedCosts(this.subIndent) + "\n" + this.childResultSetStatistics.getStatementExecutionPlanText(this.sourceDepth) + "\n";
    }

    @Override
    public String getScanStatisticsText(String tableName, int depth) {
        if (tableName == null || tableName.equals(this.tableName)) {
            return this.getStatementExecutionPlanText(depth);
        }
        return "";
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    @Override
    public Vector<ResultSetStatistics> getChildren() {
        Vector<ResultSetStatistics> children = new Vector<ResultSetStatistics>();
        children.addElement(this.childResultSetStatistics);
        return children;
    }

    @Override
    public String getNodeOn() {
        return MessageService.getTextMessage((String)"43X62.U", (Object[])new Object[]{this.tableName});
    }

    @Override
    public String getNodeName() {
        return MessageService.getTextMessage((String)"43X63.U", (Object[])new Object[0]);
    }

    ResultSetStatistics getChildResultSetStatistics() {
        return this.childResultSetStatistics;
    }

    @Override
    public void accept(XPLAINVisitor visitor) {
        int noChildren = 0;
        if (this.childResultSetStatistics != null) {
            ++noChildren;
        }
        visitor.setNumberOfChildren(noChildren);
        visitor.visit(this);
        if (this.childResultSetStatistics != null) {
            this.childResultSetStatistics.accept(visitor);
        }
    }

    @Override
    public String getRSXplainType() {
        return "ROWIDSCAN";
    }

    @Override
    public String getRSXplainDetails() {
        return "(" + this.resultSetNumber + ")," + this.tableName;
    }
}

