/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * normalize(dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)) => dvec3(-0.7248220596224368lf, -0.46207406300930354lf, -0.510999552033818lf)
 * normalize(dvec3(1.67lf, 0.66lf, 1.87lf)) => dvec3(0.6441493906912401lf, 0.2545740106923464lf, 0.7212930302949815lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(normalize(dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)), dvec3(-0.7248220596224368lf, -0.46207406300930354lf, -0.510999552033818lf)) <= 9.999999999999999e-06lf ? 1 : -1] array0;
  double[distance(normalize(dvec3(1.67lf, 0.66lf, 1.87lf)), dvec3(0.6441493906912401lf, 0.2545740106923464lf, 0.7212930302949815lf)) <= 9.999999999999999e-06lf ? 1 : -1] array1;
  gl_Position = vec4(array0.length() + array1.length());
}
